chcp 65001
 
@echo off
if %1=="" goto no_compiler
if %2=="" goto no_build_dir
rem -Clinker=lld -Zuse-embedded-lld
rem путь до компилятора
set COMPILER=%1

set BUILD_DIR=%2
 
if not exist %BUILD_DIR% mkdir %BUILD_DIR%

@echo on
%COMPILER% -o %BUILD_DIR%\libsys_prg.so @sys_src.dat @sys_libs.dat @errors.dat -Zgenerate-rtti -Z enums-auto-glob=no -C link-self-contained  --crate-type dylib --target aarch64-oe-linux -Clinker=lld -Zuse-embedded-lld -lc_nonshared %~3 %~4 %~5 %~6 %~7

IF ERRORLEVEL 1  goto erro libsysprgerror

%COMPILER% -o %BUILD_DIR%\plc_prg.out code\main.st  -C link-self-contained -Crelocation-model=dynamic-no-pic -L%BUILD_DIR% -lsys_prg --target aarch64-oe-linux -Clinker=lld -Zuse-embedded-lld -lc_nonshared %~3 %~4 %~5 %~6 %~7

IF ERRORLEVEL 1  goto erro plcprgerror


%COMPILER% -o %BUILD_DIR%\libplc_prg.so @usr_src.dat @usr_libs.dat @errors.dat -g -Zgenerate-rtti -Zprivate-rtti-symbols -Z enums-auto-glob=no -L%BUILD_DIR% -lsys_prg -C link-self-contained --crate-type dylib --target aarch64-oe-linux -Clinker=lld -Zuse-embedded-lld -lc_nonshared %~3 %~4 %~5 %~6 %~7

IF ERRORLEVEL 1  goto erro libplcprgerror

goto end
:libsysprgerror
echo ______________________________PLC_PRG library error_____________________________
exit /b 1

:libsysprgerror
echo ______________________________SYS PRG library error_____________________________
exit /b 2

:plcprgerror
echo ______________________________PLC_PRG error_____________________________________
exit /b 3

:no_compiler
echo ______________________________need compiler_____________________________________
exit /b 4

:no_build_dir
echo ______________________________need build_dir_____________________________________
exit /b 5

:end
