#!/bin/bash
export COMPILER=$1
export BUILD_DIR=$2
# Проверка входных параметров
if [ "x$1" == "x" ];
then
    echo ______________________________need compiler_____________________________________
    exit -4
fi

if [ "x$2" == "x" ];
then
    echo ______________________________need toolchain_____________________________________
    exit -5
fi

#Создание каталога для сборки, если он не существует
if [ ! -e "$BUILD_DIR" ];
then
 mkdir "$BUILD_DIR"
fi

export PLC_USE_NEXT=1

$COMPILER  -o $BUILD_DIR/libsys_prg.so @sys_src.dat @sys_libs.dat @errors.dat -Zgenerate-rtti -Z private-rtti-symbols -Z enums-auto-glob=no -C link-self-contained   --crate-type dylib --target aarch64-oe-linux -Clinker=lld -Zuse-embedded-lld -lc_nonshared


if [ "$?" != "0" ];
then
    echo ______________________________SYS PRG library error_____________________________
    exit -1
fi
$COMPILER -o $BUILD_DIR/plc_prg.out code/main.st -C link-self-contained -Crelocation-model=dynamic-no-pic -L$BUILD_DIR -lsys_prg --target aarch64-oe-linux -Clinker=lld -Zuse-embedded-lld -lc_nonshared 

if [ "$?" != "0" ];
then
    echo ______________________________PLC_PRG error_____________________________________
    exit -2
fi

$COMPILER -o $BUILD_DIR/libplc_prg.so @usr_src.dat @usr_libs.dat @errors.dat -g -Zgenerate-rtti -Z private-rtti-symbols -Z enums-auto-glob=no -C link-self-contained -L$BUILD_DIR -lsys_prg  --crate-type dylib --target aarch64-oe-linux -Clinker=lld -Zuse-embedded-lld -lc_nonshared
if [ "$?" != "0" ];
then
    echo ______________________________PLC_PRG library error_____________________________
    exit -3
fi

rm $BUILD_DIR/*.0.scgu.o