(*
Базовый компонент runtime - библиотека диспетчера компонентов.
Интерфейс FAL_ENTER_IF не имеет, запускается как библиотека в секции INIT первым.


#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include "fal_dispatcher.h"
#include "hsal_thread.h"
#include "hsal_sleep.h"
#include <library/abstract_types.h>
#include "hsal_sleep.h"

*)





VAR_GLOBAL
	a:LWORD; //Тестовая переменная
END_VAR

VAR_GLOBAL 
	fal_dispatcher_res:FAL_STATUS:=FAL_STATUS.FALL;//static FAL_STATUS res=FAL_STATUS.FALL;
	fal_control_thread: HSAL_Thread;//static HSAL_Thread fal_control_thread;
END_VAR


TYPE FAL_DISPATCHER_STATUS:
STRUCT
	handle: 	FAL_HANDLE; //Указатель на интерфейс экземпляра
	inst_num:	DWORD; //номер экземпляра - для поиска по номеру экземпляра
	status: 	FAL_STATUS;
END_STRUCT
END_TYPE


TYPE FAL_DISPATCHER_STATUSES:
STRUCT
	count: DINT;
	components_array: ARRAY [0..COUNT_OF_COMPONENTS-1] OF FAL_DISPATCHER_STATUS; //Статусы всех экземпляров + указатель на интерфейсы экземпляров компонентов
END_STRUCT
END_TYPE

VAR_GLOBAL
	fal_statuses:FAL_DISPATCHER_STATUSES; //static FAL_DISPATCHER_STATUSES fal_statuses;

END_VAR



VAR_GLOBAL
	fal_control_foo_counter:size_t:=0;
END_VAR	


FUNCTION fal_control_foo : VOID
VAR_INPUT
	args: REF_TO VOID; 
END_VAR
VAR
	pcur: REF_TO FAL_DISPATCHER_STATUS;
	pIF: REF_TO FAL_ENTER_IF;
	control : STACK_CONTROL := (name:='fal_control_foo_task');
END_VAR
	//Выход из функции только приотсутствии компонентов для обработки. Функция обящана запускаться в отдельной задаче
	WHILE (TRUE) DO
		CONTROL_STACK(ADR(control));
		hsal_sleep_for_ms(1000);
		 
		IF (fal_control_foo_counter>=ULINT#(fal_statuses.count)) THEN
			fal_control_foo_counter:=0;
		ELSE
			pcur:=ADR(fal_statuses.components_array[fal_control_foo_counter]);
			pIF:=pcur^.handle;
			
			IF (pIF<>NULL)  THEN
				IF (pIF^.CheckFal<>NULL) THEN
					pcur^.status:=pIF^.CheckFal^(CAST(pIF,REF_TO FAL_HANDLE));
				END_IF;
			END_IF;
			
			fal_control_foo_counter:=fal_control_foo_counter+1;
			
		END_IF;
		IF (fal_statuses.count=0) THEN
			RETURN;
		END_IF;
	END_WHILE;
END_FUNCTION







FUNCTION fal_control_init : FAL_STATUS


//Подготавливаем начальный массив для статусов - устарело, массив статический, т.к. при кодогенерации мы знаем число экземпляров компонентов
	fal_statuses.count:=0;
	//COUNT_OF_COMPONENTS=FAL_DISPATCHER_INIT_COMPONENTS_COUNT;
	//fal_statuses.components_array=malloc(sizeof(FAL_DISPATCHER_STATUS)*COUNT_OF_COMPONENTS);
	memset (ADR(fal_statuses.components_array[0]),16#00,sizeof(FAL_DISPATCHER_STATUS)*COUNT_OF_COMPONENTS);

	fal_control_init:=FAL_STATUS.OK;
END_FUNCTION


FUNCTION fal_control_run : FAL_STATUS
	VAR
		ret: DINT; 
		pftemp:REF_TO typedef_hsal_thread_worker;
	END_VAR
	hsal_thread_constructor(ADR(fal_control_thread));
	pftemp:=ADR(fal_control_foo);
	fal_control_thread.attrs.priority:=0;
    fal_control_thread.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := fal_control_thread.create^(ADR(fal_control_thread), NULL, pftemp);
	IF (ret < 0) THEN
		printf('Thread fal_control not started$N');
		fal_control_run:=FAL_STATUS.ERROR_INIT;
		RETURN;
	END_IF
	ret := fal_control_thread.runtime_set_name^(ADR(fal_control_thread), 'fal_control_thread');
	if (ret < 0) THEN
		printf('Thread error %d - not change name to fal_control_thread$N',ret); 
	END_IF
	fal_control_run:=FAL_STATUS.OK;
END_FUNCTION


FUNCTION fal_control_deinit : VOID
	fal_control_thread.stop_force^(ADR(fal_control_thread));
	fal_statuses.count:=0;
END_FUNCTION


FUNCTION fal_control_get_last_error : FAL_STATUS
 	fal_control_get_last_error:=fal_dispatcher_res;
END_FUNCTION



FUNCTION AddToArray : VOID
VAR_INPUT
	handle: FAL_HANDLE; 
	inst_num:DWORD;
END_VAR
VAR
	i: DINT; 
END_VAR
IF ((fal_statuses.count+1)>COUNT_OF_COMPONENTS) THEN 
	//теперь массив статический (размер гененрируется кодогенератором) и это критичная ошибка
	printf('Error: COUNT_OF_COMPONENTS=%d is too small$N',COUNT_OF_COMPONENTS);
	exit_with_code (99);
END_IF

IF ((fal_statuses.count)<0) THEN 
	//Защита от слишком маленького значения
	printf('Error: fal_statuses.count=%d is too small$N',fal_statuses.count);
	exit_with_code (99);
END_IF
	
	a:=handle;
	printf('Add to control %p at [%d]$N', a,fal_statuses.count); 
	i:=fal_statuses.count;
	fal_statuses.components_array[i].handle := handle;
	fal_statuses.components_array[i].inst_num:=inst_num; 
	fal_statuses.components_array[i].status := FAL_STATUS.OK;
	fal_statuses.count:=i+1;
END_FUNCTION



FUNCTION fal_control_add_component : FAL_HANDLE
VAR_INPUT
	pIF: REF_TO FAL_ENTER_IF; 
	inst_num:DWORD;
END_VAR
VAR
	handle: FAL_HANDLE; 
END_VAR
VAR 
	i: DINT:=0;
END_VAR

	fal_control_add_component:=NULL;
	//Проверяем
	IF (NULL=pIF) THEN RETURN; END_IF
	//1. запускаем InitFal
	handle:=NULL;
	fal_dispatcher_res:=pIF^.InitFal^(inst_num,handle);
	IF (fal_dispatcher_res<>FAL_STATUS.OK) THEN
		RETURN;
	END_IF;
	assert('pIF^.InitFal() failed$N',handle<>0);//Не должно происходить по идее
	//2. проверяем список на наличие такого же handle

	IF (fal_statuses.count=0) THEN
		//Добавляем handle в массив 
		AddToArray(handle,inst_num);
	ELSE	
		FOR i:=0 TO fal_statuses.count-1 DO
			IF fal_statuses.components_array[i].handle = handle THEN
				IF fal_statuses.components_array[i].inst_num = inst_num THEN //2-е вхождение статического элемента с одинаковым inst_num - ошибка в кодогенераторе
					printf('Dublicate init of static components %d $N',fal_statuses.count);//Нашли такой же handle - значит повторная инициализация статического компонента, это ошибка!!!
					exit(106);
				ELSE //второе вхождение статического экземпляра с РАЗНЫМИ inst_num - ошибка в реализации компонента
					printf('Dublicate return handle of dynamic components %d $N',fal_statuses.count);
					exit(107);
				END_IF
			ELSE
				//Добавляем handle в массив 
				AddToArray(handle,inst_num);
				EXIT
			END_IF;
		END_FOR
	END_IF	
	fal_control_add_component:=handle; 	
END_FUNCTION



FUNCTION fal_control_get_instance: FAL_HANDLE
VAR_INPUT
	pIF: REF_TO FAL_ENTER_IF;
	inst_num: DWORD;
END_VAR
VAR 
	i: DINT:=0;
	tIF 	: REF_TO VOID;
END_VAR

	fal_dispatcher_res:=FAL_STATUS.BAD_IF;
	fal_control_get_instance:=NULL;
	IF (0=pIF) THEN 
		printf('fal_control_get_instance pIf=0$N');
		RETURN; 
	END_IF;
	FOR i:=0 TO fal_statuses.count-1 DO
		tIF := pIF; //затычка компилятора
		IF fal_statuses.components_array[i].handle = tIF THEN 
			IF fal_statuses.components_array[i].inst_num = inst_num THEN
				fal_control_get_instance:=fal_statuses.components_array[i].handle;
				fal_dispatcher_res:=FAL_STATUS.OK;
				RETURN;
			END_IF;
		END_IF;
	END_FOR
	printf('fal_control_get_instance NO_INSTANCES for %p$N',pIF);
	FOR i:=0 TO fal_statuses.count-1 DO
		printf ('[%d]handle=%p',i,fal_statuses.components_array[i].handle);
	END_FOR

	fal_dispatcher_res:=FAL_STATUS.NO_INSTANCES;
END_FUNCTION


FUNCTION fal_control_delete_component : FAL_STATUS
VAR_INPUT
	pIF: REF_TO FAL_ENTER_IF;
	inst_num: DWORD;
END_VAR
VAR 
	pHandle: REF_TO FAL_HANDLE;
	i:	DINT;
	tIF 	: REF_TO VOID;
END_VAR
	fal_dispatcher_res:=FAL_STATUS.OK;
	IF (pIF=0) THEN
		fal_dispatcher_res:=FAL_STATUS.BAD_CONTEXT;
		fal_dispatcher_res:=FAL_STATUS.BAD_IF;
	ELSE
		pHandle:=CAST(pIF,REF_TO FAL_HANDLE);
		fal_dispatcher_res:=pIF^.DeInitFal^(pHandle);
	END_IF
	//независимо от результата - убираем компонент из списка
	FOR i:=fal_statuses.count-1 TO 0 BY -1 DO
		tIF := pIF; //затычка компилятора
		IF fal_statuses.components_array[i].handle = tIF THEN 
			IF fal_statuses.components_array[i].inst_num = inst_num THEN
				fal_statuses.components_array[i].handle:=NULL;
			END_IF;
		END_IF;
	END_FOR
END_FUNCTION


FUNCTION fal_control_component_status : FAL_STATUS
VAR_INPUT
	handle: FAL_HANDLE;
END_VAR
VAR
	pelem: REF_TO FAL_DISPATCHER_STATUS;
	i:		DINT;
END_VAR
	FOR i:=0 TO fal_statuses.count DO
		pelem:=ADR(fal_statuses.components_array[i]);
		IF (pelem^.handle=handle) THEN 
			fal_dispatcher_res:=FAL_STATUS.OK;
			fal_control_component_status:=pelem^.status;
			RETURN;  
			END_IF
	END_FOR;
	fal_dispatcher_res:=FAL_STATUS.NO_INSTANCES;
	fal_control_component_status:=fal_dispatcher_res;
END_FUNCTION