VAR_GLOBAL CONSTANT //Массив для статической регистрации на пользовательские события
    cMB_dynamic_size    : DWORD :={#num_of(%add_MB_element%)};
END_VAR
//В ОЗУ из-за ошибки компилятора https://rnd.owen.ru/softlogicowen/rusty_new/-/issues/88
VAR_GLOBAL  //Массив для статической регистрации на пользовательские события
    cMB_dynamic_array   : ARRAY [0..{#num_of(%add_MB_element%)}] OF DYNAMIC_MB_ELEMENT :=[
                            {%add_MB_element[,]%}
                            ( 
                                message_id := 0,
                                callback   := NULL
                            )
                            ];
END_VAR


VAR_GLOBAL 
    //циклический буффер для хранения сообщений
    MB_buffer           : MB_MESSAGE_BUFFER;
    MB_sorted_array     : MB_SORTED_ARRAY;   
    MB_thread           : HSAL_Thread;
    MB_mutex            : HSAL_Mutex;
    MB_sema             : HSAL_Sema;
    MB_ready_flag       : BOOL;
END_VAR

//В рантайме при запуске осуществится сортировка массива ID
FUNCTION MB_count_unique_elements : DWORD
VAR_INPUT
    parray      : REF_TO DYNAMIC_MB_ELEMENT;
    len         : size_t;
END_VAR

VAR
    unique      : DWORD;
    inner       : DINT;
    outer       : DINT;
    is_unique   : DINT;
    
    pinner      : REF_TO DYNAMIC_MB_ELEMENT;
    pouter      : REF_TO DYNAMIC_MB_ELEMENT;
END_VAR
    MB_count_unique_elements := 0;
    IF (len = 0) THEN RETURN; END_IF
     unique := 1;
    FOR outer := 1 TO DINT#(len-1) DO
        is_unique := 1;
        inner := 0;
        WHILE (is_unique>0) AND (inner < outer) DO
            
            pinner:=parray + inner;
            pouter:=parray + outer;
            //printf('outer=%d ID[%d]=%d$N',outer,inner,pinner^.message_id);
            IF pinner^.message_id = pouter^.message_id THEN  is_unique := 0; END_IF
            inner:=inner+1;
        END_WHILE;
        IF (is_unique>0) THEN unique :=unique+1; END_IF
    END_FOR;
    //printf('unique=%d$N',unique);
    MB_count_unique_elements := unique;
END_FUNCTION

//Добавляем элементы в массивы однотипных БЕЗ сортировки
//Логика проста - Берем первый в списке, 
//проверяем что его ещё не добавили
//считаем число вхождений
//выделяем память под все
//вторым проходом добавляем
//Далее повторяем для следующих

FUNCTION MB_add_elements : VOID
VAR_INPUT
    parray      : REF_TO DYNAMIC_MB_ELEMENT;
    len         : size_t;
    psorted     : REF_TO MB_SORTED_ARRAY;
END_VAR

VAR
    unique      : DWORD; //текущий номер сообщения
    finden      : DINT; //индекс для перебора
    checked     : DINT; //Индекс для поиска вхождений
    is_unique   : DINT; 
    temp        : DWORD;
    sorted_count: DINT := 0; //Число уже отсортированных вхождений
    
    pSE         : REF_TO MB_SORTED_ELEM;
    pDE         : REF_TO DYNAMIC_MB_ELEMENT;
    pDE_temp    : REF_TO REF_TO DYNAMIC_MB_ELEMENT;
    pmalloc     : REF_TO DYNAMIC_MB_ELEMENT;

END_VAR


    ////printf('NNN $N0=%lx$N1=%lx size=%d$N',psorted^.parray_ID,psorted^.parray_ID+1,sizeof(MB_SORTED_ELEM));
    
    IF (len = 0) THEN RETURN; END_IF
    IF (psorted^.parray_ID = 0) THEN RETURN; END_IF
    unique := 1;

    FOR finden := 0 TO DINT#(len-1) DO
        pDE := parray + finden;
        unique := pDE^.message_id;
        is_unique := 1; // Первый проход - смотрим нет ли заполненных Sorted
        FOR checked := 0 TO sorted_count-1 DO
            pSE := psorted^.parray_ID + checked; 
            //printf('next [%d]$N',checked);
            pDE_temp := pSE^.parray_elem;
            IF (pDE_temp <> 0) THEN
                //printf('next [%d]=%d$N',checked,unique);
                IF pDE_temp^^.message_id = unique THEN
                    //printf('EQ$N');
                    is_unique := 0;
                    EXIT;                   
                END_IF;
            END_IF
        END_FOR;
        IF is_unique = 0 THEN CONTINUE; END_IF //Следующий элемент проверяем
        //нашли новый message_id - считаем его вхождения 
        temp :=0;
        FOR checked := 0 TO DINT#(len-1) DO
            pDE := parray + checked; 
            IF (pDE^.message_id = unique) THEN
                temp := temp + 1;               
            END_IF
        END_FOR;
        //printf('%d has %d inst $N',unique, temp);
        //Выделяем память
        pSE := psorted^.parray_ID + finden;
        pSE^.count := temp;
        pSE^.parray_elem := malloc (sizeof(fucked_rusty_compiller_pointer)*DWORD#temp);
        //printf('pSE^.parray_elem[%d]=%lx$N',pSE^.count,pSE^.parray_elem);
        //printf('PPP $N0=%lx$N1=%lx size=%d$N',pSE^.parray_elem,pSE^.parray_elem+1,sizeof(fucked_rusty_compiller_pointer));
        //Заполняем массив указателями на константные ячейки
        temp := 0;
        FOR checked := 0 TO DINT#(len-1) DO
            pDE := parray + checked; 
            IF (pDE^.message_id = unique) THEN
                pDE_temp := pSE^.parray_elem + temp;
                //printf('pDE=%lx pSE^.parray_elem + temp=%lx$N',pDE, pDE_temp);
                pDE_temp^ := pDE;
                temp := temp + 1;   
                //printf('Add %d with %lx $N',unique, pDE);            
            END_IF
        END_FOR;

        sorted_count := sorted_count+1;

    END_FOR;
    //printf('sorted_count=%d$N',sorted_count);

END_FUNCTION

FUNCTION MB_QUICK_SORT : VOID
VAR_INPUT
    element_list    : REF_TO MB_SORTED_ELEM;
    low             : DWORD;
    high            : DWORD;
END_VAR
VAR
    pivot           : DWORD;
    value1          : DWORD;
    value2          : DWORD;
    temp            : REF_TO MB_SORTED_ELEM := NULL;
    pSE             : REF_TO MB_SORTED_ELEM := NULL;
    pSE2            : REF_TO MB_SORTED_ELEM := NULL;
END_VAR
    //printf('%lx, l=%d h=%d$N',element_list,low,high);
    IF high<=low THEN RETURN END_IF;
    pivot := low;
    value1 := low;
    value2 := high;
    WHILE value1<value2 DO
        WHILE TRUE DO
            pSE := element_list + value1;
            pSE2 := element_list + pivot;
            //printf('#%lx %lx$N',pSE,pSE2);
            //printf('Z%lx %lx$N',pSE^.parray_elem,pSE2^.parray_elem);
            //printf('ZZ%lx %lx$N',pSE^.parray_elem^,pSE2^.parray_elem^);
            IF (pSE^.parray_elem^^.message_id<=pSE2^.parray_elem^^.message_id) AND (value1 <= high) THEN
                value1 := value1 + 1;
            ELSE
                EXIT;
            END_IF
            IF value1>=high THEN EXIT; END_IF
        END_WHILE;
        //printf('-$N');
        WHILE TRUE DO
            pSE := element_list + value2;
            pSE2 := element_list + pivot;
            //printf('* %lx %lx$N',pSE,pSE2);
            IF (pSE^.parray_elem^^.message_id>pSE2^.parray_elem^^.message_id) AND (value2 >= low) THEN
                value2 := value2 - 1;
            ELSE
                EXIT;
            END_IF
            IF value2<low THEN EXIT; END_IF
        END_WHILE;
        //printf('?$N');
        IF value1 < value2 THEN
            //printf('IN l=%d h=%d$N',value1,value2);
            temp := element_list + value1;
            pSE := element_list + value1;
            pSE := element_list + value2;
            pSE2 := element_list + value2;
            pSE2 := temp;
        END_IF;
    END_WHILE
    //printf('!$N');
    IF (value2<>pivot) THEN
        temp := element_list + value2;
        pSE := element_list + value2;
        pSE := element_list + pivot;
        pSE := element_list + pivot;
        pSE := temp;
    END_IF
    //printf('<- $N');
    MB_QUICK_SORT(element_list, low, value2 - 1);
    //printf('-> $N');
    MB_QUICK_SORT(element_list, value2 + 1, high);
    //printf('END$N');
END_FUNCTION


FUNCTION SORT_MB_ELEMS : VOID
VAR
    i       : DINT;
    j       : DINT;
    pSE     : REF_TO MB_SORTED_ELEM;
END_VAR
    IF (cMB_dynamic_size=0) THEN RETURN; END_IF
    //Сначала выясним число событий, на которые есть подписанты
    MB_sorted_array.count :=MB_count_unique_elements(ADR(cMB_dynamic_array[0]),cMB_dynamic_size);
    //Выделяем память для уникальных заголовков элементов
    MB_sorted_array.parray_ID := malloc (sizeof(MB_SORTED_ELEM)*MB_sorted_array.count);
    IF MB_sorted_array.parray_ID=0 THEN
        printf('Error malloc %d bytes$N',sizeof(MB_SORTED_ELEM)*MB_sorted_array.count);
        exit_with_code (201);
    END_IF
    memset(MB_sorted_array.parray_ID,16#00,sizeof(MB_SORTED_ELEM)*MB_sorted_array.count);
    MB_add_elements(ADR(cMB_dynamic_array[0]),cMB_dynamic_size,ADR(MB_sorted_array));
    //printf('F%lx->%lx$N',MB_sorted_array.parray_ID,MB_sorted_array.parray_ID^.parray_elem);
    //Cортировка
    MB_QUICK_SORT(MB_sorted_array.parray_ID, 0, MB_sorted_array.count-1);
    //printf('G%lx->%lx$N',MB_sorted_array.parray_ID,MB_sorted_array.parray_ID^.parray_elem);
    //Заполняем min/max для облегчения поиска
    MB_sorted_array.min_id := MB_sorted_array.parray_ID^.parray_elem^^.message_id;
    MB_sorted_array.max_id := (MB_sorted_array.parray_ID+(MB_sorted_array.count-1))^.parray_elem^^.message_id;
END_FUNCTION


/*
Возвращает по message_id указатель на MB_SORTED_ELEM или NULL если нет обработчика
 */
FUNCTION GET_SORTED_MB_ELEM : REF_TO MB_SORTED_ELEM
VAR_INPUT
    message_id : DWORD;
END_VAR

VAR
    i           : DWORD;
    pSE         : REF_TO MB_SORTED_ELEM;
    start       : DWORD;
    end         : DWORD;
    halb        : DWORD;
    temp        : DWORD;
END_VAR
    GET_SORTED_MB_ELEM := NULL;
    IF cMB_dynamic_size=0 THEN RETURN; END_IF
    IF MB_sorted_array.min_id>message_id THEN RETURN; END_IF
    IF MB_sorted_array.max_id<message_id THEN RETURN; END_IF
    start := 0;
    end   := MB_sorted_array.count-1;

    WHILE TRUE DO
        halb :=  end-start; 
        IF (halb<6) THEN //для небольшого числа бинарный не производителен
            FOR i:=start TO end DO
                pSE := MB_sorted_array.parray_ID + i;
                IF pSE^.parray_elem^^.message_id = message_id THEN
                    GET_SORTED_MB_ELEM := pSE;
                    RETURN;
                END_IF
            END_FOR
            EXIT;
        ELSE
            halb := start + halb/2;
            pSE  := MB_sorted_array.parray_ID + halb;
            temp := pSE^.parray_elem^^.message_id;
            IF message_id>temp THEN
                start := halb+1; 
            ELSIF message_id<temp THEN
               end := halb-1; 
            ELSE
                GET_SORTED_MB_ELEM := pSE;
                RETURN;
            END_IF
        END_IF
    END_WHILE;
END_FUNCTION


FUNCTION  MB_PRG : VOID
VAR_INPUT 
	args    : REF_TO VOID; 
END_VAR
VAR
    res: MESSAGE_ERRORS; 
    temp: DINT;
    next: DINT;
    control : STACK_CONTROL := (name:='MB_PRG');
END_VAR
    printf('MB_PRG start$N');
    MB_mutex.lock^(ADR(MB_mutex));
    MB_ready_flag := TRUE;
    MB_mutex.unlock^(ADR(MB_mutex));

    WHILE TRUE DO
        CONTROL_STACK(ADR(control));
        MB_sema.wait^(ADR(MB_sema),-1);
        res := MESSAGE_ERRORS.NO_ERRORS;
        //Предполагаем что есть сообщение
        temp := MB_buffer.head; //Т.к. head извне не модифицируется её можно читать без мютекса
        IF (temp <> MB_buffer.tail) THEN //Т.к. MB_buffer.tail извне может только расти и никогда не сраняется с head сравнивать можно без мютекса
            next := temp + 1;
            IF (next >= MB_buffer.size) THEN next :=0; END_IF
            //printf('Sending %d place [%d]',MB_buffer.buffer[temp].message_id,temp);
            res := SEND_MESSAGE (MB_buffer.buffer[temp].message_id, MB_buffer.buffer[temp].message_size, MB_buffer.buffer[temp].message_data);
            IF (MB_buffer.buffer[temp].pcallback <> 0) THEN
                MB_buffer.buffer[temp].pcallback^(res, MB_buffer.buffer[temp].message_id, MB_buffer.buffer[temp].message_size, MB_buffer.buffer[temp].message_data);
            END_IF
            MB_mutex.lock^(ADR(MB_mutex));
            MB_buffer.head := next;
            MB_mutex.unlock^(ADR(MB_mutex));
        END_IF
    END_WHILE;
END_FUNCTION

FUNCTION message_brocker_Init : FAL_STATUS
VAR
    i,j:DINT;
    ret:DINT;
END_VAR 
    message_brocker_Init:=FAL_STATUS.ERROR_INIT;
    printf('Message brocker component activation... $N');
    SORT_MB_ELEMS();

    //готовим мютекс
    hsal_mutex_constructor(ADR(MB_mutex));
    MB_mutex.init^(ADR(MB_mutex));

    //Готовим семафор
    hsal_sema_constructor(ADR(MB_sema));
    MB_sema.open^(ADR(MB_sema),'MB_message_sema',0);
  
    //Создаём задачи 
    MB_buffer.head :=0; //очищаем буффер
    MB_buffer.tail :=0;
    hsal_thread_constructor(ADR(MB_thread));
	MB_thread.attrs.priority:=99;
	MB_thread.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := MB_thread.create^(ADR(MB_thread), NULL, ADR(MB_PRG));
	IF (ret < 0) THEN
		printf('Thread MB_thread not started$N'); 
        //Это критическая ошибка, выходим
        exit_with_code (200);
	END_IF
    ret :=MB_thread.runtime_set_name^(ADR(MB_thread), 'MB_thread');
	if (ret < 0) THEN
		printf('Thread error %d - not change name to MB_thread$N',ret); 
	END_IF
    WHILE TRUE DO
        MB_mutex.lock^(ADR(MB_mutex));
        IF MB_ready_flag = TRUE THEN MB_mutex.unlock^(ADR(MB_mutex)); EXIT; END_IF
        MB_mutex.unlock^(ADR(MB_mutex));
        hsal_sleep_for_ms(10);
    END_WHILE;
    
    printf('Complited MB$N');
END_FUNCTION

/*
Функция неблокирующая
 */
FUNCTION MB_SEND_MESSAGE : BOOL //если возвращаемое=FALSE, то сообщение не принять (нет функционала брокера/переполнен буфер)
VAR_INPUT
   message_id   : DWORD;
   message_size : USIZE; //Размер дополнительного поля данных, если данных нет - то =0
   message_data : REF_TO VOID; //Если данных нет - может быть NULL

   pcallback    : REF_TO typedef_MB_ALL_SEND_CALLBACK; //Опциональный указатель на функцию, которую вызовут когда сообщение будет отправлено
END_VAR
VAR
    temp: DINT;
    next: DINT;
END_VAR
    MB_SEND_MESSAGE := TRUE;
    //брокер сообщений - очень низкоуровневый сервис, работающий весь цикл и возможна ситуация что его сервисы будут вызвана
    //слишком рано или поздно. Защитимся
    //printf('SMB_SEND_MESSAGE %d$N',message_id);
    IF MB_mutex.get_id = 0 THEN
        puts('MB_SEND #1');
        MB_SEND_MESSAGE := FALSE; RETURN; 
    END_IF;
    IF MB_mutex.get_id^(ADR(MB_mutex)) = 0 THEN
        puts('MB_SEND #2');
        MB_SEND_MESSAGE := FALSE; RETURN; 
    END_IF;
    
    MB_mutex.lock^(ADR(MB_mutex));
    //Блокировка добавления новых при нулевом буфере (если не успело инициализоваться или наоборот деинициализация)
    IF MB_buffer.size = 0 THEN puts('MB_SEND #3'); MB_SEND_MESSAGE := FALSE; MB_mutex.unlock^(ADR(MB_mutex));  RETURN; END_IF
    temp := MB_buffer.tail;
    next := temp + 1;
    IF (next >= MB_buffer.size) THEN next :=0; END_IF
    IF (next = MB_buffer.head) THEN MB_SEND_MESSAGE := FALSE; MB_mutex.unlock^(ADR(MB_mutex));  RETURN; END_IF
    MB_buffer.buffer[temp].message_id := message_id;
    MB_buffer.buffer[temp].message_size := DWORD#message_size;
    MB_buffer.buffer[temp].message_data := message_data;
    MB_buffer.buffer[temp].pcallback := pcallback;
    MB_buffer.tail := next;
    MB_mutex.unlock^(ADR(MB_mutex));
    MB_sema.post^(ADR(MB_sema));
    //printf('Send %d place [%d]',message_id,next);
END_FUNCTION


FUNCTION SEND_MESSAGE : MESSAGE_ERRORS
VAR_INPUT
    message_id          : DWORD; 
    message_data_size   : size_t;
    message_data        : REF_TO VOID; 
END_VAR

VAR
    is_finished         : BOOL := FALSE;  //Если  handler выставит в TRUE - то сообщение считается обработанным
    pSE                 : REF_TO MB_SORTED_ELEM;
    i                   : DWORD;
    pDE                 : REF_TO DYNAMIC_MB_ELEMENT;
    pcallback           : REF_TO typedef_MB_CALLBACK;
END_VAR
    SEND_MESSAGE := MESSAGE_ERRORS.NO_RECEIVER; //обработчки типа ALL не учитываются
    //Сначала обрабатываем подписчиков на ALL
    {%all_message_handler#check_message_is_finisched%}

    //Затем индивидуально системные
    CASE message_id OF
        MESSAGE_SYSTEM_ID.PRJ_LOADED:         //В момент запуска приложения
            {%loaded_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_STARTED:        //При получени  команды COLD_RUN и ли если запуск без --enter_by_stop
            {%started_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_RESTARTED:        //При получени  команды COLD_RUN и ли если запуск без --enter_by_stop
            {%restarted_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;    
        MESSAGE_SYSTEM_ID.PRJ_RUN:            //Перешли в состояние RT_WORK
            {%run_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_PAUSED:         //Перешли в состояние RT_PAUSED
            {%stop_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_UNLOADED:         //Перешли в состояние RT_UNLOADED
            {%unloaded_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;    
        MESSAGE_SYSTEM_ID.PRJ_IN_EXEPTION:    //перешли в состояние RT_IN_EXEPTION
            {%exeption_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_IN_DEINIT:      //перешли в состояние RT_DEINIT
            {%deinit_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_DONE:            //Приложение закончило работу
            {%done_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.PRJ_SOFT_WATCHDOG: //программный watchdog компонента
            {%softwatchdog_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            //RETURN;
        MESSAGE_SYSTEM_ID.COMM_SOFT_WATCHDOG:
            {%comm_softwatchdog_message_handler#check_message_is_finisched%}
            SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
            RETURN;
    END_CASE;

    //Тут смотрим на массив общих обработчиков
    pSE := GET_SORTED_MB_ELEM (message_id); 
    IF pSe<>0 THEN
        FOR i:=0 TO pSE^.count-1 DO
            pDE := (pSE^.parray_elem+i)^;  //TODO CHECK!!!
            pcallback := pDE^.callback;
            is_finished := pcallback^ (message_id, message_data_size, message_data);
            IF is_finished THEN 
                SEND_MESSAGE := MESSAGE_ERRORS.OK_FINISHED; 
                RETURN;
            END_IF
        END_FOR;
    END_IF;
    SEND_MESSAGE := MESSAGE_ERRORS.NO_ERRORS;
END_FUNCTION


FUNCTION message_brocker_DeInit : VOID
VAR
    i           : DWORD;
    pSE         : REF_TO MB_SORTED_ELEM;
END_VAR
    MB_mutex.lock^(ADR(MB_mutex)); //очищаем память
    MB_buffer.size := 0; //Блокируем буфер
    FOR i := 0 TO MB_sorted_array.count-1 DO
        pSE := MB_sorted_array.parray_ID + i;
        free (pSE^.parray_elem);
    END_FOR;
    free (MB_sorted_array.parray_ID);
    MB_sema.destroy^(ADR(MB_sema));
    MB_mutex.unlock^(ADR(MB_mutex));

    MB_mutex.destroy^(ADR(MB_mutex));

    MB_thread.stop_force^(ADR(MB_thread));
    
END_FUNCTION