{#ifdef target_name#}
{#else#}
{#define %target_name% test_target}
{#endif#} 

{#ifdef target_version#}
{#else#}
{#define %target_version% test_target_version}
{#endif#} 

{#ifdef target_ID#}
{#else#}
{#define %target_ID% test_target_ID}
{#endif#} 

 

{#ifdef project_name#}
{#else#}
{#define %project_name% noname}
{#endif#} 

{#ifdef project_ID#}
{#else#}
{#define %project_ID% ID00000000}
{#endif#} 

{#ifdef project_rev#}
{#else#}
{#define %project_rev% rev_555555}
{#endif#} 

{#ifdef project_ext#}
{#else#}
{#define %project_ext% Vater_unser_im_Himmel_geheiligt_werde_Dein_Name_Dein_Reich_komme_Dein_Wille_geschehe_wie_im_Himmel_so_auf_Erden}
{#endif#} 

{#ifdef SN#}
{#else#}
{#define %SN% 321}
{#endif#} 

{#ifdef DID#}
{#else#}
{#define %DID% 321123}
{#endif#} 



VAR_GLOBAL 
   prj_status        : PRJ_STATUS_DATA;
   prj_id            : PRJ_ID_DATA:= (target_name	:= '%target_name%', target_ver := '%target_version%', device_ID := '%DID%',
   SN := '%SN%', project_name :='%project_name%', project_ID := '%project_ID%', project_rev := '%project_rev%',
   project_ext       := "%project_ext%",target_ID := '%target_ID%');
END_VAR


FUNCTION InitPRGStatus : VOID

   memset(ADR(prj_status),16#00, sizeof(prj_status));
   prj_status.state := PRJ_STATUSES.GLOBAL_ERROR;
   prj_status.last_reboot_status := REBOOT_STATUSES.GLOBAL_ERROR; //Не работает
   prj_status.autorun_status :=(enter_by_stop=FALSE);
   prj_status.last_event := -1;
   
END_FUNCTION
/*
добавляет текстовое описание события в лог и в циклический буфер в статусе
 */

FUNCTION AddEventToLog : VOID
VAR_INPUT
    data    : STRING[32];
END_VAR

VAR
    last_event: SINT; 
END_VAR
    IF (data='') THEN //Пустые отбрасываем
        RETURN;
    END_IF
    //добавляем с буффер
    printf('%s$N',data);
    last_event := prj_status.last_event;
    IF (last_event=9) THEN last_event:=0;
    ELSE last_event:=last_event+1;
    END_IF
    memset (ADR(prj_status.event_data[last_event]), 16#00, sizeof(prj_status.event_data[0]));
    memcpy (ADR(prj_status.event_data[last_event]), ADR(data), MIN(LEN(data), DINT#(sizeof(prj_status.event_data[0])-1)));
    prj_status.last_event := last_event;
    //В лог
    //TODO
END_FUNCTION



FUNCTION GET_PRJ_STATUS : PRJ_STATUSES

   CASE rt_state OF
      _RUNTIME_STATES.RT_NOT_STARTED:
         GET_PRJ_STATUS:=PRJ_STATUSES.GLOBAL_ERROR;
      _RUNTIME_STATES.RT_INITED:
         GET_PRJ_STATUS:=PRJ_STATUSES.COLD_STOP;
      _RUNTIME_STATES.RT_REINITED:
         GET_PRJ_STATUS:=PRJ_STATUSES.PRJ_STOPED;   
      _RUNTIME_STATES.RT_WORK:
         GET_PRJ_STATUS:=PRJ_STATUSES.RUN;
      _RUNTIME_STATES.RT_PAUSED:
         GET_PRJ_STATUS:=PRJ_STATUSES.PRJ_STOPED;
      _RUNTIME_STATES.RT_UNLOADED:
         GET_PRJ_STATUS:=PRJ_STATUSES.UNLOADED_STATE;      
      _RUNTIME_STATES.RT_IN_EXEPTION:
         GET_PRJ_STATUS:=PRJ_STATUSES.SAFE_STATE;
      _RUNTIME_STATES.RT_DONE:
         GET_PRJ_STATUS:=PRJ_STATUSES.DEINITING;
   ELSE
      
   END_CASE;
   
END_FUNCTION
