/*В этом файле объявлены функции инициализации/деинициализации библиотек, которые будут использоваться коллективно из
разных компонентов, а ттакже обявлены глобальные переменные для доступа к библиотекам */

VAR_GLOBAL
    _hsal_di_pointer: REF_TO HSAL_DI; 
	_hsal_do_pointer: REF_TO HSAL_DO; 
END_VAR

FUNCTION HSAL_INIT_ALL_SHAREDUSED_LIBS : BOOL
VAR  
	err:DINT:=0;
END_VAR
    _hsal_di_pointer:= HSAL_DI_component();
	printf('HSAL_DI_component has %d inputs$N', _hsal_di_pointer^.count^(func_type_e.FUNC_TYPE_ALL));
	IF _hsal_di_pointer<>0 THEN
		err:=_hsal_di_pointer^.constructor^(_hsal_di_pointer);
		IF (err=0) THEN
			err := _hsal_di_pointer^.open^(NULL);
            IF (err=0) THEN
                printf('Component DI with %u inputs, including %u BUTTONs, opened$N', 
                                                                                    _hsal_di_pointer^.count^(func_type_e.FUNC_TYPE_DI),
                                                                                    _hsal_di_pointer^.count^(func_type_e.FUNC_TYPE_BUTTON));
            ELSE
                printf('Component DI not opened$N');
                exit_with_code (202);
            END_IF;
		ELSE
			printf('HSAL_DI_component not construct$N');
		exit_with_code (201);	
		END_IF;
	ELSE 	
		printf('HSAL_DI_component not implemented$N');
		exit_with_code (200);
	END_IF;
		 

	_hsal_do_pointer:= HSAL_DO_component();
	printf('HSAL_DO_component has %d outputs$N', _hsal_do_pointer^.count^(func_type_e.FUNC_TYPE_ALL));
    IF _hsal_do_pointer<>0 THEN
		err:=_hsal_do_pointer^.constructor^(_hsal_do_pointer);
		IF (err=0) THEN
			err := _hsal_do_pointer^.open^(NULL);
            IF (err=0) THEN
                printf('Component DO with %u outputs, including %u LEDSs, opened$N', 
                                                                                    _hsal_do_pointer^.count^(func_type_e.FUNC_TYPE_DO),
                                                                                    _hsal_do_pointer^.count^(func_type_e.FUNC_TYPE_LED));
            ELSE
                printf('Component DO not opened$N');
                exit_with_code (205);
            END_IF;
		ELSE
			printf('HSAL_DO_component not construct$N');
		exit_with_code (204);	
		END_IF;
	ELSE 	
		printf('HSAL_DO_component not implemented$N');
		exit_with_code (203);
	END_IF;



   HSAL_INIT_ALL_SHAREDUSED_LIBS:=TRUE;
END_FUNCTION

FUNCTION HSAL_DEINIT_ALL_SHAREDUSED_LIBS : BOOL
VAR  
	err:DINT:=0;
END_VAR

IF _hsal_di_pointer<>0 THEN
    _hsal_di_pointer^.close^();
    printf('HSAL_DI_component closed$N');
END_IF;


IF _hsal_do_pointer<>0 THEN
    _hsal_do_pointer^.close^();
    printf('HSAL_DO_component closed$N');
END_IF;
HSAL_DEINIT_ALL_SHAREDUSED_LIBS:=TRUE;

END_FUNCTION



