(*
    Internal: rtti positions tree

    We number all rtti_cells in a given subtree in a pre-order traversal.
*)


FUNCTION __rtti_type_field_by_pos: __RTTI_TYPE_FLD
VAR_INPUT
    ty: RTTI_TYPE;
    pos: RTTI_POS;
END_VAR
VAR
    a, b, mid: USIZE;
    field: __RTTI_TYPE_FLD;
END_VAR
    if pos = 0 then
        return;
    end_if
    if pos >= ty^.total_len then
        return;
    end_if

    // invariant: fields[a] <= pos < field[b]
    a := 0;
    b := ty^.nfields;

    while a + 1 < b do
        mid := a + (b - a) / 2;
        field := ty^.fields + mid;
        if pos < field^.relative_pos then
            b := mid;
        elsif field^.relative_pos < pos then
            a := mid;
        else
            a := mid;
            exit;
        end_if
    end_while

    __rtti_type_field_by_pos := ty^.fields + a;
END_FUNCTION

FUNCTION __rtti_cell_by_pos: RTTI_CELL
VAR_INPUT
    v: RTTI_CELL;
    pos: RTTI_POS;
END_VAR
VAR
    field: __RTTI_TYPE_FLD;
    ty: RTTI_TYPE;
    next_v: RTTI_CELL;
END_VAR
VAR nil_fld: __RTTI_TYPE_FLD; END_VAR
    while pos > 0 do
        ty := rtti_cell_type(v);
        field := __rtti_type_field_by_pos(ty, pos);
        if field = nil_fld then
            // error: pos is outside of bounds of the variable
            // exit with invalid var
            v := (addr:=NULL);
            return;
        end_if

        next_v := __rtti_cell_field(v, field);
        v := next_v;
        pos := pos - field^.relative_pos;
    end_while
    __rtti_cell_by_pos := v;
END_FUNCTION

FUNCTION __rtti_cell_parent_for_pos: RTTI_CELL
VAR_INPUT
    v: RTTI_CELL;
    pos: RTTI_POS;
END_VAR
VAR
    field: __RTTI_TYPE_FLD;
    ty: RTTI_TYPE;
    next_v: RTTI_CELL;
END_VAR
VAR nil_fld: __RTTI_TYPE_FLD; END_VAR
    while pos > 0 do
        ty := rtti_cell_type(v);
        field := __rtti_type_field_by_pos(ty, pos);
        if field = nil_fld then
            // error: pos is outside of bounds of the variable
            // exit with invalid var
            v := (addr:=NULL);
            return;
        end_if

        pos := pos - field^.relative_pos;
        if pos = 0 then
            // found it
            exit;
        end_if
        next_v := __rtti_cell_field(v, field);
        v := next_v;
    end_while
    __rtti_cell_parent_for_pos := v;
END_FUNCTION
