
TYPE
    RTTI_TYPE: REF_TO RTTI_TYPE_DATA;
    RTTI_TYPE_DATA: STRUCT
        id: RTTI_ID;                    (* shallow id of the type *)
        size: USIZE;                    (* size of values in bytes. can be 0 if size is dynamic *)
        kind: RTTI_TYPE_KND;            (* the kind of the type *)
        fields: __RTTI_TYPE_FLD;        (* pointer to the array of fields *)
        nfields: USIZE;
        total_len: RTTI_POS;            (* total length of this type (in terms of positions) *)
        name: REF_TO CHAR;              (* a best effort display name; see `rtti_type_display_name` for details *)
    END_STRUCT
        RTTI_TYPE_KND: DWORD (
        RTTI_OPAQUE,        (* generic type, does not describe its contents.
                                you should never try to interpret the cell content.
                                just load, transfer and store it back.
                            *)
        RTTI_BOOL,          (* bool type *)
        RTTI_UINTEGER,      (* UINT, ULINT, BYTE, WORD, etc
                                the content is unsigned integer (in native endian)
                            *)
        RTTI_SINTEGER,      (* INT, LINT, SINT, etc
                                the content is signed integer stored as two's complement (in native endian)
                            *)
        RTTI_FLOAT,          (* REAL, LREAL *)
		RTTI_TYPE_ERROR     :=255         

    );

    __RTTI_TYPE_FLD: REF_TO __RTTI_TYPE_FIELD_DATA;
    __RTTI_TYPE_FIELD_DATA: STRUCT
        offset: USIZE;
        ty: RTTI_TYPE;
        relative_pos: RTTI_POS;         (* position of the field relative to the type start *)
        name: REF_TO CHAR;              (* this field name/description *)
    END_STRUCT
END_TYPE

(* Get type name intened to be displayed to the user.
    The exact content and format of the string returned are not specified,
    other than being a best effor description of this type.
    This is done on best effort maner.

    ATTENTION: do not try to process this name in programatic maner.
               This is intended for display only!

    Note, this function may return:
    1. A non-unique type name
    2. A non-valid ST syntax
    3. An emtpy string.

    Additionally, the output may change between versions of compiler.
*)
FUNCTION rtti_type_display_name: STRING
VAR_INPUT v: RTTI_TYPE; END_VAR
    __string_copy(v^.name, rtti_type_display_name);
END_FUNCTION

(** Get the kind for this type.
    See respective enum for details.
*)
FUNCTION rtti_type_kind: RTTI_TYPE_KND
VAR_INPUT ty: RTTI_TYPE; END_VAR
    rtti_type_kind := ty^.kind;
END_FUNCTION

(** The size of the type in bytes

    That is the size of a single variable of this type
*)
FUNCTION rtti_type_size: USIZE
VAR_INPUT ty: RTTI_TYPE; END_VAR
    rtti_type_size := ty^.size;
END_FUNCTION

(** The stride of the type in bytes

    That is the offset to the next value in an array.

    Always, `size <= stride`, and `stride` is divisible by `align`
*)
FUNCTION rtti_type_stride: USIZE
VAR_INPUT ty: RTTI_TYPE; END_VAR
    // IMPLEMENTATION NOTE: currently, or size includes the padding, so we can use it as a stride.
    rtti_type_stride := ty^.size;
END_FUNCTION

FUNCTION __rtti_type_total_len: RTTI_POS
VAR_INPUT ty: RTTI_TYPE; END_VAR
    __rtti_type_total_len := ty^.total_len;
END_FUNCTION

FUNCTION __rtti_type_nfields: USIZE
VAR_INPUT ty: RTTI_TYPE; END_VAR
    __rtti_type_nfields := ty^.nfields;
END_FUNCTION

FUNCTION __rtti_type_field: __RTTI_TYPE_FLD
VAR_INPUT
    ty: RTTI_TYPE;
    ix: USIZE;
END_VAR
    if 0 <= ix and ix < ty^.nfields then
        __rtti_type_field := ty^.fields + ix;
    end_if
END_FUNCTION

