
	/*
	Основной код runtime
	*/

VAR_GLOBAL
	old_rt_state		: _RUNTIME_STATES := _RUNTIME_STATES.RT_BEFORE_ENTRY; 
	rt_state			: _RUNTIME_STATES := _RUNTIME_STATES.RT_BEFORE_ENTRY; 
	rt_possible_to_run	: BOOL := FALSE;
	_exit_status		: DINT;
END_VAR


{%is_message_brocker_present%}



FUNCTION INFORM_SOFT_WATCHDOG : VOID
VAR_INPUT {ref} 
	Prg_name: STRING; 
END_VAR
{#ifdef message_brocker_present#}
//message_brocker_present
	MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_SOFT_WATCHDOG,strlen(ADR(Prg_name)),ADR(Prg_name),NULL); //Prg_name предполагается константой
{#else#}
//message brocker not present
{#endif#} 
END_FUNCTION
/*
переключает состояния
если идёт смена состояния - отсылает однократно сообщение
*/

FUNCTION SWITCH_PRJ_STATE : VOID
VAR_INPUT
	new_state: _RUNTIME_STATES; 
END_VAR
	printf('Switch_state to %d$N',new_state);
{#ifdef message_brocker_present#}
//message_brocker_present
	IF new_state<>old_rt_state THEN //отошлём сообщеньице
		CASE new_state OF
			_RUNTIME_STATES.RT_NOT_STARTED:         //В момент запуска приложения
				InitPRGStatus(); //Подготавливаем структуру состояния
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_LOADED,0,NULL,NULL);
				AddEventToLog('Sys code loaded');
			_RUNTIME_STATES.RT_INITED:        //При получени  команды COLD_RUN и ли если запуск без --enter_by_stop
			    USR_dlclose(); //закрываем если есть
				//Инициализация пользовательского кода
				USR_dlopen(Sys_load_dll_name);
				printf ('Dynamic user dll initialised$N');
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_STARTED,0,NULL,NULL);
				mutex_SYSTEM.lock^(ADR(mutex_SYSTEM));
				rt_possible_to_run:=TRUE;
				mutex_SYSTEM.unlock^(ADR(mutex_SYSTEM));
				AddEventToLog('Load user code (bootproject)');
				Var_conf_use_symbolIF:=TRUE;
			_RUNTIME_STATES.RT_REINITED:
			    USR_dlclose(); //закрываем если есть
				//Инициализация пользовательского кода после горячего обновления
				USR_dlopen(Sys_load_dll_name);
				printf ('Dynamic user initialised$N');
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_RESTARTED,0,NULL,NULL);
				AddEventToLog('Load user code (hotreload)');
				Var_conf_use_symbolIF:=TRUE;
			_RUNTIME_STATES.RT_WORK:            //Перешли в состояние RT_WORK
			    FORCE_VAR_RUN();
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_RUN,0,NULL,NULL);
				AddEventToLog('PRG RUN');
			_RUNTIME_STATES.RT_PAUSED:         //Перешли в состояние RT_PAUSED
			    FORCE_VAR_PAUSE();
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_PAUSED,0,NULL,NULL);
				AddEventToLog('PRG PAUSED');
			_RUNTIME_STATES.RT_UNLOADED:	//
				Var_conf_use_symbolIF:=FALSE;
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_UNLOADED,0,NULL,NULL);
				
				AddEventToLog('UnLoad user code');
			_RUNTIME_STATES.RT_IN_EXEPTION:    //перешли в состояние RT_IN_EXEPTION
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_IN_EXEPTION,0,NULL,NULL);
				AddEventToLog('Catch Exeption');
			_RUNTIME_STATES.RT_DEINIT:      //перешли в состояние RT_DEINIT
				AddEventToLog('Deinit PRG');
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_IN_DEINIT,0,NULL,NULL);
			_RUNTIME_STATES.RT_DONE:            //Приложение закончило работу
				AddEventToLog('PRG Done');
				MB_SEND_MESSAGE(MESSAGE_SYSTEM_ID.PRJ_DONE,0,NULL,NULL);
		END_CASE;
	END_IF
{#else#}
//message brocker not present		
{#endif#} 


	rt_state := new_state;
	old_rt_state := new_state;
	//printf('OK$N');
END_FUNCTION


FUNCTION WE_CAN_RUN : BOOL
	WE_CAN_RUN:= stop_all_command <> TRUE;
END_FUNCTION



FUNCTION ExitHandler : VOID
	printf('ExitHandler$N');
	IF rt_state<> _RUNTIME_STATES.RT_DONE THEN
		printf('Catch exit %d$N',_exit_status);
		CASE rt_state OF
			_RUNTIME_STATES.RT_NOT_STARTED:
				printf('RT_NOT_STARTED exeption$N');
			_RUNTIME_STATES.RT_INITED:
				printf('RT_INITED exeption$N');

			_RUNTIME_STATES.RT_WORK:
				printf('RT_WORK exeption$N');

			_RUNTIME_STATES.RT_IN_EXEPTION:
				printf('RT_IN_EXEPTION exeption$N');

		ELSE
			printf('RT in defstate exeption$N');
		END_CASE;
		//Обработка ошибок
		SECTION_EXCEPTION();
		//Попытаемся усё корректно деинициализировать
		//SECTION_DEINIT();
	END_IF;
END_FUNCTION


VAR_GLOBAL
	enter_by_stop: BOOL:=FALSE;
END_VAR



FUNCTION system_main: DINT
VAR_INPUT
	argc: DINT; 
	argv: REF_TO REF_TO CHAR;
END_VAR
VAR
	cur_status		: SECTION_STATUSES :=SECTION_STATUSES.OK;
	i				: DINT;
	
	pstring			: REF_TO STRING;
	calling_thread	: HSAL_Thread;
	pstdout			: REF_TO VOID;
	control : STACK_CONTROL := (name:='system_main_task');
END_VAR
	setenv(ADR('LD_LIBRARY_PATH'), ADR('/home/root'), 1);
	puts('$NWelcome aboard Kraken (ALTA POPKa) PLC$N');
	printf('Run runtime 0.42$N');
	//USR_dlopen();
	//USR_dlclose();
	//RETURN;
    hsal_thread_constructor(ADR(calling_thread));
    calling_thread.restore_desc^(ADR(calling_thread));
	printf('prg prio=%d prg_policy= %d',calling_thread.attrs.priority,calling_thread.attrs.sched_policy);

	//очень важный код
	{%system_code_init_prio%} 
	//Выставляем спецрежим для вывода в терминал без перевода строки
	//pstdout :=HSAL_Additions_get_stdout();
	//setvbuf (pstdout, ADR(stdio_out_buf), 2 , sizeof(stdio_out_buf)); //_IONBF = 2 без буферизации 
	SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_NOT_STARTED);
	IF (argc<>0) THEN
		printf('argc=%d$N',argc,argv^);
		FOR i:=0 TO argc-1 DO
			printf('argv[%d]=%s$N',i,argv^);
			IF i=1 THEN
				pstring:= CAST(argv^, REF_TO STRING); 
				IF STRING_EQUAL('--enter_by_stop',pstring^) THEN
					enter_by_stop:=TRUE;
					puts('2 stage run mode activated$N');
				END_IF;
			END_IF;
			argv:=argv+1;
		END_FOR;
	END_IF
	
	


	atexit(ADR(ExitHandler));
	
	//Запускаем инициализацию
	cur_status:=INIT_SYSTEM_TASKS(enter_by_stop);
	cur_status:=SECTION_INIT();
	printf('Init ok$N');
	hsal_sleep_to_ms(3000);

	IF SECTION_STATUSES.OK<>cur_status THEN
		SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_IN_EXEPTION);
		SECTION_EXCEPTION();
	ELSE
		//основной цикл программы
		printf('Enter to Main cycle$N');
		IF enter_by_stop = FALSE THEN
			SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_WORK);	
		END_IF;
		 
		WHILE (WE_CAN_RUN()=TRUE) DO
			CONTROL_STACK(ADR(control));
			cur_status:=SECTION_SYSTEM_TASKS();
			IF SECTION_STATUSES.OK<>cur_status THEN
				printf('Exeption in SECTION_SYSTEM_TASKS()$N');
				EXIT;
			END_IF
			cur_status:=SECTION_USER_TASKS();
			IF (SECTION_STATUSES.OK<>cur_status) THEN
				printf('Exeption in SECTION_USER_TASKS()$N');
				EXIT;
			END_IF
			VAR_ACCESS_SIGNAL_IF_PRG_OFF();
			hsal_sleep_for_ms(10);
		END_WHILE
	END_IF
	printf('Abandon the Main cycle$N');
	IF SECTION_STATUSES.OK<>cur_status THEN
		SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_IN_EXEPTION);
		SECTION_EXCEPTION();
	END_IF
	SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_DEINIT);
	cur_status:=SECTION_DEINIT();
	IF SECTION_STATUSES.OK<>cur_status THEN
		SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_IN_EXEPTION);
		SECTION_EXCEPTION();
	END_IF
	
	DEINIT_SYSTEM_TASKS();
	
	printf('Thank you for flying with our airlines$N');
    printf('Good Buy$N');
	SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_DONE);
	//отключаем очень важный код
	{%system_code_deinit_prio%}
    system_main:=0;
	//exit_with_code (0);
END_FUNCTION


