



VAR_GLOBAL 
   thread_SYSTEM     : HSAL_Thread;
   mutex_SYSTEM      : HSAL_Mutex;

   stop_all_command  : BOOL := FALSE;

    Sys_load_dll_name : STRING [80];   

   Sys_conf_shmem_0  : HSAL_Shared_Memory;
   Sys_conf_shmem_1  : HSAL_Shared_Memory;
END_VAR


FUNCTION SECTION_SYSTEM_TASKS: SECTION_STATUSES

VAR
	ret:SECTION_STATUSES:=SECTION_STATUSES.OK;

END_VAR
   {%system_code%}
   IF (stop_all_command) THEN 
      ret := SECTION_STATUSES.STOP;
   END_IF
   SECTION_SYSTEM_TASKS:=ret;
END_FUNCTION




FUNCTION  SYSTEM_TASKS_Wrapper : VOID
VAR_INPUT 
	args     : REF_TO VOID; 
END_VAR
VAR
   offset   : size_t:=0;
   ret      : DINT:=0;
   req_buf  : ARRAY [0..2047] OF BYTE;
   preq     : REF_TO SHMEM_COMMAND_REQ;
   I        : DINT;
    control : STACK_CONTROL := (name:='SYSTEM_task');
END_VAR
   //puts(('_____________________________');

   WHILE (TRUE) DO
      CONTROL_STACK(ADR(control));
      ret := DINT#(Sys_conf_shmem_0.wait_timed^(ADR(Sys_conf_shmem_0), ADR(offset),2000000));
      //IF ret < 0 THEN puts('&'); END_IF
      IF (ret > 0) THEN //Разбираем
         prj_status.state := GET_PRJ_STATUS();
         //printf('req command %d bytes$N',ret);
         ret := DINT#(Sys_conf_shmem_0.read^(ADR(Sys_conf_shmem_0), offset, req_buf, DWORD#ret)); 
         preq:= ADR(req_buf[0]);
         //puts(' ');
         //FOR I:=0 TO preq^.data_size+8 DO
         //      printf ('%02x ', req_buf[i]);
        // END_FOR;
         //puts(' '); 

         //Команды статуса и ID поддерживаются всегда и для всех брокеров
         IF preq^.command = SHMEM_COMMANDS.GET_STATUS THEN
            //puts(('GET_STATUS');
            preq^.data_size := DWORD#(sizeof(prj_status));
            memcpy(ADR(req_buf[0])+8,ADR(prj_status),sizeof(prj_status));
            //printf('.');
            Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, preq^.data_size+8, 100000);
            //puts('+');
            //hsal_sleep_for_ms(10);
            CONTINUE;
         END_IF

         IF preq^.command = SHMEM_COMMANDS.GET_IDENT THEN
            //puts(('GET_IDENT');
            preq^.data_size := DWORD#(sizeof(prj_id));
            memcpy(ADR(req_buf[0])+8,ADR(prj_id),sizeof(prj_id));
                      
            Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, preq^.data_size+8, 100000);
            //hsal_sleep_for_ms(10);
            CONTINUE;
         END_IF

         //Команда установки флагов функционала доступна только от RUNTIME
         IF preq^.command = SHMEM_COMMANDS.SET_FUNC_FLAGS THEN
            //puts(('SET_FUNC_FLAGS');
            IF preq^.broker = SHMEM_BROKERS.RUNTIME THEN
               puts('ERRORS.NOT_SUPPORT');
               preq^.command := SHMEM_COMMAND_ERRORS.NOT_SUPPORT ; //Пока функционал флагов не описан и не реализован
               preq^.data_size :=0;
               Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
               //hsal_sleep_for_ms(10);
               CONTINUE;
            ELSE
               preq^.broker := preq^.broker * (-1);
               preq^.data_size :=0;
               Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
               //hsal_sleep_for_ms(10);
               CONTINUE;
            END_IF
         END_IF

         //Полный стоп!
         IF preq^.command = SHMEM_COMMANDS.ALL_STOP THEN
            IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
               preq^.data_size :=0;
               Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
               SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_PAUSED);
               stop_all_command := TRUE;
               //printf('Receive ALL_STOP$N');
               //hsal_sleep_for_ms(10);
               CONTINUE;
            ELSE
               puts('ERRORS.NOT_SUPPORT');
               preq^.command := SHMEM_COMMAND_ERRORS.NOT_SUPPORT;
               preq^.broker := preq^.broker * (-1);
               preq^.data_size :=0;
               Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
               //hsal_sleep_for_ms(10);
               CONTINUE;
            END_IF
         END_IF   

         CASE rt_state OF
             _RUNTIME_STATES.RT_NOT_STARTED: //Обрабатываем только команду "Запуск приложения из состояния холодного старта" и "Запрос статуса приложения"
               IF preq^.command = SHMEM_COMMANDS.COLD_RUN THEN
                  //puts(('COLD_RUN in NOT_STARTED');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     IF (preq^.data_size=0) THEN
                        //puts('/home/root/libplc_prg.so');
                        Sys_load_dll_name := '/home/root/libplc_prg.so';
                     ELSE
                        memset(ADR(Sys_load_dll_name),16#00, sizeof(Sys_load_dll_name));
                        memcpy(ADR(Sys_load_dll_name),ADR(preq^.add_data[0]),MIN(sizeof(Sys_load_dll_name)-1,preq^.data_size));
                        puts('load dll');
                        puts(Sys_load_dll_name);
                     END_IF
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_INITED);
                     //printf('Receive COLD_RUN$N');
                     
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  ELSE
                     puts('ERRORS.BAD_BROCKER');
                     preq^.broker := preq^.broker * (-1);
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  END_IF;   
               END_IF
            _RUNTIME_STATES.RT_INITED:
            IF preq^.command = SHMEM_COMMANDS.CMD_RUN THEN
                  //puts(('CMD_RUN');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     //printf('Receive CMD_RUN$N');
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_WORK);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                   ELSE
                     preq^.broker := preq^.broker * (-1);
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  END_IF;   
               END_IF
               IF preq^.command = SHMEM_COMMANDS.CMD_UNLOAD THEN
                  puts('CMD_UNLOAD in PAUSED');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_UNLOADED);
                     CONTINUE;
                  END_IF;   
               END_IF

            _RUNTIME_STATES.RT_REINITED:
            IF preq^.command = SHMEM_COMMANDS.CMD_RUN THEN
                  //puts(('CMD_RUN');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     //printf('Receive CMD_RUN$N');
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_WORK);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                   ELSE
                     preq^.broker := preq^.broker * (-1);
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  END_IF;   
               END_IF
               IF preq^.command = SHMEM_COMMANDS.CMD_UNLOAD THEN
                  //puts(('CMD_UNLOAD in PAUSED');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write^(ADR(Sys_conf_shmem_1), 0, req_buf, 8); //ASK
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_UNLOADED);
                     CONTINUE;
                  END_IF;   
               END_IF

            _RUNTIME_STATES.RT_WORK:
               IF preq^.command = SHMEM_COMMANDS.CMD_STOP THEN
                  //puts(('CMD_STOP');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     //printf('Receive CMD_STOP$N');
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_PAUSED);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                   ELSE
                     preq^.broker := preq^.broker * (-1);
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  END_IF;   
               END_IF
            _RUNTIME_STATES.RT_PAUSED:
               IF preq^.command = SHMEM_COMMANDS.CMD_RUN THEN
                  //puts(('CMD_RUN');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     //printf('Receive CMD_RUN$N');
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_WORK);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                   ELSE
                     preq^.broker := preq^.broker * (-1);
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  END_IF;   
               END_IF
               IF preq^.command = SHMEM_COMMANDS.CMD_UNLOAD THEN
                  //puts(('CMD_UNLOAD in PAUSED');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_UNLOADED);
                     CONTINUE;
                  END_IF;   
               END_IF
            _RUNTIME_STATES.RT_UNLOADED:
               IF preq^.command = SHMEM_COMMANDS.COLD_RUN THEN
                  //puts(('COLD_RUN in PAUSED');
                  IF (preq^.broker = SHMEM_BROKERS.RUNTIME OR preq^.broker = SHMEM_BROKERS.ALTA_IDE) THEN
                     IF (preq^.data_size=0) THEN
                        //puts(('/home/root/libplc_prg.so');
                        Sys_load_dll_name := '/home/root/libplc_prg.so';
                     ELSE
                        memset(ADR(Sys_load_dll_name),16#00, sizeof(Sys_load_dll_name));
                        memcpy(ADR(Sys_load_dll_name),ADR(preq^.add_data[0]),MIN(sizeof(Sys_load_dll_name)-1,preq^.data_size));
                        puts('load dll');
                        puts(Sys_load_dll_name);
                     END_IF
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000); //ASK
                     SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_REINITED);
                     //printf('Receive RELOAD$N');
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  ELSE
                     puts('ERRORS.BAD_BROCKER');
                     preq^.broker := preq^.broker * (-1);
                     preq^.data_size :=0;
                     Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
                     hsal_sleep_for_ms(10);
                     CONTINUE;
                  END_IF;   
               END_IF
            _RUNTIME_STATES.RT_IN_EXEPTION:
            _RUNTIME_STATES.RT_DONE: //Завершили нормально
         END_CASE;

         //Сюда попадают те команды, что не обработаны выше
         puts('ERRORS.BAD_STATE');
         preq^.command := SHMEM_COMMAND_ERRORS.BAD_STATE; 
         preq^.data_size :=0;
         //puts(' ');
         //FOR I:=0 TO preq^.data_size+8 DO
         //      printf ('%02x ', req_buf[i]);
         //END_FOR;
         //puts(' '); 
         Sys_conf_shmem_1.write_timed^(ADR(Sys_conf_shmem_1), 0, req_buf, 8, 100000);
      END_IF
      //hsal_sleep_for_ms(50);
   END_WHILE

   
END_FUNCTION


FUNCTION INIT_SYSTEM_TASKS: SECTION_STATUSES
VAR_INPUT
   enter_by_stop: BOOL; //==1 - приостановка запуска до получения сообщения "Запуск приложения из состояния холодного старта"
END_VAR
VAR
	ret:SECTION_STATUSES:=SECTION_STATUSES.OK;
   t_b: BOOL;
END_VAR

   {%system_code_init%}
   //готовим мютекс
   hsal_mutex_constructor(ADR(mutex_SYSTEM));
   mutex_SYSTEM.init^(ADR(mutex_SYSTEM));

   hsal_shared_memory_constructor(ADR(Sys_conf_shmem_0));
   hsal_shared_memory_constructor(ADR(Sys_conf_shmem_1));

   //Инициализируем SHMEM для выходных (нечётных) потоков
   ret:=Find_SHMEM_FLOW(ADR(Sys_conf_shmem_1),1,HSAL_Shared_Memory_Mode.HSAL_SHMEM_RDWR);
   IF ret<0 THEN
      //printf('Not find 11, try alloc $N');
   ELSE //Поток то мы нашли, но он может быть испорчен Закроем и откроем заново!
      Free_SHMEM_FLOW(ADR(Sys_conf_shmem_1));
   END_IF;
   ret:=Alloc_SHMEM_FLOW(ADR(Sys_conf_shmem_1),1,2048); 
   IF ret<0 THEN 
      printf('error in allocation 1 $N');
      ret:=SECTION_STATUSES.ERROR;
   END_IF;    

   IF Find_SHMEM_FLOW(ADR(Sys_conf_shmem_0),0, HSAL_Shared_Memory_Mode.HSAL_SHMEM_READ)=0 THEN
      printf('System commands suported $N');
   ELSE
      printf('System commands NOT suported $N');  
      ret:=SECTION_STATUSES.ERROR;   
   END_IF 

   IF ret=SECTION_STATUSES.OK THEN
      hsal_thread_constructor(ADR(thread_SYSTEM));
      thread_SYSTEM.attrs.priority:=96;
      thread_SYSTEM.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
      ret := thread_SYSTEM.create^(ADR(thread_SYSTEM), NULL, ADR(SYSTEM_TASKS_Wrapper));
      if (ret < 0) THEN
         puts('Thread SYSTEM_TASKS not started. Critical ERROR!');
         //Это критическая ошибка, выходим
         exit_with_code (207);
      END_IF
      ret := thread_SYSTEM.runtime_set_name^(ADR(thread_SYSTEM), 'thread_SYSTEM');
      if (ret < 0) THEN
         printf('Thread error %d - not change name to thread_SYSTEM$N',ret); 
      END_IF

      IF enter_by_stop THEN //Если 2-х этапный старт - ждём команды
         puts('Wait Run command.....');  
         WHILE (TRUE)   DO //Если инициализация системного командного интерфейса провалена - запускаем принудительно в аварийном режиме
            mutex_SYSTEM.lock^(ADR(mutex_SYSTEM));
            t_b:=rt_possible_to_run;
            mutex_SYSTEM.unlock^(ADR(mutex_SYSTEM));
            IF t_b THEN
               puts('Run command received');
               EXIT;
            END_IF;
            hsal_sleep_for_ms(100);
         END_WHILE
      END_IF;
   END_IF;
   Sys_load_dll_name := '/home/root/libplc_prg.so';
   puts('Ignore --enter_by_stop due to the lack of support for the SystemCommand service');   
   SWITCH_PRJ_STATE(_RUNTIME_STATES.RT_INITED);   
   WHILE (TRUE)   DO //Если инициализация системного командного интерфейса провалена - запускаем принудительно в аварийном режиме
      mutex_SYSTEM.lock^(ADR(mutex_SYSTEM));
      t_b:=rt_possible_to_run;
      mutex_SYSTEM.unlock^(ADR(mutex_SYSTEM));
      IF t_b THEN
         puts('Inip passed');
         EXIT;
      END_IF;
      hsal_sleep_for_ms(100);
   END_WHILE
   INIT_SYSTEM_TASKS:=SECTION_STATUSES.OK;
END_FUNCTION


FUNCTION DEINIT_SYSTEM_TASKS: SECTION_STATUSES

VAR
	ret:SECTION_STATUSES:=SECTION_STATUSES.OK;
END_VAR
   {%system_code_deinit%}
   USR_dlclose();
   Free_SHMEM_FLOW(ADR(Sys_conf_shmem_1));
   
   DEINIT_SYSTEM_TASKS:=ret;
END_FUNCTION


    

