/*
Для взаимодействия с runtime компонент реализации таблицы символов использует набор образов shared_mem
как на приём так и на передачу.
ID=10 (входной) - запрос на выдачу JSON буфер 512 байт
ID=11 (выходной) - данный из JSON - буфер создаётся на текущий размер JSON

ID=20 (входной) - запрос на выдачу JSON уфер 512 байт
ID=21 (выходной) - данный из JSON буфер VAR_BUFFER_SIZE.DEFAULT_SIZE кБайта

ID=30 (входной) - запрос на выдачу JSON буфер VAR_BUFFER_SIZE.DEFAULT_SIZE кБайта
ID=31 (выходной) - данный из JSON буфер VAR_BUFFER_SIZE.DEFAULT_SIZE кБайта

32/33 TODO если нfадо будет (пока не ожидаются такие объёмы данных)


Новая система связи "Расчленёнка"
Обмен через потоки 10/11


 */

 VAR_GLOBAL
    mutex_%instance_name%       : HSAL_Mutex;
 END_VAR

 FUNCTION _%instance_name%_Get_Var_conf_is_ready : BOOL
    mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
    _%instance_name%_Get_Var_conf_is_ready:= Var_conf_is_ready; 
    mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
END_FUNCTION

FUNCTION _%instance_name%_Set_Var_conf_is_ready: VOID

VAR_INPUT
    data               : BOOL;
END_VAR

    mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
    Var_conf_is_ready := data;
    mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
END_FUNCTION



FUNCTION _%instance_name%_GetReady : FAL_STATUS
    VAR
        t_var       : RTTI_ROOT_VAR;
    END_VAR
    

    printf('Dynamic DLL activation ... $N');
    {%init_varconf%}
    /*
    printf('SYS_RTTI=%lx$N',rtti_get_local_module());
    t_var := rtti_module_first_var(rtti_get_local_module());
    print_var(t_var);
    WHILE rtti_root_var_next(t_var) DO
        printf ('     ');
        print_var(t_var);
    END_WHILE;
    
    
    

    //t_var :=  rtti_module_first_var(ADR(EXAMPLE_MODULE_DATA)); //rtti_module_first_var(pvar_def_ID0_json_dat);
    printf('USER_RTTI__=%lx$N',pvar_def_ID0_json_dat);
    t_var :=  rtti_module_first_var(pvar_def_ID0_json_dat);
    print_var(t_var);
    WHILE rtti_root_var_next(t_var) DO
        printf ('     ');
        print_var(t_var);
    END_WHILE;
    */
    _%instance_name%_Set_Var_conf_is_ready(TRUE); //Т.к. задачи обмена переменными и JSON высокоприоритетны и выше чем источник сигнала для вызова функции - то этот флаг можно не мютексить
    _%instance_name%_GetReady := FAL_STATUS.OK; 
END_FUNCTION

FUNCTION _%instance_name%_GetReady_to_migrate : FAL_STATUS
    VAR
        t_var       : RTTI_ROOT_VAR;
    END_VAR

    printf('Dynamic DLL reactivation ... $N');
    {%init_varconf%}

    _%instance_name%_GetReady_to_migrate := FAL_STATUS.OK; 
END_FUNCTION


FUNCTION print_var : VOID
VAR_INPUT
   t_var        : RTTI_ROOT_VAR;
END_VAR
VAR
    t_cell      : RTTI_CELL;
    ty          : RTTI_TYPE;
    ty_size     : ISIZE;
END_VAR
    
    t_cell := rtti_root_var_to_cell (t_var);
    IF rtti_cell_is_valid(t_cell) THEN
        ty := rtti_cell_type(t_cell);
        ty_size := rtti_type_size(ty);
        printf('Var %s id=%lx size=%d type_id=%lx type_name=%s$N',t_var.data^.name,t_var.data^.id,ty_size,ty^.id,ty^.name);
    ELSE
        printf('Var %s invalid$N',t_var.data^.name);
    END_IF
    
END_FUNCTION



{%declare_varfunc%}


VAR_GLOBAL 

    {%declare_varconf%}

    %instance_name%_thread_JSON         : HSAL_Thread;

    //Для синхронизации чтения/записи символьных переменных нам потребуется мютекс, переменная, им защищённая и condvar
    %instance_name%_thread_VAR          : HSAL_Thread;
    mutex_user_task_running_VAR_ACCESS  : HSAL_Mutex;
    user_task_running_count             : DINT; //число сейчас исполняемых задач. Когда упадёт до 0 - можно запускать высокоприоритетную задачу синхр. символьных переменных
    user_task_running_condvar           : HSAL_CondVar; //Сигнал на изменение числа переменных

    Var_conf_shmem_10                   : HSAL_Shared_Memory;
    Var_conf_shmem_11                   : HSAL_Shared_Memory;
    Var_conf_shmem_20                   : HSAL_Shared_Memory;
    Var_conf_shmem_21                   : HSAL_Shared_Memory;
    Var_conf_shmem_30                   : HSAL_Shared_Memory;
    Var_conf_shmem_31                   : HSAL_Shared_Memory;

    Var_conf_use_json                   : DINT:=0;
    Var_conf_use_var                    : DINT:=0;
    Var_conf_use_force                  : DINT:=0; //Используются биты 1,20,21 как признаки использования

    Var_conf_use_symbolIF               : BOOL:=FALSE;

    Var_conf_force_buf                  : ARRAY [0..VAR_BUFFER_SIZE.DEFAULT_SIZE-1] OF BYTE;
    Var_conf_run_force_buf              : ARRAY [0..VAR_BUFFER_SIZE.DEFAULT_SIZE-1] OF BYTE;
    Var_conf_pause_force_buf            : ARRAY [0..VAR_BUFFER_SIZE.DEFAULT_SIZE-1] OF BYTE;

    slice_buf                           : ARRAY [0..VAR_BUFFER_SIZE.DEFAULT_SIZE*32-1] OF BYTE;

    Var_conf_force_buf_size             : LINT; //размер запроса
    Var_conf_run_force_buf_size         : LINT; 
    Var_conf_pause_force_buf_size       : LINT; 

    Var_conf_is_init                    : BOOL := FALSE;
    Var_conf_is_ready                   : BOOL := FALSE; //Флаг готовности к работе с пользовательскими данными

    Var_migrate_buffer                  : ARRAY [0 .. 16#10000] OF BYTE; //Буффер для миграции
    Var_have_migrate_data               : BOOL := FALSE; //Признак что данные есть

END_VAR




FUNCTION _%instance_name%_migrate_to : FAL_STATUS
VAR
    ret: DINT;
END_VAR
    printf('migrate_to()$N');
    _%instance_name%_migrate_to := FAL_STATUS.BAD_CONTEXT; 
    IF (pfunc_MIGRATE_VARS=NULL) THEN
        printf('migrate don`t support!$N');
        _%instance_name%_migrate_to := FAL_STATUS.ERROR_INIT; 
        RETURN; 
    END_IF
    IF Var_have_migrate_data THEN
        printf('Begin migrate ...$N');
        ret:=pfunc_MIGRATE_VARS^(FALSE, ADR(Var_migrate_buffer));
        Var_have_migrate_data := FALSE;
        printf('Migrated %d bytes$N',ret);
    ELSE
       printf('No data to migrate ... somthing frong?$N');     
    END_IF
    _%instance_name%_migrate_to := FAL_STATUS.OK; 
    _%instance_name%_Set_Var_conf_is_ready(TRUE); //Т.к. задачи обмена переменными и JSON высокоприоритетны и выше чем источник сигнала для вызова функции - то этот флаг можно не мютексить
END_FUNCTION

FUNCTION _%instance_name%_migrate_from : FAL_STATUS //Подготавливаем данные
VAR
    ret: DINT;
END_VAR
    _%instance_name%_migrate_from := FAL_STATUS.BAD_CONTEXT; 
    printf('migrate_from()$N');
    Var_have_migrate_data := FALSE;
    IF (pfunc_MIGRATE_VARS=NULL) THEN
        printf('migrate don`t support!$N');
        _%instance_name%_migrate_from := FAL_STATUS.ERROR_INIT; 
        RETURN; 
    END_IF

    printf('Get need bufsize to migrate ... $N');
    ret:=pfunc_MIGRATE_VARS^(TRUE, NULL);
    printf('Need %d bytes$N',ret);
    if (ret>0) AND (DWORD#ret<sizeof(Var_migrate_buffer)) THEN
        ret:=pfunc_MIGRATE_VARS^(TRUE, ADR(Var_migrate_buffer));
        IF (ret>0) THEN
            printf('Prepare to migrate %d bytes complited$N',ret);
            Var_have_migrate_data := TRUE;
            _%instance_name%_migrate_from := FAL_STATUS.OK; 
        ELSE
            printf('Prepare to migrate bytes failed with error %d$N',ret);     
        END_IF
    ELSE
        printf('Too big data size - abort migration $N');
    END_IF
    _%instance_name%_Set_Var_conf_is_ready(FALSE); //Т.к. задачи обмена переменными и JSON высокоприоритетны и выше чем источник сигнала для вызова функции - то этот флаг можно не мютексить
END_FUNCTION


FUNCTION _%instance_name%_Standby : FAL_STATUS
   

    _%instance_name%_Set_Var_conf_is_ready (FALSE);
    printf('varconf in standby ... $N');
    {%unload_varconf%}
    _%instance_name%_Standby := FAL_STATUS.OK;
    USR_dlclose(); //закрываем если есть
END_FUNCTION



FUNCTION _%instance_name%_Setup : FAL_STATUS
VAR
    i,j:DINT;
    ret:DINT;
END_VAR 
    _%instance_name%_Setup:=FAL_STATUS.ERROR_INIT;
    printf('System table component activation... $N');
    hsal_mutex_constructor(ADR(mutex_%instance_name%));
    mutex_%instance_name%.init^(ADR(mutex_%instance_name%));

    hsal_shared_memory_constructor(ADR(Var_conf_shmem_10));
    hsal_shared_memory_constructor(ADR(Var_conf_shmem_11));
    hsal_shared_memory_constructor(ADR(Var_conf_shmem_20));
    hsal_shared_memory_constructor(ADR(Var_conf_shmem_21));
    hsal_shared_memory_constructor(ADR(Var_conf_shmem_30));
    hsal_shared_memory_constructor(ADR(Var_conf_shmem_31));
   
     
        //Инициализируем SHMEM для выходных (нечётных) потоков
    ret:=Find_SHMEM_FLOW(ADR(Var_conf_shmem_11),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_JSON,HSAL_Shared_Memory_Mode.HSAL_SHMEM_RDWR);
    IF ret<0 THEN
        printf('Not find 11, try alloc $N');
    ELSE //Поток то мы нашли, но он может быть испорчен Закроем и откроем заново!
        Free_SHMEM_FLOW(ADR(Var_conf_shmem_11));
    END_IF;
    ret:=Alloc_SHMEM_FLOW(ADR(Var_conf_shmem_11),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_JSON,16#20000); //Пока костыль под 1 таблицу
    IF ret<0 THEN 
        printf('error in allocation 11 $N');
        Var_conf_use_json:=-1; //это блокирует запуск кода обработки даже если есть входящий поток
    END_IF;  

    //ret:=Alloc_SHMEM_FLOW(ADR(Var_conf_shmem_21),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_VAR,VAR_BUFFER_SIZE.DEFAULT_SIZE);
    //IF ret<0 THEN //Попробуем через find
    ret:=Find_SHMEM_FLOW(ADR(Var_conf_shmem_21),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_VAR,HSAL_Shared_Memory_Mode.HSAL_SHMEM_RDWR);
    IF ret<0 THEN
        //printf('Not find 21, try alloc $N');
    ELSE //Поток то мы нашли, но он может быть испорчен Закроем и откроем заново!
        Free_SHMEM_FLOW(ADR(Var_conf_shmem_21));
    END_IF;
   
    ret:=Alloc_SHMEM_FLOW(ADR(Var_conf_shmem_21),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_VAR,VAR_BUFFER_SIZE.DEFAULT_SIZE); 
    IF ret<0 THEN 
        printf('error in allocation 21 $N');
        Var_conf_use_var:=-1; //это блокирует запуск кода обработки даже если есть входящий поток
    END_IF;
    //END_IF;
    //ret:=Alloc_SHMEM_FLOW(ADR(Var_conf_shmem_31),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_WRT,VAR_BUFFER_SIZE.DEFAULT_SIZE);
    //IF ret<0 THEN //Попробуем через find
    ret:=Find_SHMEM_FLOW(ADR(Var_conf_shmem_31),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_WRT,HSAL_Shared_Memory_Mode.HSAL_SHMEM_RDWR);
    IF ret<0 THEN
        //printf('Not find 31, try alloc $N');
    ELSE //Поток то мы нашли, но он может быть испорчен Закроем и откроем заново!
        Free_SHMEM_FLOW(ADR(Var_conf_shmem_31));
    END_IF;
    ret:=Alloc_SHMEM_FLOW(ADR(Var_conf_shmem_31),VAR_JSON_FLOWS.VAR_JSON_FLOW_ANSV_WRT,VAR_BUFFER_SIZE.DEFAULT_SIZE); 
    IF ret<0 THEN 
        printf('error in allocation 31 $N');
        Var_conf_use_var:=-1; //это блокирует запуск кода обработки даже если есть входящий поток
    END_IF;
    //END_IF;

    //готовим мютекс
    hsal_mutex_constructor(ADR(mutex_user_task_running_VAR_ACCESS));
    mutex_user_task_running_VAR_ACCESS.init^(ADR(mutex_user_task_running_VAR_ACCESS));
    mutex_user_task_running_VAR_ACCESS.lock^(ADR(mutex_user_task_running_VAR_ACCESS));
    user_task_running_count:=0;
    mutex_user_task_running_VAR_ACCESS.unlock^(ADR(mutex_user_task_running_VAR_ACCESS));

    //Создаём задачи 
    //Основная задача синхронизации символьных переменных
    //ret:= hsal_mutex_constructor(ADR(mutex_user_task_running_VAR_ACCESS));
    //mutex_user_task_running_VAR_ACCESS.init^(ADR(mutex_user_task_running_VAR_ACCESS));

    ret:=hsal_condvar_constructor(ADR(user_task_running_condvar));
    ret:=user_task_running_condvar.init^(ADR(user_task_running_condvar),NULL);


    hsal_thread_constructor(ADR(%instance_name%_thread_VAR));
	%instance_name%_thread_VAR.attrs.priority:=99;
	%instance_name%_thread_VAR.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := %instance_name%_thread_VAR.create^(ADR(%instance_name%_thread_VAR), NULL, ADR(%instance_name%_VAR_Wrapper));
	if (ret < 0) THEN
		printf('Thread %instance_name%_thread_VAR not started$N'); //%task_name%
        //Это критическая ошибка, выходим
        exit_with_code (200);
	END_IF
    ret := %instance_name%_thread_VAR.runtime_set_name^(ADR(%instance_name%_thread_VAR), '%instance_name%_thread_VAR');
    if (ret < 0) THEN
        printf('Thread error %d - not change name to %instance_name%_thread_VAR$N',ret); 
    END_IF

     //Задача выдачи JSON-описания символьных переменных
    hsal_thread_constructor(ADR(%instance_name%_thread_JSON));
	%instance_name%_thread_JSON.attrs.priority:=98;
	%instance_name%_thread_JSON.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := %instance_name%_thread_JSON.create^(ADR(%instance_name%_thread_JSON), NULL, ADR(%instance_name%_JSON_Wrapper));
	if (ret < 0) THEN
		printf('Thread %instance_name%_thread_JSON not started$N'); //%task_name%
        //Это не критическая ошибка
	END_IF
    ret := %instance_name%_thread_JSON.runtime_set_name^(ADR(%instance_name%_thread_JSON), '%instance_name%_thread_JSON');
    if (ret < 0) THEN
        printf('Thread error %d - not change name to %instance_name%_thread_JSON$N',ret); 
    END_IF
    Var_conf_is_init :=TRUE;
    printf('Complited$N');
END_FUNCTION



FUNCTION _%instance_name%_DeInit : VOID
    printf('System table component deactivation.. $N');
    Free_SHMEM_FLOW(ADR(Var_conf_shmem_31));
    Free_SHMEM_FLOW(ADR(Var_conf_shmem_21));
    Free_SHMEM_FLOW(ADR(Var_conf_shmem_11));
    printf('Complited$N');
END_FUNCTION

//Все проверки уже прошли в момент подучения пакета форсинга - допроверок не делаем
FUNCTION FORCE_VAR_COMMON : VOID 
VAR_INPUT
    pvar_wrt_req: REF_TO VAR_WRITE_REQUEST;
END_VAR
VAR
    offset      : ISIZE:=0;
    pdata       : REF_TO BYTE;
    pvar_elem   : REF_TO VAR_ELEM;
    pvar        : REF_TO VAR_VALUE;
    i           : DINT;

    t_var       : RTTI_ROOT_VAR;
    cell        : RTTI_CELL;
    temp_ID     : LWORD;
    temp_POS    : LWORD;
    ty_size     : ISIZE;
    pmodule     : RTTI_MODULE;
END_VAR
                
    IF (pvar_wrt_req^.JSON_ID = 0) THEN pmodule := rtti_get_local_module(); END_IF
    //IF (pvar_wrt_req^.JSON_ID = 1) THEN pmodule := ADR(EXAMPLE_MODULE_DATA);/*pvar_def_ID0_json_dat; */ END_IF //из пользовательской DLL
    IF (pvar_wrt_req^.JSON_ID = 1) THEN pmodule := pvar_def_ID0_json_dat;  END_IF //из пользовательской DLL


    IF pmodule = NULL THEN RETURN; END_IF

    pdata:=CAST(pvar_wrt_req,REF_TO BYTE);
    offset:=(ADR(pvar_wrt_req^.count)-ADR(pvar_wrt_req^.JSON_ID)+4)+sizeof(VAR_VALUE)*CAST(pvar_wrt_req^.count,DWORD); //Смещение в var_data структуре VAR_WRITE_REQUEST для конкретного ответа с конкретным числом переменных
    pdata:=pdata+offset; //указатель на данные для записи

    FOR i:=0 TO pvar_wrt_req^.count-1 DO
        pvar:=ADR(pvar_wrt_req^.var_req[i]);
        temp_ID := pvar^.index;
        temp_POS := pvar^.pos;
        //printf ('[%d]force ID=%lx POS=%ld$N',i,temp_ID,temp_POS);
        t_var:=rtti_module_var_by_id(pmodule,temp_ID);
        cell := rtti_root_var_find_cell_by_pos (t_var,temp_POS);
        ty_size := rtti_type_size(rtti_cell_type(cell));    
        IF (rtti_cell_write(cell,pdata,ty_size)<>ty_size) THEN
            RETURN; //Ошибка, не продолжаем
        END_IF    
        pdata:=pdata+ty_size;
    END_FOR;
END_FUNCTION


//В функциях FORCE_VAR_XXX мы считаем что данные запроса на запись уже проверены на диквидность (так и есть!)
FUNCTION FORCE_VAR_CYCLIC : VOID
    IF  Var_conf_use_force.1 THEN
        //printf ('buf=%x$N',ADR(Var_conf_force_buf[0]));
        //PRINTF_BUF(ADR(Var_conf_force_buf[0]),16);
        FORCE_VAR_COMMON(ADR(Var_conf_force_buf[0]));
    END_IF;
END_FUNCTION


FUNCTION FORCE_VAR_RUN : VOID
    IF  Var_conf_use_force.20 THEN
        FORCE_VAR_COMMON(ADR(Var_conf_run_force_buf[0]));
    END_IF;
END_FUNCTION

FUNCTION FORCE_VAR_PAUSE : VOID
    IF  Var_conf_use_force.21 THEN
        FORCE_VAR_COMMON(ADR(Var_conf_pause_force_buf[0]));
    END_IF;
END_FUNCTION


FUNCTION  %instance_name%_VAR_Wrapper : VOID
VAR_INPUT 
	args        : REF_TO VOID; 
END_VAR
VAR
    offset      : ISIZE:=0;
    ret         : LINT:=0;
    pshmem      : REF_TO HSAL_Shared_Memory:=NULL;
    req_buf     : ARRAY [0..2047] OF BYTE;
    wrt_buf     : ARRAY [0..2047] OF BYTE;
    pdata       : REF_TO BYTE;
    pvar_req    : REF_TO VAR_REQUEST;
    pvar_wrt_req: REF_TO VAR_WRITE_REQUEST;
    i           : DINT;
    pvar        : REF_TO VAR_VALUE;
    pvar_elem   : REF_TO VAR_ELEM;
    is_error    : BOOL;

    t_var       : RTTI_ROOT_VAR;
    cell        : RTTI_CELL;
    temp_ID     : LWORD;
    temp_POS    : LWORD;
    ty_size     : ISIZE;
    pmodule     : RTTI_MODULE;
    control : STACK_CONTROL := (name:='%instance_name%_VAR_Wrapper_task');
END_VAR

    hsal_sleep_for_ms(1500);
    
    puts('%instance_name%_VAR_Wrapper');
    IF Find_SHMEM_FLOW(ADR(Var_conf_shmem_20),VAR_JSON_FLOWS.VAR_JSON_FLOW_REQ_VAR,HSAL_Shared_Memory_Mode.HSAL_SHMEM_READ)=0 AND Find_SHMEM_FLOW(ADR(Var_conf_shmem_30),VAR_JSON_FLOWS.VAR_JSON_FLOW_REQ_WRT,HSAL_Shared_Memory_Mode.HSAL_SHMEM_READ)=0 THEN
        Var_conf_use_var:=Var_conf_use_var+1;
        printf('System table I/O process activated $N');
    ELSE
        printf('System table I/O process NOT suported $N');    
    END_IF  
	WHILE (TRUE) DO
        CONTROL_STACK(ADR(control));
        IF Var_conf_is_init=FALSE THEN
            hsal_sleep_for_ms(100);
            CONTINUE;
        END_IF
        //Ждём сигнала от потока shmem на обработку
        ret:=0;
        pshmem:=NULL;
        //По очереди, меняясь раз в 50 мс, ждём запросов на чтение/запись переменных
        //printf('Z$N');
        IF Var_conf_use_var>0 THEN  //запрещаем если инфраструктура в runtime не поднята
            WHILE (ret<=0) DO
                //if (counter=20) then //printf('1$N');                 END_IF
                pshmem:=ADR(Var_conf_shmem_20);
                ret := DINT#(pshmem^.wait_timed^(pshmem, ADR(offset),50000));
                IF (ret>0) THEN //printf('!R');
                CONTINUE; END_IF
                //if (counter>=40) then //printf('2$N'); counter :=-1;                 END_IF

                pshmem:=ADR(Var_conf_shmem_30);
                ret := DINT#(pshmem^.wait_timed^(pshmem, ADR(offset),50000));
                IF (ret>0) THEN //printf('!W');
                CONTINUE; END_IF
                
            END_WHILE
        END_IF; 
       //printf('receive=%d$N',ret); 
        //и если наше - переходим на ожидание завершения всех пользовательских задач
        mutex_user_task_running_VAR_ACCESS.lock^(ADR(mutex_user_task_running_VAR_ACCESS));
        REPEAT
            user_task_running_condvar.wait^(ADR(user_task_running_condvar),ADR(mutex_user_task_running_VAR_ACCESS));
        UNTIL user_task_running_count<=0  END_REPEAT;
        user_task_running_count:=0; //Защита от дурака
        mutex_user_task_running_VAR_ACCESS.unlock^(ADR(mutex_user_task_running_VAR_ACCESS));
        
        //Делаем дело по обмену с переменными
        //printf('In task safe place$N',ret);

        IF (_%instance_name%_Get_Var_conf_is_ready() = FALSE OR  Var_conf_use_symbolIF = FALSE)   THEN 
            puts('d');
            ret := pshmem^.read^(pshmem, offset, req_buf, ret); //очищаем буфер
            WHILE ret>0 DO
                ret := pshmem^.read^(pshmem, offset, req_buf, ret); 
            END_WHILE;
            CONTINUE;
        END_IF; 

        IF Var_conf_use_var>0 THEN  //запрещаем если инфраструктура в runtime не поднята
            IF ret < 0 THEN puts('^'); END_IF
            //Обрабатываем 
            is_error:= FALSE;
            IF pshmem=ADR(Var_conf_shmem_20) THEN //Чтение переменных
                ret := pshmem^.read^(pshmem, offset, req_buf, ret); //Чтение за экраном проверки указателя pshmem 
                pvar_req:=ADR(req_buf[0]);
                CASE  pvar_req^.JSON_ID OF
                    0,1: //чтение переменных (системных)
                    //чтение переменных (пользовательских)
                        pmodule := NULL;
                        IF (pvar_req^.JSON_ID = 0) THEN pmodule := rtti_get_local_module(); END_IF
                        //IF (pvar_req^.JSON_ID = 1) THEN pmodule := ADR(EXAMPLE_MODULE_DATA); /*pvar_def_ID0_json_dat;*/  END_IF //из пользовательской DLL
                        IF (pvar_req^.JSON_ID = 1) THEN pmodule := pvar_def_ID0_json_dat;  END_IF //из пользовательской DLL
                    ELSE
                        pmodule := NULL;
                END_CASE
                IF pmodule = NULL THEN 
                    pvar_wrt_req:=ADR(wrt_buf[0]);
                    pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                    pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_AVALIABLE;
                    Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                    ret:=(-1);
                    CONTINUE;     
                END_IF    

                IF ((sizeof(VAR_VALUE)*CAST(pvar_req^.count,DWORD))>sizeof(req_buf)) THEN
                    pvar_wrt_req:=ADR(wrt_buf[0]);
                    pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                    pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_SIZE;
                    Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                    ret:=(-1);
                    CONTINUE;                       
                END_IF
                //printf('force_id=%d$N',pvar_req^.force_id);
                //Если читаем с force_id<>NO_FORCE_WRITE_REQ, то это обычное чтение, иначе возвращаем списки если они есть
                IF pvar_req^.force_id=0 THEN
                    //Пока есть только 0-й
                    IF (pvar_req^.count=0) THEN
                        pvar_wrt_req:=ADR(wrt_buf[0]);
                        pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                        pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_SIZE;
                        Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                        ret:=(-1);
                        CONTINUE;                       
                    END_IF
                    //предварительная проверка
                    pvar:=ADR(pvar_req^.var_req[0]);
                    FOR i:=0 TO pvar_req^.count-1 DO
                        temp_ID := pvar^.index;
                        temp_POS := pvar^.pos;
                        //printf ('ID=%lx POS=%ld$N',temp_ID,temp_POS);
                        t_var:=rtti_module_var_by_id(pmodule,temp_ID);
                        /*IF temp_POS<>0 THEN
                            printf('Can`t read part of var%d$N',temp_ID);
                            pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                            ret:=(-1);
                            is_error:=TRUE;
                            EXIT;
                        END_IF*/
                        IF t_var.data=NULL THEN
                            printf('Can`t find root var%lx$N',temp_ID);
                            pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                            ret:=(-1);
                            is_error:=TRUE;
                            EXIT;
                        END_IF
                        cell := rtti_root_var_find_cell_by_pos (t_var,temp_POS);
                        IF rtti_cell_is_valid(cell)=FALSE THEN
                            printf('Can`t find root var%d with pos %d$N',temp_ID,temp_POS);
                            pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                            ret:=(-1);
                            is_error:=TRUE;
                            EXIT;
                        END_IF
                        pvar:=pvar+1;
                    END_FOR;
                    IF is_error THEN
                        CONTINUE;
                    END_IF;

                    //Подготовка ответа
                    offset:=(ADR(pvar_req^.count)-ADR(pvar_req^.JSON_ID)+4)+sizeof(VAR_VALUE)*CAST(pvar_req^.count,DWORD); //Смещение в var_data структуре VAR_WRITE_REQUEST для конкретного ответа с конкретным числом переменных
                    //IF offset=0 THEN printf('data offset=%d $N', offset); END_IF
                    pvar:=ADR(pvar_req^.var_req[0]);
                    //Копируем заголовок из запроса (они одинаковы)
                    memcpy(wrt_buf,req_buf,offset);                    
                    pdata:=ADR(wrt_buf[0]);
                    pdata:=pdata+offset;
                    FOR i:=0 TO pvar_req^.count-1 DO
                        temp_ID := pvar^.index;
                        temp_POS := pvar^.pos;
                        t_var:=rtti_module_var_by_id(pmodule,temp_ID);
                        cell := rtti_root_var_find_cell_by_pos (t_var,temp_POS);
                        IF rtti_cell_is_valid(cell)=FALSE THEN
                            printf('Can`t find CELL for pos %d$N',temp_POS);
                            ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                            CONTINUE;
                        END_IF
                        ty_size := rtti_type_size(rtti_cell_type(cell));
                        //printf('index[%d]=%d[%d]  size=%d$N',i,temp_ID, temp_POS, ty_size);
                        IF (rtti_cell_read(cell,pdata,ty_size)=ty_size) THEN 
                            
                            //printf('Programm_10.Var1=%d$N',Programm_10.Var1);
                            //Копируем данные (мютекс не нужен, мы в защите от множественного доступа)
                            pdata:=pdata+ty_size;
                            offset:=offset+ty_size; //накапливаем общий размер пачки
                        ELSE
                            printf('BAD size index[%d]=%d[%d]  size=%d$N',i,temp_ID, temp_POS, ty_size);
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                            is_error := TRUE;
                            ret:=(-1);
                            CONTINUE;
                        END_IF
                        pvar:=pvar+1;
                    END_FOR;
                    IF is_error THEN
                        CONTINUE;
                    END_IF;
                ELSE
                    //просто возвращаем соотв. список. списки по JSON_ID не делятся (пока!)
                    //puts('f');
                    //Копируем заголовок из запроса (они одинаковы)
                    memcpy(wrt_buf,req_buf,ret);                    
                    CASE pvar_req^.force_id OF
                        1: 
                        IF  Var_conf_use_force.1 THEN
                            //puts('OLEG RETURN Forsing');
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,Var_conf_force_buf,Var_conf_force_buf_size,100000); 
                        ELSE
                            //puts('OLEG Forsing absent');
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000);     //нет списка  
                        END_IF;
                        CONTINUE;
                        20:
                        IF  Var_conf_use_force.20 THEN
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,Var_conf_run_force_buf,Var_conf_run_force_buf_size,100000); 
                        ELSE
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000);      //нет списка 
                        END_IF;
                        CONTINUE;
                        21:
                        IF  Var_conf_use_force.21 THEN
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,Var_conf_pause_force_buf,Var_conf_pause_force_buf_size,100000); 
                        ELSE
                            Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000);      //нет списка 
                        END_IF;
                        CONTINUE;
                    ELSE
                        pvar_wrt_req:=ADR(wrt_buf[0]);
                        pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_FORCE;
                        Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,8,100000); 
                        CONTINUE;
                    END_CASE;
                END_IF;
                
                //printf('size=%d $N', offset);
                Var_conf_shmem_21.write_timed^(ADR(Var_conf_shmem_21),0,wrt_buf,offset,100000); 
                
            ELSIF pshmem=ADR(Var_conf_shmem_30) THEN //Запись переменных
                    //printf('W ');
                    //printf('%d bytes %d offset$N',ret, offset);
                    ret := pshmem^.read^(pshmem, offset, req_buf, ret);
                    //printf('readed %d$N',ret);
                    pvar_wrt_req:=ADR(req_buf[0]);

                    pmodule := NULL;
                    IF (pvar_wrt_req^.JSON_ID = 0) THEN pmodule := rtti_get_local_module(); END_IF
                    //IF (pvar_wrt_req^.JSON_ID = 1) THEN pmodule := ADR(EXAMPLE_MODULE_DATA); /*pvar_def_ID0_json_dat;*/  END_IF //из пользовательской DLL
                    IF (pvar_wrt_req^.JSON_ID = 1) THEN pmodule := pvar_def_ID0_json_dat;  END_IF //из пользовательской DLL

                    IF pmodule = NULL THEN 
                        pvar_wrt_req:=ADR(wrt_buf[0]);
                        pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                        pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_AVALIABLE;
                        Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,wrt_buf,8,100000); 
                        ret:=(-1);
                        CONTINUE;     
                    END_IF    
                    //puts('.');
                    IF ((pvar_wrt_req^.count=0) AND (pvar_wrt_req^.force_id=0)) OR ((sizeof(VAR_VALUE)*ULINT#(pvar_wrt_req^.count))>sizeof(req_buf)) THEN
                        pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_SIZE;
                        printf('E1$N'); 
                        Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,req_buf,8,100000);
                        ret:=(-1);
                        CONTINUE; 
                    END_IF
                    //printf('Get %d vars$N',pvar_wrt_req^.count); 
                    //предварительная проверка
                    pvar:=ADR(pvar_wrt_req^.var_req[0]);
                    FOR i:=0 TO pvar_wrt_req^.count-1 DO
                        temp_ID := pvar^.index;
                        temp_POS := pvar^.pos;
                        //printf ('ID=%lx POS=%ld$N',temp_ID,temp_POS);
                        t_var:=rtti_module_var_by_id(pmodule,temp_ID);
                        /*IF temp_POS<>0 THEN
                            printf('Can`t write part of var%d$N',temp_ID);
                            pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,wrt_buf,8,100000); 
                            ret:=(-1);
                            is_error:=TRUE;
                            EXIT;
                        END_IF*/
                        IF t_var.data=NULL THEN
                            printf('Can`t find root var%lx$N',temp_ID);
                            pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,wrt_buf,8,100000); 
                            ret:=(-1);
                            is_error:=TRUE;
                            EXIT;
                        END_IF
                        //puts('Get Cell');
                        cell := rtti_root_var_find_cell_by_pos (t_var,temp_POS);
                        IF rtti_cell_is_valid(cell)=FALSE THEN
                            printf('Can`t find root var%d with pos %d$N',temp_ID,temp_POS);
                            pvar_wrt_req^.JSON_ID:=pvar_req^.JSON_ID;
                            pvar_wrt_req:=ADR(wrt_buf[0]);
                            pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                            Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,wrt_buf,8,100000); 
                            ret:=(-1);
                            is_error:=TRUE;
                            EXIT;
                        END_IF
                        /*TODO IF (pvar_elem^.offset=0) OR (pvar_elem^.size=0) OR (pvar_elem^.attrib<>VAR_ATTRIB_IS_WA) THEN
                            pvar_wrt_req^.count:=VAR_JSON_ERROR_ATTRIB;
                            printf('E3$N');
                            Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,req_buf,8,100000); 
                            is_error :=TRUE;
                            ret:=(-1);
                            CONTINUE;
                        END_IF*/
                        pvar:=pvar+1;
                    END_FOR;
                    IF is_error THEN
                        puts('---------------is error!');
                        CONTINUE;
                    END_IF;
   
                    //printf('force_id=%d$N',pvar_wrt_req^.force_id);
                    IF pvar_wrt_req^.force_id = 0 THEN
                        //Обычный запрос - сразу отвечаем
                        //Подготовка ответа
                        offset:=(ADR(pvar_wrt_req^.count)-ADR(pvar_wrt_req^.JSON_ID)+4)+sizeof(VAR_VALUE)*CAST(pvar_wrt_req^.count,DWORD); //Смещение в var_data структуре VAR_WRITE_REQUEST для конкретного ответа с конкретным числом переменных
                        pdata:=ADR(req_buf[0]);
                        pdata:=pdata+offset; //указатель на данные для записи
                        pvar:=ADR(pvar_wrt_req^.var_req[0]);
                        FOR i:=0 TO pvar_wrt_req^.count-1 DO
                            temp_ID := pvar^.index;
                            temp_POS := pvar^.pos;
                            //printf ('[%d]write ID=%lx POS=%ld$N',i,temp_ID,temp_POS);
                            t_var:=rtti_module_var_by_id(pmodule,temp_ID);
                            IF t_var.data=NULL THEN
                                printf('Can`t find root var%1x$N',temp_ID);
                                pvar_wrt_req:=ADR(wrt_buf[0]);
                                pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                                Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,wrt_buf,8,100000); 
                                is_error := TRUE;
                                ret:=(-1);
                                CONTINUE;
                            END_IF    
                            cell := rtti_root_var_find_cell_by_pos (t_var,temp_POS);
                            IF rtti_cell_is_valid(cell)=FALSE THEN
                                printf('Can`t find CELL for pos %d$N',temp_POS);
                                ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_31), 0, ADR(req_buf[0]), ret, 100000);
                                CONTINUE;
                            END_IF
                            ty_size := rtti_type_size(rtti_cell_type(cell));
                            //printf('pdata[%d]=%lx  ty_size=%d$N',i,pdata,ty_size);    
                            IF (rtti_cell_write(cell,pdata,ty_size)=ty_size) THEN 
                                //printf('index[%d]=%d  size=%d  adr=%lx $N',i,pvar^.index, pvar_elem^.size, pvar_elem^.offset);
                                //printf('Programm_10.Var1=%d$N',Programm_10.Var1);
                                //Копируем данные (мютекс не нужен, мы в защите от множественного доступа)
                                puts('Write OK');
                                pdata:=pdata+ty_size;
                            ELSE
                                puts('-----------------Write error');
                                pvar_wrt_req:=ADR(wrt_buf[0]);
                                pvar_wrt_req^.count:=VAR_JSON_ERRORS.VAR_JSON_ERROR_VAR;
                                Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,wrt_buf,8,100000); 
                                is_error := TRUE;
                                ret:=(-1);
                                CONTINUE;
                            END_IF    
                        END_FOR;
                        IF is_error THEN
                            CONTINUE;
                        END_IF;
                    ELSE //Списки форсинга - отвечаем как обычно, но реальная запсиь только в требуемом случае.

                        //printf('F1$N');
                        /*
                        TYPE FORCE_IDS: BYTE
                        (
                            NO_FORCE_WRITE_REQ      := 0,
                            CYCL_FORCE_WRITE_REQ    := 1,
                            ON_RUN_FORCE_WRITE_REQ  := 20,
                            ON_PAUSE_FORCE_WRITE_REQ:= 21
                        );
                        END_TYPE
                        Var_conf_use_force          :DINT:=0; //Используются биты 1,20,21 как признаки использования
                        */ 
                        //printf('!!force_id(%d)=%d$N',pvar_wrt_req^.force_id,pvar_wrt_req^.count);
                        CASE pvar_wrt_req^.force_id OF
                            1:
                            //printf('force_id(%d)=%d$N',pvar_wrt_req^.force_id,pvar_wrt_req^.count);
                            IF pvar_wrt_req^.count=0 THEN
                                Var_conf_use_force.1 := FALSE;
                                //puts('OLEG Forsing off');
                            ELSE
                                Var_conf_use_force.1 := TRUE;
                                //printf('memcpy(%lx,%lx,%d)$N',ADR(Var_conf_force_buf),ADR(pvar_wrt_req),MIN(sizeof(Var_conf_force_buf),ret));
                                memcpy(ADR(Var_conf_force_buf),pvar_wrt_req,MIN(sizeof(Var_conf_force_buf),ULINT#ret));
                                //puts('OLEG Forsing on');
                                Var_conf_force_buf_size:=ret;
                            END_IF;
                            
                            20:
                            IF pvar_wrt_req^.count=0 THEN
                                Var_conf_use_force.20 := FALSE;
                            ELSE
                                Var_conf_use_force.20 := TRUE;
                                memcpy(ADR(Var_conf_run_force_buf),ADR(pvar_wrt_req),MIN(sizeof(Var_conf_run_force_buf),ULINT#ret));
                                Var_conf_run_force_buf_size:=ret;
                            END_IF;
                            
                            21:
                            IF pvar_wrt_req^.count=0 THEN
                                Var_conf_use_force.21 := FALSE;
                            ELSE
                                Var_conf_use_force.21 := TRUE;
                                memcpy(ADR(Var_conf_pause_force_buf),ADR(pvar_wrt_req),MIN(sizeof(Var_conf_pause_force_buf),ULINT#ret));
                                Var_conf_pause_force_buf_size:=ret;
                            END_IF;
                        END_CASE;
                    END_IF;   
                    //if (ret<>offset) THEN
                    //    puts('Error in input shmem flows'); 
                    //ELSE
                    //printf('S_W ');
                    //printf('size=%d $N', ret);
                    Var_conf_shmem_31.write_timed^(ADR(Var_conf_shmem_31),0,req_buf,ret,100000); 
                     
                    //END_IF 
            ELSE
                //Что то не то - возвращаемся снова в поиск
                puts('Error in input shmem flows'); //Убрать в релизе TODO
                hsal_sleep_for_ms(100); //Если зависнет - не будет мешать остальной программе
                CONTINUE;
            END_IF;
        ELSE
            hsal_sleep_for_ms(100); //В случае поднятой инфрастуктуры запросов переменных - задержка уже есть в цикле ожидания обмена
        END_IF;  
	END_WHILE;
END_FUNCTION


FUNCTION  %instance_name%_JSON_Wrapper : VOID
VAR_INPUT 
	args: REF_TO VOID; 
END_VAR
VAR
    offset      : ISIZE:=0;
    ret         : LINT:=0;
    dret        : DWORD;
    req_buf     : ARRAY [0..511] OF BYTE;
    
    pslice_buf  : REF_TO BYTE;
    ptemp_buf   : REF_TO BYTE;
    slice_size  : USIZE;
    preq        : REF_TO VAR_JSON_REQ;
    pslice      : REF_TO SYMBOLS_SLICE_REQ;
    pansv       : REF_TO SYMBOLS_SLICE_ANSV;
    t_var       : RTTI_ROOT_VAR;
    preqsub     : REF_TO SYMBOLS_REQ_SUBFIELDS;
    I           : DINT;
    cell        : RTTI_CELL;
    sub_cell    : RTTI_CELL;
    temp_ID     : LWORD;
    temp_POS    : LWORD;
    pmodule     : RTTI_MODULE;
    control : STACK_CONTROL := (name:='%instance_name%_JSON_Wrapper_task');
END_VAR
    hsal_sleep_for_ms(100);
    //puts('%instance_name%_JSON_Wrapper');
    IF Find_SHMEM_FLOW(ADR(Var_conf_shmem_10),VAR_JSON_FLOWS.VAR_JSON_FLOW_REQ_JSON,HSAL_Shared_Memory_Mode.HSAL_SHMEM_READ)=0 THEN
        Var_conf_use_json:=Var_conf_use_json+1;
        printf('System table RPS process activated $N');
    ELSE
        printf('System table RPS process NOT suported $N');
    END_IF  
    WHILE Var_conf_use_json<=0 DO
        hsal_sleep_for_ms(100);
    END_WHILE;
    req_buf[0]:=0;
	WHILE (TRUE) DO
        CONTROL_STACK(ADR(control));
        IF Var_conf_is_init=FALSE THEN
            hsal_sleep_for_ms(100);
            CONTINUE;
        END_IF
        hsal_sleep_for_ms(100);
        ret := DINT#(Var_conf_shmem_10.wait_timed^(ADR(Var_conf_shmem_10), ADR(offset),50000));
        WHILE (ret<=0) DO
            ret := DINT#(Var_conf_shmem_10.wait_timed^(ADR(Var_conf_shmem_10), ADR(offset),50000));
            //IF (ret>0) THEN CONTINUE; END_IF
        END_WHILE
        //printf('t-------$N');
       
        //printf('rjson=%d',ret);
        IF _%instance_name%_Get_Var_conf_is_ready() = FALSE    THEN 
            puts('j1');
        END_IF
        IF Var_conf_use_symbolIF = FALSE   THEN 
            puts('j2');
        END_IF

       IF (_%instance_name%_Get_Var_conf_is_ready() = FALSE OR  Var_conf_use_symbolIF = FALSE)   THEN 
            ret := Var_conf_shmem_10.read^(ADR(Var_conf_shmem_10), offset, req_buf, ret);  //очищаем буфер
            WHILE ret>0 DO
                ret := Var_conf_shmem_10.read^(ADR(Var_conf_shmem_10), offset, req_buf, ret); 
            END_WHILE;
            CONTINUE;
        END_IF

        ret := Var_conf_shmem_10.read^(ADR(Var_conf_shmem_10), offset, req_buf, ret); 
        //printf('req JSON %d bytes$N',ret);
        preq:=ADR(req_buf[0]);
        
        
       // printf('req %d flow$N',preq^.JSON_ID);
        CASE preq^.JSON_ID OF
            0,1: //чтение переменных (системных)
            //чтение переменных (пользовательских)

                pmodule := NULL;
                IF (preq^.JSON_ID = 0) THEN pmodule := rtti_get_local_module(); END_IF
                //IF (preq^.JSON_ID = 1) THEN pmodule := ADR(EXAMPLE_MODULE_DATA); /*pvar_def_ID0_json_dat;*/  END_IF //из пользовательской DLL
                IF (preq^.JSON_ID = 1) THEN pmodule := pvar_def_ID0_json_dat;  END_IF //из пользовательской DLL
            
                
                IF pmodule = NULL THEN
                    printf('ERROR get %d synconf$N', preq^.JSON_ID);
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                    CONTINUE;
                END_IF
                
                pslice:=ADR(req_buf[0]);
                IF pslice^.size<>8 THEN
                    puts('ERROR');
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                    CONTINUE;
                END_IF
                slice_size := sizeof(SYMBOLS_SLICE_ANSV);
                pansv      := ADR (slice_buf[0]);
                pslice_buf := ADR (slice_buf[0]) + sizeof(SYMBOLS_SLICE_ANSV);
                pansv^.have_continue := 0;
                pansv^.sym_count := 0;

                IF  pslice^.LAST_ID=0 THEN //Первое чтение
                    //puts('FIRST');         //используем приёмный буфер как временное хранилище для одного символа
                    ptemp_buf := ADR(req_buf[0]);
                    t_var:=rtti_module_first_var(pmodule);
                    //printf ('ROOT->$N');
                    cell := rtti_root_var_to_cell (t_var);
                    ret := slice_cell(cell,ptemp_buf,cell,-1);
                    IF (ret<0) THEN EXIT; END_IF //Конец?
                    memcpy (pslice_buf,ptemp_buf,ret);
                    pansv^.sym_count := 1;
                    pslice_buf := pslice_buf + ULINT#ret;
                    slice_size := slice_size + ULINT#ret;
                    WHILE rtti_root_var_next(t_var) DO
                        cell := rtti_root_var_to_cell (t_var);
                        ret := slice_cell(cell,ptemp_buf,cell,-1);
                        IF (ret<0) THEN EXIT; END_IF //Конец?
                        IF (slice_size+ULINT#ret>sizeof(slice_buf)) THEN pansv^.have_continue := 1; EXIT; END_IF
                        memcpy (pslice_buf,ptemp_buf,ret);
                        pslice_buf := pslice_buf + ULINT#ret;
                        slice_size := slice_size + ULINT#ret;
                        pansv^.sym_count := pansv^.sym_count + 1;
                    END_WHILE;
                    //printf('send   %d bytes %d vars $N',slice_size, pansv^.sym_count);
                    //PRINTF_BUF (ADR(slice_buf),slice_size);
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(slice_buf), slice_size, 1000000);
                    IF (ret < 0) THEN
                        printf('_write error %d $N', ret);
                    END_IF
                    
                ELSE //Продолжение
                    //puts('CONTINUE');                   //используем приёмный буфер как временное хранилище для одного символа
                    ptemp_buf := ADR(req_buf[0]);

                    t_var:=rtti_module_var_by_id(pmodule,pslice^.LAST_ID);
                    WHILE rtti_root_var_next(t_var) DO
                        cell := rtti_root_var_to_cell (t_var);
                        ret := slice_cell(cell,ptemp_buf,cell,-1);
                        IF (ret<0) THEN EXIT; END_IF //Конец?
                        IF (slice_size+ULINT#ret>sizeof(slice_buf)) THEN pansv^.have_continue := 1; EXIT; END_IF
                        memcpy (pslice_buf,ptemp_buf,ret);
                        pslice_buf := pslice_buf + ULINT#ret;
                        slice_size := slice_size + ULINT#ret;
                        pansv^.sym_count := pansv^.sym_count + 1;
                    END_WHILE;
                    //printf('send2   %d bytes$N',slice_size);
                    //PRINTF_BUF (ADR(slice_buf),slice_size);
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(slice_buf), slice_size, 100000);
                    IF (ret < 0) THEN
                        printf('_write error %d $N', ret);
                    END_IF
                    
                END_IF;


            202,203: //чтение переменных (системных)
            //чтение переменных (пользовательских)
                pmodule := NULL;
                IF (preq^.JSON_ID = 202) THEN pmodule := rtti_get_local_module(); END_IF
                //IF (preq^.JSON_ID = 203) THEN pmodule := ADR(EXAMPLE_MODULE_DATA); /*pvar_def_ID0_json_dat;*/  END_IF //из пользовательской DLL
                IF (preq^.JSON_ID = 203) THEN pmodule := pvar_def_ID0_json_dat;  END_IF //из пользовательской DLL

                IF pmodule = NULL THEN
                    printf('ERROR get %d synconf$N', preq^.JSON_ID);
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                    CONTINUE;
                END_IF

                //printf('202->$N');
                PRINTF_BUF (ADR(req_buf[0]),24);
                preqsub:=ADR(req_buf[0]);
                IF preqsub^.size<>16 THEN
                    puts('ERROR2');
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                    CONTINUE;
                END_IF
                temp_ID := preqsub^.VAR_ID;
                temp_POS := preqsub^.POS;
                //printf ('ID=%lx POS=%ld$N',temp_ID,temp_POS);

                slice_size := sizeof(SYMBOLS_SLICE_ANSV);
                pansv      := ADR (slice_buf[0]);
                pslice_buf := ADR (slice_buf[0]) + sizeof(SYMBOLS_SLICE_ANSV);
                pansv^.have_continue := 0;
                pansv^.sym_count := 0;
                IF  temp_ID=0 THEN //VAR_ID не должна быть ==0
                    printf('VAR_ID %lx must be >0$N',temp_ID);
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                    CONTINUE;
                ELSE //Продолжение
                    //используем приёмный буфер как временное хранилище для одного символа
                    
                    t_var:=rtti_module_var_by_id(pmodule,temp_ID);
                    IF t_var.data=NULL THEN
                        printf('Can`t find root var%d$N',temp_ID);
                        ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                        CONTINUE;
                    END_IF
                    cell := rtti_root_var_find_cell_by_pos (t_var,temp_POS);
                    IF rtti_cell_is_valid(cell)=FALSE THEN
                        printf('Can`t find CELL for pos %d$N',temp_POS);
                        ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(req_buf[0]), ret, 100000);
                        CONTINUE;
                    END_IF
                    ptemp_buf := ADR(req_buf[0]);

                    FOR I:=0 TO DINT#(rtti_cell_n_children(cell)-1) DO
                        
                        sub_cell:=rtti_cell_nth_child(cell,i);
                        ret := slice_cell(sub_cell,ptemp_buf,cell, I);

                        IF (ret<0) THEN EXIT; END_IF //Конец?
                        IF (slice_size+ULINT#ret>sizeof(slice_buf)) THEN pansv^.have_continue := 1; EXIT; END_IF
                        memcpy (pslice_buf,ptemp_buf,ret);
                        pslice_buf := pslice_buf + ULINT#ret;
                        slice_size := slice_size + ULINT#ret;
                        pansv^.sym_count := pansv^.sym_count + 1;

                    END_FOR
                   
                   // printf('send3   %d bytes$N',slice_size);
                    //PRINTF_BUF (ADR(slice_buf),slice_size);
                    ret := Var_conf_shmem_11.write_timed^(ADR(Var_conf_shmem_11), 0, ADR(slice_buf), slice_size, 1000000);
                    IF (ret < 0) THEN
                        printf('_write2 error %d $N', ret);
                    END_IF
                END_IF; 
        ELSE
            ret:=-1;
            printf('unsupported  %d JSON ID$N',preq^.JSON_ID);
        END_CASE;
        req_buf[0]:=0;
	END_WHILE;
END_FUNCTION


FUNCTION VAR_ACCESS_INCR : VOID
    IF Var_conf_is_init=FALSE THEN RETURN; END_IF
    mutex_user_task_running_VAR_ACCESS.lock^(ADR(mutex_user_task_running_VAR_ACCESS));
    user_task_running_count:=user_task_running_count+1;
    mutex_user_task_running_VAR_ACCESS.unlock^(ADR(mutex_user_task_running_VAR_ACCESS));
END_FUNCTION

FUNCTION VAR_ACCESS_DECR_AND_SIGNAL : VOID
    IF Var_conf_is_init=FALSE THEN RETURN; END_IF
    mutex_user_task_running_VAR_ACCESS.lock^(ADR(mutex_user_task_running_VAR_ACCESS));
    user_task_running_count:=user_task_running_count-1;
    IF (user_task_running_count<=0) THEN user_task_running_condvar.cignal^(ADR(user_task_running_condvar)); END_IF
    mutex_user_task_running_VAR_ACCESS.unlock^(ADR(mutex_user_task_running_VAR_ACCESS));
END_FUNCTION

FUNCTION VAR_ACCESS_SIGNAL_IF_PRG_OFF : VOID
    IF Var_conf_is_init=FALSE THEN RETURN; END_IF
    mutex_user_task_running_VAR_ACCESS.lock^(ADR(mutex_user_task_running_VAR_ACCESS));
    IF (user_task_running_count<=0) THEN user_task_running_condvar.cignal^(ADR(user_task_running_condvar)); END_IF
    mutex_user_task_running_VAR_ACCESS.unlock^(ADR(mutex_user_task_running_VAR_ACCESS));
END_FUNCTION


FUNCTION slice_cell : ISIZE //Возвращает размер элемента
//Если переменная бракованная - возвращает с кодами ошибок
VAR_INPUT
   t_cell      : RTTI_CELL;
   pbuf        : REF_TO BYTE;
   parent_cell: RTTI_CELL; //Для корневых NULL
   idx         : DINT;
END_VAR
VAR
    
    ty          : RTTI_TYPE;
    ty_size     : ISIZE;
    psym        : REF_TO ONE_SYMBOL_SLICE;
    temp        : BYTE;
    pchar       : REF_TO CHAR;
    str         : STRING;
END_VAR
    
    slice_cell := 0;
    psym := CAST(pbuf, REF_TO ONE_SYMBOL_SLICE); 
       
    
    IF rtti_cell_is_valid(t_cell) THEN
        ty := rtti_cell_type(t_cell);
        ty_size := rtti_type_size(ty);
        IF (idx=(-1)) THEN //корневая
            pchar:=t_cell.root^.name;
        ELSE
            pchar := rtti_cell_nth_child_display_pname(parent_cell,ULINT#idx);
            //pchar:= ADR(str);
        END_IF
        //printf('Var/field %s => id=%d nfields=%d pos=%d size=%d type_id=%d type_name=%s$N',pchar,t_cell.root^.id,ty^.nfields,rtti_cell_pos(t_cell), ty_size,ty^.id,ty^.name);
        psym^.Id := t_cell.root^.id;
        psym^.IdOfType := ty^.id;
        psym^.SizeOfSymbol := ty_size;
        psym^.nfields := ty^.nfields;
        psym^.pos := rtti_cell_pos(t_cell); //Для переменной всегда 0, по идее
        psym^.Kind := BYTE#(ty^.kind);
        slice_cell := sizeof(ONE_SYMBOL_SLICE)-4;
        pbuf := pbuf + (sizeof(ONE_SYMBOL_SLICE)-4);

        temp := BYTE#(strlen(pchar));
        //IF temp=0 then pchar:=ADR('_'); temp:=1; END_IF
        pbuf^:=temp; 
        slice_cell := slice_cell + temp + 1;
        memcpy (pbuf+1,pchar,temp);
        pbuf := pbuf + 1 + temp;

        temp :=BYTE#(strlen(ty^.name));
        pbuf^:=temp; 
        slice_cell := slice_cell + temp + 1;
        memcpy (pbuf+1,ty^.name,temp);
        //pbuf := pbuf + 1 + temp;
        //printf('slice_cell=%d bytes$N',slice_cell);
    ELSE
        printf('Var is invalid$N');
        psym^.Id := 0;
        psym^.IdOfType := 0;
        psym^.SizeOfSymbol := 0;
        psym^.nfields := 0;
        psym^.pos := 0; //Для переменной всегда 0
        psym^.Kind := BYTE#(RTTI_TYPE_KND.RTTI_TYPE_ERROR);
        slice_cell := (sizeof(ONE_SYMBOL_SLICE)-4);
        pbuf := pbuf + (sizeof(ONE_SYMBOL_SLICE)-4);

        temp := BYTE#(strlen(ADR('error in var')));
        pbuf^ := temp;
        slice_cell := slice_cell + temp + 1;
        memcpy (pbuf+1,ADR('error in var'),temp);
        pbuf := pbuf + 1 + temp;

        temp := BYTE#(strlen(ADR('error in type')));
        pbuf^ := temp;
        slice_cell := slice_cell + temp + 1;
        memcpy (pbuf+1,ADR('error in type'),temp);
        //pbuf := pbuf + 1 + temp;
       // printf('slice_cell=%d bytes$N',slice_cell);
    END_IF
    
END_FUNCTION
