/*
Компонент работает в режиме RTU only БЕЗ CRC, TCP_Server должен сам манипулировать заголовком, а RS-порт проверять CRC и преобразовывать из/в ASCII

 */


VAR_GLOBAL 
    //Даже если нет входов или выходов - массив единичного размер [0..0] всё равно будет создан для избежания ошибки компиляции
    modbus_varsDevCEs%I%:array [0..{#num_of(%add_var_to_massiv_DEV%)}] OF MODBUS_VAR_ELEM_MASTER{%entQSquare@O<>%}
        {%add_var_to_massiv_DEV<,>%}
        {%extQSquare@O<>%};
   
    modbusDevCEs_mem%I%: array [0..({%count_var_size_CE< >%}0)] OF BYTE:=[{%get_def_val_CE[,]%}0];

    %instance_name%_index_array%I%: array [MODBUS_DEV_TCP_CHANNEL_COUNT.MAX..{%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX] OF MODBUS_SEARCH_ELEM_MASTER;
END_VAR

VAR_GLOBAL 
    %instance_name%_thread :HSAL_Thread;
    mutex_%instance_name%:HSAL_Mutex;
END_VAR


VAR_GLOBAL
	_%instance_name%_enter_if:FAL_ENTER_IF	 := (
		inst_data:=%I%,	
		GetContext:=ADR(_%instance_name%_GetContext) ,
		InitFal:=ADR(_%instance_name%_InitFal),
		DeInitFal:=ADR(_%instance_name%_DeInitFal),
		CheckFal:=ADR(_%instance_name%_CheckFal),
		GetIface:=ADR(_%instance_name%_GetIface)
	);
	%instance_name%_enter_if    : REF_TO FAL_ENTER_IF;//:=ADR(_%instance_name%_enter_if);
    %instance_name%_data        : MODBUS_TCP_DEVICE_DATA;
    //настройки из каналов
    %instance_name%_ENABLE      : BOOL  := %value(0)%;
    %instance_name%_STATUS      : MODBUS_STATUS:= MODBUS_STATUS.NOT_INIT;
    %instance_name%_SlaveID     : BYTE  := %value(2)%;
    %instance_name%_IP_name     : STRING := '%value(3)%';
    %instance_name%_port        : WORD  := %value(4)%;
    %instance_name%_timeout_soc : WORD := %value(5)%;
    %instance_name%_poll_period : WORD := %value(6)%;
    %instance_name%_byteorder   : MODBUS_ORDERS := %value(7)%;
    //%instance_name%_watchdog    : WORD  := ^value(8)%;
    %instance_name%_use_master  : BOOL  := %value(9)%;
    %instance_name%_resp_timeout: WORD := %value(10)%;
    %instance_name%_retry_cnt   : WORD  := %value(11)%;
    //Данные из мастера
    %instance_name%_resp_timeout_m: DWORD ;
    %instance_name%_retry_cnt_m   : WORD  ;


    %instance_name%_last_tag        : WORD :=0; //Номер от нуля
    %instance_name%_last_polltime   : DWORD :=0;
    %instance_name%_last_error      : MODBUS_ERROR_CODES := MODBUS_ERROR_CODES.RESPONSE_SUCCESS;

    //Текущие данные
    %instance_name%_IP_addr     : DWORD;
    %instance_name%_state       : MODBUS_DEV_TCP_STATES:= MODBUS_DEV_TCP_STATES.NOT_INIT;
    %instance_name%_ACII_state  : DWORD ;//биты ACII_STATES;
    %instance_name%_ACII_cntl   : DWORD ;//биты ACII_STATES;
    %instance_name%_retry_now_counter   : WORD; //Текущий счетчик уже сделанных запросов
    %instance_name%_craving     : DINT;		//Потребность в обслуживании/приоритет (чем выше тем больше, <0 - нет потребности)
    %instance_name%_is_gived    : BOOL;
    %instance_name%_gived_res   : uintptr_t; //В данном случае сокет, выделяемый мастером при последовательном опросе(при паралельном не обрабатывается)

    _%instance_name%_resv_buffer: MODBUS_TCP_BUFFER;
    _%instance_name%_send_buffer: MODBUS_TCP_BUFFER;

END_VAR


FUNCTION _%instance_name%_ENABLE : ERROR_CODE
VAR_INPUT
    new: BOOL;
END_VAR
    %instance_name%_ENABLE := new;
    IF NOT %instance_name%_ENABLE THEN
		%instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
	END_IF
     _%instance_name%_ENABLE := ERROR_CODE.NO_ERROR;
END_FUNCTION


FUNCTION _%instance_name%_IS_ENABLE : BOOL
    _%instance_name%_IS_ENABLE := %instance_name%_ENABLE;
END_FUNCTION


FUNCTION _%instance_name%_STATUS : MODBUS_STATUS
    _%instance_name%_STATUS := %instance_name%_STATUS;
END_FUNCTION


FUNCTION _%instance_name%_GET_SLAVE_ID : BYTE

    _%instance_name%_GET_SLAVE_ID := %instance_name%_SlaveID;

END_FUNCTION

FUNCTION _%instance_name%_SET_SLAVE_ID : ERROR_CODE
VAR_INPUT
    new: BYTE;
END_VAR
    %instance_name%_SlaveID := new;
    _%instance_name%_SET_SLAVE_ID := ERROR_CODE.NO_ERROR;
END_FUNCTION

FUNCTION _%instance_name%_GET_IP: STRING
    _%instance_name%_GET_IP := %instance_name%_IP_name;
END_FUNCTION

FUNCTION _%instance_name%_SET_IP: ERROR_CODE
VAR_INPUT
    IP: STRING;
END_VAR
VAR
    ret : DINT;
    addr : HSAL_SA_INET;
END_VAR
    //printf('try parse %s adr$N',IP);
    ret := %instance_name%_data.sock.pton(HSAL_Socket_Domain.AF_INET,  IP, ADR(addr.addr));
    if (ret < 0) THEN
        printf('error %d$N',ret);
        _%instance_name%_SET_IP := ERROR_CODE.ERR_INVALID_PARAMETER;
    END_IF
    //printf('OK IP=%LX$N',addr.addr);
    %instance_name%_IP_name := IP;
    %instance_name%_IP_addr := addr.addr;
    _%instance_name%_SET_IP := ERROR_CODE.NO_ERROR;
END_FUNCTION

FUNCTION _%instance_name%_GET_PORT: WORD
    _%instance_name%_GET_PORT:=%instance_name%_port;
END_FUNCTION
FUNCTION _%instance_name%_SET_PORT: ERROR_CODE
VAR_INPUT
    port: WORD;
END_VAR
    %instance_name%_port := port;
    _%instance_name%_SET_PORT := ERROR_CODE.NO_ERROR;
END_FUNCTION

FUNCTION _%instance_name%_GET_SOCKET_TIMEOUT: WORD
     _%instance_name%_GET_SOCKET_TIMEOUT := %instance_name%_timeout_soc;
END_FUNCTION
FUNCTION _%instance_name%_SET_SOCKET_TIMEOUT: ERROR_CODE
VAR_INPUT
    timeout: WORD;
END_VAR
VAR
    result: BOOL;
END_VAR
    %instance_name%_timeout_soc := Check_par_value_WORD(%instance_name%_timeout_soc,timeout,%min(5)%,%max(5)%,result);
    IF result THEN
        _%instance_name%_SET_SOCKET_TIMEOUT := ERROR_CODE.NO_ERROR;
    ELSE
        _%instance_name%_SET_SOCKET_TIMEOUT := ERROR_CODE.ERR_INVALID_PARAMETER;
    END_IF
END_FUNCTION
	
FUNCTION _%instance_name%_GET_POLL_PERIOD: WORD
    _%instance_name%_GET_POLL_PERIOD := %instance_name%_poll_period;
END_FUNCTION
FUNCTION _%instance_name%_SET_POLL_PERIOD: ERROR_CODE
VAR_INPUT
    period: UINT;
END_VAR
VAR
    result: BOOL;
END_VAR
    %instance_name%_poll_period := Check_par_value_WORD(%instance_name%_poll_period,period,%min(6)%,%max(6)%,result);
    IF result THEN
         _%instance_name%_SET_POLL_PERIOD := ERROR_CODE.NO_ERROR;
    ELSE
         _%instance_name%_SET_POLL_PERIOD := ERROR_CODE.ERR_INVALID_PARAMETER;
    END_IF

END_FUNCTION

FUNCTION _%instance_name%_GET_MODBUS_ORDERS : MODBUS_ORDERS
    _%instance_name%_GET_MODBUS_ORDERS := %instance_name%_byteorder;
END_FUNCTION

FUNCTION _%instance_name%_SET_MODBUS_ORDERS: ERROR_CODE
VAR_INPUT
    ORDERS: MODBUS_ORDERS;
END_VAR
    IF (BYTE#ORDERS>3) THEN _%instance_name%_SET_MODBUS_ORDERS := ERROR_CODE.ERR_INVALID_PARAMETER; 
    ELSE
    _%instance_name%_SET_MODBUS_ORDERS := ERROR_CODE.NO_ERROR;
    %instance_name%_byteorder := ORDERS;
    END_IF
END_FUNCTION
/*

FUNCTION _%instance_name%_GET_WATCHDOG_TIME_MS : WORD
    _%instance_name%_GET_WATCHDOG_TIME_MS := %instance_name%_watchdog;
END_FUNCTION

FUNCTION _%instance_name%_SET_WATCHDOG_TIME_MS: ERROR_CODE
VAR_INPUT
    time: WORD;
END_VAR
    IF (time>^max(8)%) THEN _%instance_name%_SET_WATCHDOG_TIME_MS := ERROR_CODE.ERR_INVALID_PARAMETER; 
    ELSE
    _%instance_name%_SET_WATCHDOG_TIME_MS := ERROR_CODE.NO_ERROR;
    %instance_name%_watchdog := time;
    END_IF
END_FUNCTION
*/

FUNCTION _%instance_name%_IS_USED_MASTER_POLLING_SETTINGS: BOOL
    _%instance_name%_IS_USED_MASTER_POLLING_SETTINGS := %instance_name%_use_master;
END_FUNCTION


FUNCTION _%instance_name%_GET_RESPONSE_TIMEOUT : WORD
    _%instance_name%_GET_RESPONSE_TIMEOUT := %instance_name%_resp_timeout;
END_FUNCTION

FUNCTION _%instance_name%_SET_RESPONSE_TIMEOUT: ERROR_CODE
VAR_INPUT
    time: WORD;
END_VAR
VAR
    result: BOOL;
END_VAR
    IF %instance_name%_use_master THEN
        _%instance_name%_SET_RESPONSE_TIMEOUT := ERROR_CODE.ERR_FORBIDDEN;
        RETURN;
    END_IF
    %instance_name%_resp_timeout := Check_par_value_WORD(%instance_name%_resp_timeout,time,%min(10)%,%max(10)%,result);
    IF result THEN
        _%instance_name%_SET_RESPONSE_TIMEOUT := ERROR_CODE.NO_ERROR;
    ELSE
        _%instance_name%_SET_RESPONSE_TIMEOUT := ERROR_CODE.ERR_INVALID_PARAMETER;
    END_IF
END_FUNCTION

FUNCTION _%instance_name%_GET_RETRY_COUNT: WORD
    _%instance_name%_GET_RETRY_COUNT:= %instance_name%_retry_cnt;
END_FUNCTION

FUNCTION _%instance_name%_SET_RETRY_COUNT: ERROR_CODE
VAR_INPUT
    count: UINT;
END_VAR
VAR
    result: BOOL;
END_VAR
    IF %instance_name%_use_master THEN
        _%instance_name%_SET_RETRY_COUNT := ERROR_CODE.ERR_FORBIDDEN;
        RETURN;
    END_IF
    %instance_name%_retry_cnt := Check_par_value_WORD(%instance_name%_retry_cnt,count,%min(11)%,%max(11)%,result);
    IF result THEN
        _%instance_name%_SET_RETRY_COUNT := ERROR_CODE.NO_ERROR;
    ELSE
        _%instance_name%_SET_RETRY_COUNT := ERROR_CODE.ERR_INVALID_PARAMETER;
    END_IF

END_FUNCTION

FUNCTION _%instance_name%_GET_LAST_TAG: WORD
    _%instance_name%_GET_LAST_TAG:=%instance_name%_last_tag;
END_FUNCTION


FUNCTION _%instance_name%_GET_LAST_POLLTIME: DWORD
    _%instance_name%_GET_LAST_POLLTIME := %instance_name%_last_polltime;
END_FUNCTION

FUNCTION _%instance_name%_LAST_ERROR: MODBUS_ERROR_CODES
    _%instance_name%_LAST_ERROR := %instance_name%_last_error;
END_FUNCTION

FUNCTION _%instance_name%_Setup : FAL_STATUS
VAR
    i,j         : DINT;
    pelem       : REF_TO MODBUS_VAR_ELEM_MASTER;
    last_adr    : WORD;
    last_adr_I  : WORD; //Последний адрес для области holds
    ret         : DINT;
END_VAR 
    _%instance_name%_Setup:=FAL_STATUS.ERROR_INIT;  
    if ({#num_of(%add_var_to_massiv_DEV%)}<=0)  THEN RETURN; END_IF
    %instance_name%_enter_if:=ADR(_%instance_name%_enter_if);
    hsal_socket_constructor(ADR(%instance_name%_data.sock));
    //Проверяем IP - тут может быть ошибка
    IF _%instance_name%_SET_IP(%instance_name%_IP_name)<>ERROR_CODE.NO_ERROR THEN
        %instance_name%_IP_addr := 0; //Коннекта не произойдёт
    END_IF
	
	//printf('M1$N');
    //Настраиваем указатели на переменные/их описатели для быстрого поиска 
    FOR i:=MODBUS_DEV_TCP_CHANNEL_COUNT.MAX TO ({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1) DO
        //Для каждого канала ищем свой описатель
        FOR j:=0 TO ({#num_of(%add_var_to_massiv_DEV%)}-1) DO
            IF (modbus_varsDevCEs%I%[j].channel_index=i) THEN
            %instance_name%_index_array%I%[i].p_elem:=ADR(modbus_varsDevCEs%I%[j]); 
            EXIT;
            END_IF
        END_FOR
    END_FOR
    //теперь назначим адреса (заглушка если не заданы адреса в дереве)
    last_adr:=0;
    FOR j:=0 TO ({#num_of(%add_var_to_massiv_DEV%)}-1) DO
        pelem:=ADR(modbus_varsDevCEs%I%[j]);
        IF (pelem^.var_addr=(-1)) THEN
            pelem^.var_addr:=last_adr; 
            pelem^.p_adr:=ADR(modbusDevCEs_mem%I%[0])+last_adr*2;
            last_adr:=last_adr+(pelem^.var_size/2);
            //printf('Hset for [%d].var_adr=%d at %lx$N',j,pelem^.var_addr,pelem^.p_adr);
        ELSE
            pelem^.p_adr:=ADR(modbusDevCEs_mem%I%[0])+pelem^.var_addr*2;
        END_IF
    END_FOR

    
    //printf('M4$N');
    //небольшая проверка правильности инициализации
    FOR i:=MODBUS_DEV_TCP_CHANNEL_COUNT.MAX TO ({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1) DO
        pelem:=%instance_name%_index_array%I%[i].p_elem;
        assert('%instance_name%_index_array%I% init failed$N',pelem<>0);
    END_FOR   
    //printf('M5$N');
    hsal_mutex_constructor(ADR(mutex_%instance_name%));
    mutex_%instance_name%.init^(ADR(mutex_%instance_name%));

    //init_task
	hsal_thread_constructor(ADR(%instance_name%_thread));
	%instance_name%_thread.attrs.priority:=_MODBUS_MASTER_PRIORITY;
	%instance_name%_thread.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := %instance_name%_thread.create^(ADR(%instance_name%_thread), %instance_name%_enter_if, ADR(%instance_name%_task));
	IF (ret < 0) THEN
		printf('Thread %instance_name% not started$N'); //%task_name%
        _%instance_name%_Setup :=FAL_STATUS.ERROR_INIT;
    ELSE
        ret := %instance_name%_thread.runtime_set_name^(ADR(%instance_name%_thread), '%instance_name%');
        if (ret < 0) THEN
            printf('Thread error %d - not change name to %task_name%$N',ret); 
        END_IF
        _%instance_name%_Setup :=FAL_STATUS.OK;
	END_IF
END_FUNCTION



FUNCTION _%instance_name%_InitFal : FAL_STATUS
VAR_INPUT 
	inst_data: DWORD;
END_VAR
VAR_IN_OUT
	inst: FAL_HANDLE;
END_VAR
VAR
    ret:DINT:=-1;
END_VAR    
	assert ('Error! _%instance_name%_Setup() must be run at first!',%instance_name%_enter_if=ADR(_%instance_name%_enter_if));
    inst:=%instance_name%_enter_if;
    _%instance_name%_InitFal:=FAL_STATUS.OK;
    %instance_name%_STATUS := MODBUS_STATUS.NOT_INIT; 
END_FUNCTION

FUNCTION _%instance_name%_DeInitFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
    %instance_name%_thread.stop_force^(ADR(%instance_name%_thread));
	printf('Thread %instance_name% stoped_destroy$N');//%task_name%
	_%instance_name%_DeInitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_CheckFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%instance_name%_CheckFal:=FAL_STATUS.OK;
END_FUNCTION



FUNCTION _%instance_name%_GetIface : REF_TO VOID
VAR_INPUT {ref}
	iface_name: STRING;
END_VAR	
	_%instance_name%_GetIface:=NULL;
END_FUNCTION

FUNCTION _%instance_name%_Get_status : FAL_STATUS
VAR_INPUT
	num: USIZE;
END_VAR	
	_%instance_name%_Get_status:=FAL_STATUS.OK;
END_FUNCTION


FUNCTION _%instance_name%_GetContext : REF_TO VOID
VAR_INPUT
	inst_data: DWORD; //Данные для идентификации экземпляра (для статических членов не используется)
END_VAR
	_%instance_name%_GetContext:=NULL;//ADR(_%instance_name%_data);
END_FUNCTION

//А вот тут реализация задачи ModBus
(*
В задаче последовательно по состояниям захватывается ресурс ABSI, происходить чтение/запись/обработка exeption
 *)
FUNCTION  %instance_name%_task : VOID
VAR_INPUT 
	args: REF_TO VOID; 
END_VAR
VAR
    last_symbol_time : DWORD; //Время ожидания ответа
    last_packet_time : DWORD; //время от предыдущего пакета
    send_size        : DINT;
    resv_size        : DINT;
END_VAR    

VAR 
    inst        : REF_TO FAL_HANDLE;
    absi_res    : ABSI_STATUS;
    res         : DINT;
    data        : BYTE;
    i           : DINT;
    control     : STACK_CONTROL := (name:='%instance_name%_task');
    ret         : DINT;
    psock       : REF_TO HSAL_Socket;
    addr        : HSAL_SA_INET;
    ptag        : REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
    //puts('modbus task');
    inst:=args; //указатель на экземпляр интерфейса EnterIf - используется для получения номера экземпляра (на будущее)
    last_packet_time := DWORD#(hsal_gettime_ms());
    //Используя CONTINUE мы пробегаем без sleep() по позитивному сценарию, сокращая время задержек обработки запросов/ответов
    WHILE (TRUE) DO
        CONTROL_STACK(ADR(control));
        //Вычисляем запаздывание (>0 или отсутствие потребности в опросе <=0)
        %instance_name%_craving := DINT#(DWORD#(hsal_gettime_ms()) - %instance_name%_last_polltime);
        %instance_name%_craving := %instance_name%_craving - %instance_name%_poll_period;
        psock := ADR(%instance_name%_data.sock);
        CASE %instance_name%_state OF
            MODBUS_DEV_TCP_STATES.OFF:
                IF %instance_name%_ENABLE AND BOOL#(%instance_name%_ACII_cntl AND (DWORD#(ACII_STATES.IS_ALLOWED) OR DWORD#(ACII_STATES.IS_WORK))) THEN
                    //puts('CONNECT');
                    %instance_name%_state := MODBUS_DEV_TCP_STATES.CONNECT;
                ELSE 
                    %instance_name%_STATUS := MODBUS_STATUS.NOT_INIT;     
                END_IF
            MODBUS_DEV_TCP_STATES.CONNECT:
            IF NOT %instance_name%_ENABLE THEN
                //puts('CLOSE');
                %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            END_IF
            ret := hsal_socket_constructor(psock);
            if (ret < 0) THEN 
                %instance_name%_state := MODBUS_DEV_TCP_STATES.ERROR;
                CONTINUE;
            END_IF
            ret := psock^.socket(psock, HSAL_Socket_Domain.AF_INET, HSAL_Socket_Type.SOCK_STREAM, HSAL_Socket_Protocol.TCP, true);
            if (ret < 0) THEN
                %instance_name%_state := MODBUS_DEV_TCP_STATES.ERROR;
                CONTINUE;
            END_IF

            // Подключаемся к серверу
            addr.addr := %instance_name%_IP_addr;
            addr.port := %instance_name%_port;
            printf('try connect to %lx:%d->',addr.addr,addr.port);
            ret := psock^.connect(psock, ADR(addr));
            if (ret < 0) THEN
                psock^.close(psock);
                printf('error %d$N',ret);
                %instance_name%_state := MODBUS_DEV_TCP_STATES.ERROR;
                CONTINUE;
            END_IF
            puts('OK');
            %instance_name%_STATUS := MODBUS_STATUS.OK;
            //При единичном опросе  - сразу в .GENERATE
            IF BOOL#(%instance_name%_ACII_cntl AND DWORD#(ACII_STATES.IS_WORK)) THEN
                %instance_name%_state := MODBUS_DEV_TCP_STATES.GENERATE;
                //puts('GENERATE');
                CONTINUE;
            END_IF
            %instance_name%_state  := MODBUS_DEV_TCP_STATES.IDLE;
            


            MODBUS_DEV_TCP_STATES.IDLE:
            //Циклический опрос может быть прерван лишь в этом моменте - если запрос начался - он пройдёт до конца
            IF (NOT %instance_name%_ENABLE) OR  NOT BOOL#(%instance_name%_ACII_cntl AND DWORD#(ACII_STATES.IS_ALLOWED)) THEN
                //puts('CLOSE2');
                %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            END_IF
            /*2 режима - по команде и циклический
            Задаются из мастера
            Если циклический - смотрим на время полинга и начинаем обмен
            Если по команде - запускаем соединение и опрос если пришло разрешение, делаем 1 (ОДИН) запрос и разъединяемся. 
            В последовательном режиме используем внешний ресурс (сокет)
            */
            //Таймаут на перезагрузку не может быть меньше чем период опроса+время ожидания ответа+общая задержка (обычно в районе 4-6 секунд)
            IF DWORD#(hsal_gettime_ms())>(last_packet_time+_TCP_CLIENT_TIMEOUT_MS+%instance_name%_poll_period+%instance_name%_resp_timeout) THEN
                last_packet_time := DWORD#(hsal_gettime_ms());
                %instance_name%_state := MODBUS_DEV_TCP_STATES.ERROR; //Обмена слишком долго не было
                //puts('CLOSE3');
                CONTINUE;
            END_IF;
            
            IF %instance_name%_craving>0 THEN
                %instance_name%_last_polltime := DWORD#(hsal_gettime_ms());
                %instance_name%_state := MODBUS_DEV_TCP_STATES.GENERATE;
                //puts('GENERATE2');
                CONTINUE;
            END_IF;
            
            
            MODBUS_DEV_TCP_STATES.GENERATE:
            IF NOT %instance_name%_ENABLE THEN
                %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            END_IF
            //Импульс включения сразу сбрасываем
            %instance_name%_ACII_cntl := %instance_name%_ACII_cntl AND NOT(DWORD#(ACII_STATES.IS_WORK));
            //берём следующий тег
            IF %instance_name%_last_tag>={#num_of(%add_var_to_massiv_DEV%)} THEN %instance_name%_last_tag := 0;   END_IF;
            ptag := ADR (modbus_varsDevCEs%I%[%instance_name%_last_tag]);
            %instance_name%_last_tag := %instance_name%_last_tag +1;

            %instance_name%_last_error := MODBUS_ERROR_CODES.IN_PROGRESS;
            ret := %instance_name%_GenerateMessage(_%instance_name%_send_buffer.tcp_buf.data,ptag); //Сразу запас на заголовок
            IF ret>4 THEN //Мин размер
                %instance_name%_state := MODBUS_DEV_TCP_STATES.SEND;
                send_size := ret;
                //printf('SEND %d bytes$N',send_size);
                CONTINUE;
            ELSE
               %instance_name%_state := MODBUS_DEV_TCP_STATES.IDLE;  //Ошибка генерации тега не повод сразу закрывать сокет 
            END_IF;
            

            MODBUS_DEV_TCP_STATES.SEND:
            IF NOT %instance_name%_ENABLE THEN
                %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            END_IF
            //Формируем пачку и посылаем
            _%instance_name%_send_buffer.tcp_buf.trans_ID := _%instance_name%_send_buffer.tcp_buf.trans_ID + 1;
            _%instance_name%_send_buffer.tcp_buf.prot_ID  := 0;
            _%instance_name%_send_buffer.tcp_buf.len      := BYTE#send_size;
            res:=psock^.send^(psock, ADR(_%instance_name%_send_buffer), DWORD#(send_size+6), HSAL_Socket_SR_Flags.DONTWAIT);
            IF res>0 THEN
                last_symbol_time:=DWORD#(hsal_gettime_ms()); 
                %instance_name%_state := MODBUS_DEV_TCP_STATES.WAIT_ANSVER;
                //printf('SENDED %d bytes$N',res);
                last_symbol_time := DWORD#(hsal_gettime_ms()); //Тут CONTINUE не надо, т.к. ответ точно будет не мгновенно
            ELSE 
                %instance_name%_state  := MODBUS_DEV_TCP_STATES.ERROR;
            END_IF;


            MODBUS_DEV_TCP_STATES.WAIT_ANSVER:
            IF NOT %instance_name%_ENABLE THEN
                %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            END_IF
            IF DWORD#(hsal_gettime_ms()) > (last_symbol_time + %instance_name%_resp_timeout) THEN //таймаут ответа не повод закрывать сокет
                %instance_name%_state := MODBUS_DEV_TCP_STATES.IDLE;
            END_IF  
            res:=psock^.recv^(psock, ADR(_%instance_name%_resv_buffer), sizeof(_%instance_name%_resv_buffer), HSAL_Socket_SR_Flags.DONTWAIT);
            //printf('resv %d bytes$N',res);
            IF res>=9 THEN //Это TCP, если из пачки модбаса пришло менее 9 байт - она точно бракованная
                resv_size:=res;
                //Разбираем 6 байт
                IF (_%instance_name%_resv_buffer.tcp_buf.prot_ID=0 AND _%instance_name%_resv_buffer.tcp_buf.len<=248 AND _%instance_name%_send_buffer.tcp_buf.trans_ID=_%instance_name%_resv_buffer.tcp_buf.trans_ID) THEN

                    IF _%instance_name%_resv_buffer.tcp_buf.data[0]=%instance_name%_SlaveID THEN
                        resv_size := resv_size - 6;
                        %instance_name%_state := MODBUS_DEV_TCP_STATES.ANALYSE;
                        //puts('ANALYSE2');
                        CONTINUE;
                    END_IF
                    //puts('u');
                    //printf('reseive p=%lx %d bytes$N',pconn_data,this^.received);
                    // this^.timeout:=DWORD#(hsal_gettime_ms());
                END_IF
                //Проверка не прошла - очищаем
                WHILE res>0 DO
                    res := psock^.recv^(psock, ADR(_%instance_name%_resv_buffer), sizeof(_%instance_name%_resv_buffer), HSAL_Socket_SR_Flags.DONTWAIT);
                    resv_size := 0;
                END_WHILE
                %instance_name%_state := MODBUS_DEV_TCP_STATES.IDLE;  //Мусор в ответе не повод сразу закрывать сокет 
            ELSIF (res<>((-1)*HSAL_RETURN_VALUES.EAGAIN)) THEN //А вот ошибки приёма - повод закрыть сокет
                //puts('CLOSE4');
                %instance_name%_state := MODBUS_DEV_TCP_STATES.ERROR;
                CONTINUE;
            END_IF;


            MODBUS_DEV_TCP_STATES.ANALYSE:
            IF NOT %instance_name%_ENABLE THEN
                %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            END_IF
            //printf ('send=%d resv=%d$N',send_size, resv_size);
            ret := %instance_name%_AnalyseMessage(_%instance_name%_resv_buffer.tcp_buf.data, _%instance_name%_send_buffer.tcp_buf.data, send_size,resv_size,ptag,%instance_name%_last_error); 
            %instance_name%_state := MODBUS_DEV_TCP_STATES.IDLE;  //В любом случае возвращаемся в IDLE
            IF ret>0 THEN //Мин размер
                //printf('AnalyseMessage=%d$N',ret);
               //Всё хорошо (возврат slave exeption - Тоже хорошо!) - обновляем время
                last_packet_time := DWORD#(hsal_gettime_ms());
            END_IF;
            

            MODBUS_DEV_TCP_STATES.CLOSE:
            %instance_name%_state := MODBUS_DEV_TCP_STATES.OFF;
            IF (psock<>NULL) AND (psock^.__socket.id<=0) THEN  
                //printf('close5 %lx$N',psock^.__socket.id);
                psock^.shutdown^(psock,HSAL_Socket_Shutdown.RDWR);
                psock^.close^(psock);
                //psock^.__socket.id:=-1;
                //puts('ok');
            END_IF 

            MODBUS_DEV_TCP_STATES.ERROR:
            %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
        ELSE
            %instance_name%_state := MODBUS_DEV_TCP_STATES.CLOSE;
            %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
        END_CASE;
        hsal_sleep_for_ms(_MODBUS_DEV_TCP_PERIOD_MS);
        //puts(',');
        
    END_WHILE;

   //puts('end modbus task %instance_name%');
END_FUNCTION

/*
 * @brief prepare ask
 */

FUNCTION %instance_name%_AnalyseMessage : DINT //возвращает размер пачки (без заголовка/CRC) или -1 если бракованная

VAR_INPUT {ref}
    in_buf: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
    out_buf: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE;
END_VAR

VAR_INPUT
    send_size   : DINT; 
    resv_size   : DINT; 
    ptag   : REF_TO MODBUS_VAR_ELEM_MASTER; 
END_VAR

VAR_IN_OUT
    exeption: MODBUS_ERROR_CODES;
END_VAR

VAR
    func        : BYTE;
    byte_count  : BYTE;
    qty_value   : DINT;
END_VAR
    func:=in_buf[1];
    exeption := MODBUS_ERROR_CODES.RESPONSE_SUCCESS;
    //Если exeption - завершаем обработку
    IF (func>127) THEN
        //printf('exept=%d$N',in_buf[2]);
        exeption := CAST(in_buf[2],MODBUS_ERROR_CODES);
        %instance_name%_AnalyseMessage :=3;
        RETURN;
    END_IF

    //Проверяем на соответствие 
    %instance_name%_AnalyseMessage := resv_size;
    //printf('func=%d$N',func);
    CASE func OF
        MODBUS_FUNCTION_CODES.READ_HOLDING_REGISTERS, MODBUS_FUNCTION_CODES.READ_INPUT_REGISTERS:
        byte_count:=in_buf[2];
        //printf('resv=%d byte_count=%d$N',resv_size, byte_count);
        IF (resv_size<>3+byte_count) THEN 
            %instance_name%_AnalyseMessage := -1;
            puts('ee1');
            exeption := MODBUS_ERROR_CODES.BAD_RESPOSE;
            RETURN;
        END_IF
        IF (byte_count/2 <= MODBUS_MAX_READ_REGISTERS) THEN // chk qty
            qty_value := %instance_name%_WriteRegsInStorage(byte_count/2, 3, ptag, in_buf);
            IF ( qty_value <= 0) THEN
                %instance_name%_AnalyseMessage := -1;
                exeption := MODBUS_ERROR_CODES.BAD_RESPOSE;
                puts('ee2');
                RETURN;
            END_IF
        ELSE
            %instance_name%_AnalyseMessage := -1;
            exeption := MODBUS_ERROR_CODES.BAD_RESPOSE;
            puts('ee3');
            RETURN;
        END_IF

        MODBUS_FUNCTION_CODES.WRITE_SINGLE_REGISTER: //Ответ должен совпадать с запросом
        MODBUS_FUNCTION_CODES.WRITE_MULTIPLE_REGISTERS:
        IF resv_size<>6 THEN
            %instance_name%_AnalyseMessage := -1;
            exeption := MODBUS_ERROR_CODES.BAD_RESPOSE;
            puts('ee4');
            RETURN;
        END_IF;
        IF memcmp(in_buf, out_buf, 6) <> 0 THEN
            %instance_name%_AnalyseMessage := -1;
            exeption := MODBUS_ERROR_CODES.BAD_RESPOSE;
            puts('ee5');
            RETURN;
        END_IF
    ELSE
        %instance_name%_AnalyseMessage := -1;
        exeption := MODBUS_ERROR_CODES.BAD_RESPOSE;
        puts('ee6');
        RETURN;
    END_CASE;
    //puts('OK');
END_FUNCTION



FUNCTION %instance_name%_GenerateMessage : DINT //возвращает размер пачки (без заголовка/CRC) или -1 если не сформирована

VAR_INPUT {ref}
    out_buf: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
END_VAR

VAR_INPUT
    ptag    : REF_TO MODBUS_VAR_ELEM_MASTER; 
END_VAR

VAR
    func        : BYTE;
    address     : WORD;
    qty_value   : DINT;
    byte_count  : BYTE;
    word_count  : WORD;
    
END_VAR
    %instance_name%_GenerateMessage := -1; //Ошибка формирования
    func := ptag^.command;
    address := WORD#(ptag^.var_addr);
    byte_count := ptag^.var_size;
    word_count := (byte_count+1)/2;
    //printf('func=%x adr=%x bc=%d, wc=%d$N',func,address,byte_count,word_count);


    out_buf[0]:=%instance_name%_SlaveID; //adress
    out_buf[1]:=func; //функция

    
    CASE func OF
        MODBUS_FUNCTION_CODES.READ_HOLDING_REGISTERS, MODBUS_FUNCTION_CODES.READ_INPUT_REGISTERS:
            SystemRev16Buffer(ADR(address), 1);
            memcpy (ADR(out_buf[2]),ADR(address),2);
            SystemRev16Buffer(ADR(word_count), 1);
            memcpy (ADR(out_buf[4]),ADR(word_count),2);
            %instance_name%_GenerateMessage :=6;
        
        MODBUS_FUNCTION_CODES.WRITE_SINGLE_REGISTER:
            SystemRev16Buffer(ADR(address), 1);
            memcpy (ADR(out_buf[2]),ADR(address),2);

            qty_value := %instance_name%_ReadRegsInStorage((byte_count+1)/2, 4, ptag, out_buf);
            IF ( qty_value > 0) THEN
                %instance_name%_GenerateMessage:=6; 
            END_IF 


        MODBUS_FUNCTION_CODES.WRITE_MULTIPLE_REGISTERS:
            SystemRev16Buffer(ADR(address), 1);
            memcpy (ADR(out_buf[2]),ADR(address),2);
            SystemRev16Buffer(ADR(word_count), 1);
            memcpy (ADR(out_buf[4]),ADR(word_count),2);
            out_buf[6] := byte_count;
            qty_value := %instance_name%_ReadRegsInStorage((byte_count+1)/2, 7, ptag, out_buf);
            IF ( qty_value > 0) THEN
                %instance_name%_GenerateMessage:=7+byte_count;
            END_IF 

    END_CASE;
END_FUNCTION


FUNCTION %instance_name%_ReadRegsInStorage : DINT
VAR_INPUT
    count: DINT;
    offset: BYTE; //Смещение в буфере, c котогого надо писать данные (до этого будет лежать служебная информация)
    pelem: REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
VAR_IN_OUT
    buffer: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
END_VAR
VAR
    readed: BYTE:= 0;
    aligned_var_size: BYTE;
    I       : DINT;
END_VAR

    count:=count*2; //В БАЙТАХ
    IF pelem<>0 THEN //Нашли
        aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
        //printf('read count=%d var_size=%d var_type=%d var_addr=%d p_addr=%lx$N',count, pelem^.var_size, pelem^.var_type,pelem^.var_addr, pelem^.p_adr);
        //printf(' p_addr=%lx$N', pelem^.p_adr);
        memset(ADR(buffer[offset]),16#00, MODBUS_MAX_PACKET_SIZE-offset);
        IF (count<aligned_var_size) THEN //Попытка частичного чтения 
            %instance_name%_ReadRegsInStorage:=-2;
            RETURN; 
        END_IF
        IF (offset+aligned_var_size>=MODBUS_MAX_PACKET_SIZE) THEN //Попытка переполнения буфера
            %instance_name%_ReadRegsInStorage:=-2;
            RETURN; 
        END_IF
        //Здравствуй, переменная!
        /*FOR I:=0 TO aligned_var_size DO
            printf('%02x ',buffer[offset+I]);
        END_FOR;
        printf('R %lx %dbytes=[%d]$N',pelem^.p_adr,aligned_var_size,offset);*/
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        CopyWithOrder(ADR(buffer[offset]),pelem^.p_adr, aligned_var_size, %instance_name%_byteorder);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));

        offset:=offset+aligned_var_size;
        count:=count-aligned_var_size;
        readed:=readed+aligned_var_size;
    ELSE //Если не нашли начало блока переменных - выдаём ошибку
        %instance_name%_ReadRegsInStorage:=-1;
        RETURN;
    END_IF;
    //Далее конец - мастер режим с дыркой не поддерживает
    %instance_name%_ReadRegsInStorage:=readed;
END_FUNCTION



FUNCTION %instance_name%_WriteRegInStorage : DINT
VAR_INPUT
    value: WORD;
    pelem: REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR

VAR
    aligned_var_size: DWORD;
END_VAR
//ищем переменную

    IF pelem<>0 THEN //Нашли
        aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
        IF (2<>aligned_var_size) THEN //один регистр - это 2 байта!
            %instance_name%_WriteRegInStorage:=-2;
            RETURN; 
        END_IF
        
        //Здравствуй, переменная!
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        CopyWithOrder(pelem^.p_adr, ADR(value), 2, %instance_name%_byteorder);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        %instance_name%_WriteRegInStorage:=2;

    ELSE //Если не нашли начало блока переменных - выдаём ошибку
        %instance_name%_WriteRegInStorage:=-1;
    END_IF;

END_FUNCTION



FUNCTION %instance_name%_WriteRegsInStorage : DINT
VAR_INPUT
    count: DINT;
    offset: BYTE; //Смещение в буфере, c котогого лежат данные (до этого будет лежать служебная информация)
    pelem: REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
VAR_INPUT {ref}
    buffer: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
END_VAR
VAR
    writed: DINT;
    aligned_var_size: BYTE;
    I       : DINT;
END_VAR
 //ищем переменную
   //printf('offset=%d $N',pelem^.var_addr,count,offset);
    count:=count*2; //В БАЙТАХ
    IF pelem<>0 THEN //Нашли
        aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
        //printf('write count=%d var_size=%d var_type=%d var_addr=%d p_addr=%lx$N',count, pelem^.var_size, pelem^.var_type,pelem^.var_addr, pelem^.p_adr);
        IF (count<aligned_var_size) THEN //Попытка частичной записи
            %instance_name%_WriteRegsInStorage:=-2;
           puts('e3');
            RETURN; 
        END_IF
        IF (offset+aligned_var_size>=MODBUS_MAX_PACKET_SIZE) THEN //Попытка обратного переполнения буфера
            %instance_name%_WriteRegsInStorage:=-2;
           puts('e4');
            RETURN; 
        END_IF
        //Здравствуй, переменная!
        /*FOR I:=0 TO aligned_var_size DO
            printf('%02x ',buffer[offset+I]);
        END_FOR;
        printf('W %lx %dbytes=[%d]$N',pelem^.p_adr,aligned_var_size,offset);*/

        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        
        CopyWithOrder(pelem^.p_adr, ADR(buffer[offset]), aligned_var_size, %instance_name%_byteorder);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));

        offset:=offset+aligned_var_size;
        count:=count-aligned_var_size;
        writed:=writed+aligned_var_size;
    ELSE //Если не нашли начало блока переменных - выдаём ошибку
        %instance_name%_WriteRegsInStorage:=-1;
        puts('e5');
        RETURN;
    END_IF;
    //Далее конец - режим с дыркой и мультизапросы мастер не поддерживает
    %instance_name%_WriteRegsInStorage:=writed;
END_FUNCTION





FUNCTION %instance_name%_Read : VOID
VAR_INPUT
    index:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
    //проверка на диапазон
    
    IF ((index<MODBUS_DEV_TCP_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1)))) THEN
        puts('r1');
        RETURN;
    END_IF
    pelem:=%instance_name%_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        memcpy(data,pelem^.p_adr,pelem^.var_size);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        //printf('in=%d data=%p from=%p$N',index,data,pelem^.p_adr);
    ELSE
        puts('r2');    
    END_IF


END_FUNCTION


FUNCTION %instance_name%_Write: VOID

VAR_INPUT
    index:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
//проверка на диапазон
    IF ((index<MODBUS_DEV_TCP_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1)))) THEN
        puts('w1');
        RETURN;
    END_IF
    pelem:=%instance_name%_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        memcpy(pelem^.p_adr,data,pelem^.var_size);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
    ELSE
        puts('w2');      
    END_IF
   
END_FUNCTION

FUNCTION %instance_name%_Read_bit : VOID
VAR_INPUT
    index   :  WORD;
    bit     : BYTE;
    data    : REF_TO BOOL;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM_MASTER;
    temp_DWORD  : DWORD; //Максимальный пока размер типа с битмаской
END_VAR
    //проверка на диапазон
    IF ((index<MODBUS_DEV_TCP_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=%instance_name%_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        IF bit<(pelem^.var_size*8) THEN
            mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
            memcpy(ADR(temp_DWORD),pelem^.p_adr,pelem^.var_size);
            IF (temp_DWORD AND NOT (SHL(DWORD#1,bit)))<>0 THEN data^:=TRUE;
            ELSE data^:=FALSE;
            END_IF
            mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        END_IF
    END_IF
END_FUNCTION


FUNCTION %instance_name%_Write_bit: VOID

VAR_INPUT
    index   :  WORD;
    bit     : BYTE;
    data    : REF_TO BOOL;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM_MASTER;
    temp_DWORD  : DWORD; //Максимальный пока размер типа с битмаской
END_VAR
//проверка на диапазон
    IF ((index<MODBUS_DEV_TCP_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=%instance_name%_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        IF bit<(pelem^.var_size*8) THEN
            mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
            memcpy(ADR(temp_DWORD),pelem^.p_adr,pelem^.var_size);
            temp_DWORD := temp_DWORD AND NOT (SHL(DWORD#1,DWORD#(data^)));
            memcpy(pelem^.p_adr,ADR(temp_DWORD),pelem^.var_size);
            mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        END_IF
    END_IF
   
END_FUNCTION




FUNCTION %instance_name%_ReadSubCh: VOID
VAR_INPUT
    index:  WORD;
    subindex:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
    IF ((index<MODBUS_DEV_TCP_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=%instance_name%_index_array%I%[index].p_elem;
    case subindex of
	0: // address
	    //пока одновременного доступа не ожидается, как появится - добавим мютекс
		memcpy(data,ADR(pelem^.var_addr),sizeof(pelem^.p_adr));
	    
	ELSE
           printf('smth went wrong$N');
    end_case
END_FUNCTION

FUNCTION %instance_name%_WriteSubCh: VOID
VAR_INPUT
    index:  WORD;
    subindex:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM_MASTER;
END_VAR
    IF ((index<MODBUS_DEV_TCP_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_DEV_TCP_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=%instance_name%_index_array%I%[index].p_elem;
    // TODO - may be need any lock or check access?
    case subindex of
	0: // address
	   //пока одновременного доступа не ожидается, как появится - добавим мютекс
		memcpy(ADR(pelem^.var_addr),data,sizeof(pelem^.p_adr));
 
	ELSE
           printf('smth went wrong$N');
    end_case
END_FUNCTION

FUNCTION AXXI_GET_EXTENDED_%instance_name% : ABSI_STATUS //считывает из интерфейса расширенные настройки
	VAR_INPUT
		preq : REF_TO AXXI_EXTENDED_SERVICES;
	END_VAR
    VAR
        st  : REF_TO ACII_SERVICE_STATE;
    END_VAR

    AXXI_GET_EXTENDED_%instance_name%:= ABSI_STATUS.HAS_DATA;

    AXXI_GET_EXTENDED_%instance_name%:= ABSI_STATUS.HAS_DATA;
    CASE preq^.service OF
        ACII_SERVICES.STATE: 
            st:=  CAST (preq, REF_TO ACII_SERVICE_STATE);
            
            st^.craving := %instance_name%_craving;
            IF (%instance_name%_last_error=MODBUS_ERROR_CODES.RESPONSE_SUCCESS) OR (%instance_name%_last_error=MODBUS_ERROR_CODES.IN_PROGRESS) THEN
                st^.state := %instance_name%_ACII_state;
            ELSE
                st^.state := %instance_name%_ACII_state OR DWORD#(ACII_STATES.HAS_ERROR);
            END_IF 
    ELSE
        AXXI_GET_EXTENDED_%instance_name%:= ABSI_STATUS.EXT_SER_NOT_SUPP;
    END_CASE;

END_FUNCTION

FUNCTION AXXI_SET_EXTENDED_%instance_name% : ABSI_STATUS //передаёт в интерфейс расширенные настройки
    VAR_INPUT
        preq: REF_TO AXXI_EXTENDED_SERVICES;
    END_VAR
    VAR
        con  : REF_TO ACII_SERVICE_CONTROL;
        giv : REF_TO ACII_SERVICE_GR;
    END_VAR

    AXXI_SET_EXTENDED_%instance_name%:= ABSI_STATUS.HAS_DATA;
    CASE preq^.service OF

        ACII_SERVICES.CONTROL:
            con := CAST (preq, REF_TO ACII_SERVICE_CONTROL);
            %instance_name%_ACII_cntl :=  con^.state;
            //puts ('%instance_name% ACII_SERVICES.CONTROL');

        ACII_SERVICES.GIVE_RESOURCE:
            giv := CAST (preq, REF_TO ACII_SERVICE_GR);
            %instance_name%_gived_res := giv^.resource_data;
            %instance_name%_is_gived  := giv^.recource_is_gived;

    ELSE
        AXXI_SET_EXTENDED_%instance_name%:= ABSI_STATUS.EXT_SER_NOT_SUPP;
    END_CASE;

END_FUNCTION


