
/*код компонента*/

VAR_GLOBAL
	/*
	modbus_DEVs%I%:array [0..{#num_of(%add_DEV_to_massiv%)}] OF MODBUS_DEVICE{%entQSquare@O<>%}
        {%add_DEV_to_massiv<,>%}
        {%extQSquare@O<>%};
	*/
END_VAR

VAR_GLOBAL
	_%instance_name%_data:modbusmasterTCP_DATA;
	_%instance_name%_enter_if:FAL_ENTER_IF:= (
		inst_data:=%I%,	
		GetContext:=ADR(_%instance_name%_GetContext) ,
		InitFal:=ADR(_%instance_name%_InitFal),
		DeInitFal:=ADR(_%instance_name%_DeInitFal),
		CheckFal:=ADR(_%instance_name%_CheckFal),
		GetIface:=ADR(_%instance_name%_GetIface)
	);
	%instance_name%_enter_if:REF_TO FAL_ENTER_IF;//:=ADR(_%instance_name%_enter_if);
	_%instance_name%_if:modbusmasterTCP_IF:= (
		Get_status:=ADR(_%instance_name%_Get_status)
	);
END_VAR

VAR_GLOBAL 
    %instance_name%_thread :HSAL_Thread;
    mutex_%instance_name%:HSAL_Mutex;
END_VAR


VAR_GLOBAL
	%instance_name%_ENABLE 				: BOOL := %value(0)%;
	%instance_name%_STATUS 				: MODBUS_STATUS;
	//%instance_name%_RETRY_COUNT 		: WORD := %value(4)%;
	%instance_name%_REQUEST_PAUSE 		: WORD := %value(5)%;
	%instance_name%_PARALLEL_POLL		: BOOL := %value(6)%;
	%instance_name%_SLAVE_DEVICES_STATUS: BOOL;	

	//текущие данные
	%instance_name%_enabled				: BOOL := FALSE;

END_VAR




FUNCTION _%instance_name%_ENABLE: VOID
VAR
	enable: BOOL; 
END_VAR
	%instance_name%_ENABLE := enable;
END_FUNCTION
FUNCTION _%instance_name%_IS_ENABLE: BOOL
	_%instance_name%_IS_ENABLE := %instance_name%_ENABLE;
END_FUNCTION

	
FUNCTION _%instance_name%_STATUS: MODBUS_STATUS
	_%instance_name%_STATUS := %instance_name%_STATUS;
END_FUNCTION
	
FUNCTION _%instance_name%_GET_REQUEST_PAUSE: WORD
	%instance_name%_REQUEST_PAUSE := %instance_name%_REQUEST_PAUSE ;
END_FUNCTION


/*
FUNCTION _%instance_name%_GET_RETRY_COUNT: WORD
	%instance_name%_RETRY_COUNT := %instance_name%_RETRY_COUNT ;
END_FUNCTION*/

	
FUNCTION _%instance_name%_PARALLEL_POLL: VOID
VAR
	in: BOOL; 
END_VAR
	%instance_name%_PARALLEL_POLL := in;
	
END_FUNCTION
FUNCTION _%instance_name%_IS_PARALLEL_POLL: BOOL
	_%instance_name%_IS_PARALLEL_POLL := %instance_name%_PARALLEL_POLL;
END_FUNCTION


FUNCTION _%instance_name%_SLAVE_DEVICES_STATUS: BOOL
	_%instance_name%_SLAVE_DEVICES_STATUS := %instance_name%_SLAVE_DEVICES_STATUS;
END_FUNCTION	

FUNCTION _%instance_name%_Setup : FAL_STATUS
VAR
	ret: DINT; 
END_VAR

	%instance_name%_enter_if:=ADR(_%instance_name%_enter_if);
	hsal_mutex_constructor(ADR(mutex_%instance_name%));
    mutex_%instance_name%.init^(ADR(mutex_%instance_name%));

    //init_task
	hsal_thread_constructor(ADR(%instance_name%_thread));
	%instance_name%_thread.attrs.priority:=_MODBUS_MASTER_PRIORITY+1; //Управляющий компонент должен быть приоритетнее девайсов
	%instance_name%_thread.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := %instance_name%_thread.create^(ADR(%instance_name%_thread), %instance_name%_enter_if, ADR(%instance_name%_task));
	IF (ret < 0) THEN
		printf('Thread %instance_name% not started$N'); //%task_name%
        _%instance_name%_Setup :=FAL_STATUS.ERROR_INIT;
    ELSE
        ret := %instance_name%_thread.runtime_set_name^(ADR(%instance_name%_thread), '%instance_name%');
        if (ret < 0) THEN
            printf('Thread error %d - not change name to %task_name%$N',ret); 
        END_IF
        _%instance_name%_Setup :=FAL_STATUS.OK;
	END_IF
END_FUNCTION

FUNCTION _%instance_name%_InitFal : FAL_STATUS
VAR_INPUT 
	inst_data: DWORD;
END_VAR
VAR_IN_OUT
	inst: FAL_HANDLE;
END_VAR
//Для динамических создаётся экземплря с разными inst_data
	assert ('Error! _%instance_name%_Setup() must be run at first!',%instance_name%_enter_if=ADR(_%instance_name%_enter_if));
    inst:=%instance_name%_enter_if;
    _%instance_name%_InitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_DeInitFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%instance_name%_DeInitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_CheckFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%instance_name%_CheckFal:=FAL_STATUS.OK;
END_FUNCTION



FUNCTION _%instance_name%_GetIface : REF_TO VOID
VAR_INPUT {ref}
	iface_name: STRING;
END_VAR	
	if ( STRING_EQUAL(modbusmasterTCP_IF_NAME,iface_name)) THEN
		_%instance_name%_GetIface:=ADR(_%instance_name%_if);
	END_IF
	_%instance_name%_GetIface:=NULL;
END_FUNCTION

FUNCTION _%instance_name%_Get_status : FAL_STATUS
VAR_INPUT
	num: USIZE;
END_VAR	
	_%instance_name%_Get_status:=FAL_STATUS.OK;
END_FUNCTION


FUNCTION _%instance_name%_GetContext : REF_TO VOID
VAR_INPUT
	inst_data: DWORD; //Данные для идентификации экземпляра (для статических членов не используется)
END_VAR
	_%instance_name%_GetContext:=ADR(_%instance_name%_data);
END_FUNCTION

/*
2 режима работы
1. Паралельный, простой, включаем все устройства, следим за их состоянием и если какой-то с ошибкой - записываем 1 в канал Device_Status
2. Последовательный - выделяем ресурс - socket, и по очереди отправляем его к самым опоздавшим устройствам


 */
FUNCTION  %instance_name%_task : VOID
VAR_INPUT 
	args: REF_TO VOID; 
END_VAR
VAR
    last_symbol_time : DWORD; //Время ожидания ответа
    last_packet_time : DWORD; //время от предыдущего пакета
    send_size        : DWORD;
    resv_size        : DWORD;
END_VAR    

VAR 
    inst        : REF_TO FAL_HANDLE;
    absi_res    : ABSI_STATUS;
    res         : DINT;
    data        : BYTE;
    i           : DINT;
    control     : STACK_CONTROL := (name:='%instance_name%_task');
    ret         : DINT;
    psock       : REF_TO HSAL_Socket;
    addr        : HSAL_SA_INET;
END_VAR
    //puts('modbus task');
    inst:=args; //указатель на экземпляр интерфейса EnterIf - используется для получения номера экземпляра (на будущее)
    last_packet_time := DWORD#(hsal_gettime_ms());
    //Используя CONTINUE мы пробегаем без sleep() по позитивному сценарию, сокращая время задержек обработки запросов/ответов
    WHILE (TRUE) DO
        CONTROL_STACK(ADR(control));
        hsal_sleep_for_ms(_MODBUS_MASTER_TCP_PERIOD_MS);
        //puts(',');
		IF %instance_name%_PARALLEL_POLL THEN
			%instance_name%_WORK_PARALLEL();
		ELSE
			%instance_name%_WORK_SEQUENT();
		END_IF;
		
        
    END_WHILE;
   puts('end task %instance_name%');
END_FUNCTION


FUNCTION %instance_name%_WORK_PARALLEL : VOID
VAR
	req		: ACII_SERVICE_CONTROL;
	stat	: ACII_SERVICE_STATE;
	I		: DINT;
	pelem	: REF_TO MODBUS_DEVICE;
	res 	: ABSI_STATUS; 
END_VAR

	IF %instance_name%_ENABLE<>%instance_name%_enabled THEN //Включаем/Выключаем
		req.header.data_size := DINT#(sizeof(req.state));
		req.header.service := ACII_SERVICES.CONTROL;
		%instance_name%_enabled:=%instance_name%_ENABLE;
		req.state := 0;
		IF (%instance_name%_ENABLE) THEN
			req.state := ACII_STATES.IS_ALLOWED;
		END_IF
		puts ('Switch dev state');
		{%SEC_AXXI_SET_EXTENDED@Lchild[ ]%}
	END_IF;
	
	%instance_name%_SLAVE_DEVICES_STATUS := 0;
	IF %instance_name%_enabled THEN
		%instance_name%_SLAVE_DEVICES_STATUS := 0;
		/*
		stat.header.data_size := sizeof(stat.state) + sizeof(stat.craving);
		stat.header.service := ACII_SERVICES.STATE;
		FOR I:=0 TO {#num_of(%add_DEV_to_massiv%)}-1 DO
			pelem := ADR(modbus_DEVs%I%[I]);
			res := pelem^.get_ext^(stat);
			IF res=ABSI_STATUS.HAS_DATA THEN
				%instance_name%_SLAVE_DEVICES_STATUS := %instance_name%_SLAVE_DEVICES_STATUS OR BOOL#(DWORD#(stat.state) AND DWORD#(ACII_STATES.HAS_ERROR));
			END_IF
		END_FOR;
		*/
	END_IF

	
END_FUNCTION



FUNCTION %instance_name%_WORK_SEQUENT : VOID
	
END_FUNCTION
