/*
Компонент работает в режиме RTU only БЕЗ CRC, TCP_Server должен сам манипулировать заголовком, а RS-порт проверять CRC и преобразовывать из/в ASCII

 */


VAR_GLOBAL 
    //Даже если нет входов или выходов - массив единичного размер [0..0] всё равно будет создан для избежания ошибки компиляции
    modbus_varsCEs%I%:array [0..{#num_of(%add_var_to_massiv_CE%)}] OF MODBUS_VAR_ELEM{%entQSquare@O<>%}
        {%add_var_to_massiv_CE<,>%}
        {%extQSquare@O<>%};
   
    modbusCEs_mem%I%: array [0..({%count_var_size_CE< >%}0)] OF BYTE:=[{%get_def_val_CE[,]%}0];

    modbus_index_array%I%: array [MODBUS_SLAVE_CHANNEL_COUNT.MAX..{%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX] OF MODBUS_SEARCH_ELEM;
END_VAR

VAR_GLOBAL 
    %instance_name%_thread :HSAL_Thread;
    mutex_%instance_name%:HSAL_Mutex;
END_VAR


VAR_GLOBAL
	_%instance_name%_enter_if:FAL_ENTER_IF	 := (
		inst_data:=%I%,	
		GetContext:=ADR(_%instance_name%_GetContext) ,
		InitFal:=ADR(_%instance_name%_InitFal),
		DeInitFal:=ADR(_%instance_name%_DeInitFal),
		CheckFal:=ADR(_%instance_name%_CheckFal),
		GetIface:=ADR(_%instance_name%_GetIface)
	);
	%instance_name%_enter_if    : REF_TO FAL_ENTER_IF;//:=ADR(_%instance_name%_enter_if);
    %instance_name%_STATUS      : MODBUS_STATUS:= MODBUS_STATUS.NOT_INIT;
    %instance_name%_state       : MODBUS_SLAVE_STATES:= MODBUS_SLAVE_STATES.NOT_INIT;
    %instance_name%_SlaveID     : BYTE;
    %instance_name%_byteorder   : MODBUS_ORDERS;
    %instance_name%_watchdog    : WORD;
    %instance_name%_ENABLE      : BOOL := %value(4)%;
    %instance_name%_delay       : WORD;

    _%instance_name%_buffer: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE;
    _%instance_name%_send_buffer: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE;
	
END_VAR


FUNCTION _%instance_name%_ENABLE : VOID
VAR_INPUT
    new: BOOL;
END_VAR
    %instance_name%_ENABLE := new;
    IF NOT %instance_name%_ENABLE THEN
		%instance_name%_state:=MODBUS_SLAVE_STATES.REINIT;
	END_IF
END_FUNCTION


FUNCTION _%instance_name%_IS_ENABLE : BOOL
    _%instance_name%_IS_ENABLE := %instance_name%_ENABLE;
END_FUNCTION



FUNCTION _%instance_name%_GET_SLAVE_ID : BYTE

    _%instance_name%_GET_SLAVE_ID := %instance_name%_SlaveID;

END_FUNCTION

FUNCTION _%instance_name%_SET_SLAVE_ID : VOID
VAR_INPUT
    new: BYTE;
END_VAR
    %instance_name%_SlaveID := new;
END_FUNCTION


FUNCTION _%instance_name%_GET_MODBUS_ORDERS : MODBUS_ORDERS

    _%instance_name%_GET_MODBUS_ORDERS := %instance_name%_byteorder;

END_FUNCTION

FUNCTION _%instance_name%_SET_MODBUS_ORDERS: ERROR_CODE
VAR_INPUT
    ORDERS: MODBUS_ORDERS;
END_VAR
    IF (BYTE#ORDERS>3) THEN _%instance_name%_SET_MODBUS_ORDERS := ERROR_CODE.ERR_INVALID_PARAMETER; 
    ELSE
    _%instance_name%_SET_MODBUS_ORDERS := ERROR_CODE.NO_ERROR;
    %instance_name%_byteorder := ORDERS;
    END_IF
END_FUNCTION

FUNCTION _%instance_name%_GET_WATCHDOG_TIME_MS : WORD

    _%instance_name%_GET_WATCHDOG_TIME_MS := %instance_name%_watchdog;

END_FUNCTION

FUNCTION _%instance_name%_SET_WATCHDOG_TIME_MS: ERROR_CODE
VAR_INPUT
    time: WORD;
END_VAR
    IF (time>%max(3)%) THEN _%instance_name%_SET_WATCHDOG_TIME_MS := ERROR_CODE.ERR_INVALID_PARAMETER; 
    ELSE
    _%instance_name%_SET_WATCHDOG_TIME_MS := ERROR_CODE.NO_ERROR;
    %instance_name%_watchdog := time;
    END_IF
END_FUNCTION


FUNCTION _%instance_name%_STATUS : MODBUS_STATUS
    _%instance_name%_STATUS := %instance_name%_STATUS;
END_FUNCTION


FUNCTION _%instance_name%_GET_RESPONSE_DELAY_MS : WORD
    _%instance_name%_GET_RESPONSE_DELAY_MS := %instance_name%_delay;
END_FUNCTION

FUNCTION _%instance_name%_SET_RESPONSE_DELAY_MS: ERROR_CODE
VAR_INPUT
    time: WORD;
END_VAR
    IF (time>%max(5)%) THEN _%instance_name%_SET_RESPONSE_DELAY_MS := ERROR_CODE.ERR_INVALID_PARAMETER; 
    ELSE
    _%instance_name%_SET_RESPONSE_DELAY_MS := ERROR_CODE.NO_ERROR;
    %instance_name%_delay := time;
    END_IF
END_FUNCTION


FUNCTION _%instance_name%_Setup : FAL_STATUS
VAR
    i,j:DINT;
    pelem:REF_TO MODBUS_VAR_ELEM;
    last_adr:WORD;
    last_adr_I:WORD; //Последний адрес для области holds
END_VAR 
    _%instance_name%_Setup:=FAL_STATUS.ERROR_INIT;   
    %instance_name%_enter_if:=ADR(_%instance_name%_enter_if);

    %instance_name%_SlaveID    := Pass_par_value_BYTE(%instance_name%_SlaveID,%value(1)%,%min(1)%,%max(1)%);
    %instance_name%_byteorder  := Pass_par_value_BYTE(BYTE#%instance_name%_byteorder,BYTE#(%value(2)%),%min(2)%,%max(2)%);
    %instance_name%_watchdog   := Pass_par_value_WORD(%instance_name%_watchdog,%value(3)%,%min(3)%,%max(3)%);
    %instance_name%_delay      := Pass_par_value_WORD(%instance_name%_delay,%value(5)%,%min(5)%,%max(5)%);
	
	//printf('M1$N');
    //Настраиваем указатели на переменные/их описатели для быстрого поиска 
    FOR i:=MODBUS_SLAVE_CHANNEL_COUNT.MAX TO ({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1) DO
        //Для каждого канала ищем свой описатель
        if ({#num_of(%add_var_to_massiv_CE%)}>0) THEN 
            FOR j:=0 TO ({#num_of(%add_var_to_massiv_CE%)}-1) DO
                IF (modbus_varsCEs%I%[j].channel_index=i) THEN
                modbus_index_array%I%[i].p_elem:=ADR(modbus_varsCEs%I%[j]); 
                EXIT;
                END_IF
            END_FOR
        END_IF
    END_FOR
    //теперь назначим адреса (заглушка если не заданы адреса в дереве)
    last_adr:=0;
    if ({#num_of(%add_var_to_massiv_CE%)}>0) THEN 
        FOR j:=0 TO ({#num_of(%add_var_to_massiv_CE%)}-1) DO
            pelem:=ADR(modbus_varsCEs%I%[j]);
            IF (pelem^.var_addr=(-1)) THEN
                pelem^.var_addr:=last_adr;  //Если в описателе мешанина из заданных адерсов и -1 - будет жопа!
                
                //printf('Hset for [%d].var_adr=%d at %lx$N',j,pelem^.var_addr,pelem^.p_adr);
            //ELSE
            //    pelem^.p_adr:=ADR(modbusCEs_mem%I%[0])+pelem^.var_addr*2;
            END_IF
            pelem^.p_adr:=ADR(modbusCEs_mem%I%[0])+last_adr*2;
            last_adr:=last_adr+(pelem^.var_size/2);
        END_FOR
    END_IF

    
    //printf('M4$N');
    //небольшая проверка правильности инициализации
    FOR i:=MODBUS_SLAVE_CHANNEL_COUNT.MAX TO ({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1) DO
        pelem:=modbus_index_array%I%[i].p_elem;
        assert('modbus_index_array%I% init failed$N',pelem<>0);
    END_FOR   
    //printf('M5$N');
    hsal_mutex_constructor(ADR(mutex_%instance_name%));
    mutex_%instance_name%.init^(ADR(mutex_%instance_name%));


    _%instance_name%_Setup:=FAL_STATUS.OK;

END_FUNCTION

/*
* Ищет первое вхождение переменной модбас с заданным адресом, не проверяет дублирования
TODO реализовать бинарный поиск
 */
FUNCTION _%instance_name%_Find_VAR : REF_TO MODBUS_VAR_ELEM
    VAR_INPUT
        index: WORD; (* Номер регистра начала переменной. В середине не найдёт! *)
    END_VAR

    VAR 
        j: DINT;
        pelem: REF_TO MODBUS_VAR_ELEM;
        last_adr:WORD;
    END_VAR
    _%instance_name%_Find_VAR:=NULL;
    last_adr:=0;
    
    //TODO как только среда/живопырка будет поставлять адреса - можно делать бинарный поиск
    FOR j:=0 TO ({#num_of(%add_var_to_massiv_CE%)}-1) BY 1 DO
        pelem:=ADR(modbus_varsCEs%I%[j]);
        IF (pelem^.var_addr=index) THEN
            _%instance_name%_Find_VAR:=pelem;
            RETURN;
        END_IF
    END_FOR
END_FUNCTION


FUNCTION _%instance_name%_InitFal : FAL_STATUS
VAR_INPUT 
	inst_data: DWORD;
END_VAR
VAR_IN_OUT
	inst: FAL_HANDLE;
END_VAR
VAR
    ret:DINT:=-1;
END_VAR    
	assert ('Error! _%instance_name%_Setup() must be run at first!',%instance_name%_enter_if=ADR(_%instance_name%_enter_if));
    //init_task
	hsal_thread_constructor(ADR(%instance_name%_thread));
	%instance_name%_thread.attrs.priority:=_MODBUS_SLAVE_PRIORITY;
	%instance_name%_thread.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	ret := %instance_name%_thread.create^(ADR(%instance_name%_thread), %instance_name%_enter_if, ADR(%instance_name%_task));
	IF (ret < 0) THEN
		printf('Thread %instance_name% not started$N'); //%task_name%
        _%instance_name%_InitFal:=FAL_STATUS.ERROR_INIT;
        inst:=NULL;
    ELSE
        ret := %instance_name%_thread.runtime_set_name^(ADR(%instance_name%_thread), '%instance_name%');
        if (ret < 0) THEN
            printf('Thread error %d - not change name to %task_name%$N',ret); 
        END_IF
        inst:=%instance_name%_enter_if;
        _%instance_name%_InitFal:=FAL_STATUS.OK;
	END_IF
END_FUNCTION

FUNCTION _%instance_name%_DeInitFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
    %instance_name%_thread.stop_force^(ADR(%instance_name%_thread));
	printf('Thread %instance_name% stoped_destroy$N');//%task_name%
	_%instance_name%_DeInitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_CheckFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%instance_name%_CheckFal:=FAL_STATUS.OK;
END_FUNCTION



FUNCTION _%instance_name%_GetIface : REF_TO VOID
VAR_INPUT {ref}
	iface_name: STRING;
END_VAR	
	_%instance_name%_GetIface:=NULL;
END_FUNCTION

FUNCTION _%instance_name%_Get_status : FAL_STATUS
VAR_INPUT
	num: USIZE;
END_VAR	
	_%instance_name%_Get_status:=FAL_STATUS.OK;
END_FUNCTION


FUNCTION _%instance_name%_GetContext : REF_TO VOID
VAR_INPUT
	inst_data: DWORD; //Данные для идентификации экземпляра (для статических членов не используется)
END_VAR
	_%instance_name%_GetContext:=NULL;//ADR(_%instance_name%_data);
END_FUNCTION

//А вот тут реализация задачи ModBus
(*
В задаче последовательно по состояниям захватывается ресурс ABSI, происходить чтение/запись/обработка exeption
 *)
FUNCTION  %instance_name%_task : VOID
VAR_INPUT 
	args: REF_TO VOID; 
END_VAR
VAR
    last_symbol_time:LWORD; //MODBUS_SLAVE_RES_TIMEOUT
    last_packet_time:LWORD; //MODBUS_SLAVE_WATCHDOG
    buf_size:DWORD;
END_VAR    

VAR 
    inst: REF_TO FAL_HANDLE;
    absi_res:ABSI_STATUS;
    res: DINT;
    data:BYTE;
    req: ABSI_EXTENDED_SERVICES;
    i : DINT;
    control : STACK_CONTROL := (name:='%instance_name%_task');
END_VAR
    //puts('modbus task');
    inst:=args; //указатель на экземпляр интерфейса EnterIf - используется для получения номера экземпляра (на будущее)
    %instance_name%_STATUS := MODBUS_STATUS.NOT_INIT; 
    last_packet_time := hsal_gettime_ms();
    WHILE (TRUE) DO
        CONTROL_STACK(ADR(control));
        hsal_sleep_for_ms(_MODBUS_SLAVE_PERIOD_MS);
        //printf('mbst=%d ',%instance_name%_state);
        CASE %instance_name%_state OF
            MODBUS_SLAVE_STATES.NOT_INIT:
                IF %instance_name%_ENABLE THEN
                    //Захватываем порт
                    absi_res:={%SEC_ABSI_USE@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT);
                    IF absi_res= ABSI_STATUS.NO_DATA THEN
                        //puts('lock port');
                        %instance_name%_state:=MODBUS_SLAVE_STATES.LOCKED;
                    END_IF;
                ELSE 
                    %instance_name%_STATUS := MODBUS_STATUS.NOT_INIT;     
                END_IF
                
            MODBUS_SLAVE_STATES.LOCKED: //Ждем посылки
                //настраиваем SlaveID
                req.service := ABSI_SERVICES.SLAVE_ADR;
                req.address := %instance_name%_SlaveID;
                {%SEC_AXXI_SET_EXTENDED@Lchild[ ]%}(ADR(req));
                absi_res:={%SEC_ABSI_COPY_BYTE@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT,data);
                CASE absi_res OF
                    ABSI_STATUS.NOT_INIT, ABSI_STATUS.NOT_WORK, ABSI_STATUS.BUSY, ABSI_STATUS.RB_OVERFLOW, ABSI_STATUS.WB_OVERFLOW, ABSI_STATUS.ERROR_IN_DATA:   //Интерфейс не инициализирован
                   //puts('ZZ');
                    %instance_name%_state:=MODBUS_SLAVE_STATES.REINIT;
                    %instance_name%_STATUS := MODBUS_STATUS.ERROR; 

                    ABSI_STATUS.NO_DATA:       //Нет данных 
                    IF %instance_name%_watchdog<>0 THEN
                        IF (%instance_name%_watchdog+last_packet_time)<hsal_gettime_ms() THEN
                           //puts('wdt');
                            %instance_name%_STATUS := MODBUS_STATUS.WATCHDOG; //Это не ошибка, с сообщение о таймауте
                            INFORM_COMM_SOFT_WATCHDOG('%instance_name%');
                        END_IF
                    END_IF  

                    ABSI_STATUS.HAS_DATA:       //Есть входные данные
                   //puts('+');
                    //Проверяем SlaveID
                    %instance_name%_STATUS := MODBUS_STATUS.OK; //Watchdog error снимается только если приходит новая пачка вовремя
                    IF data=%instance_name%_SlaveID THEN
                       //puts('!');
                        %instance_name%_state:=MODBUS_SLAVE_STATES.RECEIVE;
                        buf_size:=0;
                        last_symbol_time:=hsal_gettime_ms();
                    ELSE
                        //не наш - очищаем буфер
                        //printf('SL=%d ',data);
                       //puts('CL1');
                        {%SEC_ABSI_CLEAR@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT);
                        //puts('^');
                    END_IF;
                ELSE
                   //puts('ZL1');
                    %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
                    %instance_name%_state:=MODBUS_SLAVE_STATES.REINIT;
                END_CASE;

            MODBUS_SLAVE_STATES.RECEIVE:
            //puts('re');
            //0. проверяем таймаут
            //1. Скачиваем побайтно до получения требуемого размера.
            //2. Проверяем CRC (не совпало - не отвечаем)
            //3. Ищем переменую 
            //4. Готовим ответ 

            absi_res:={%SEC_ABSI_GET_BYTE@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT,data);
            //printf('absi_res=%d$N',absi_res);
            WHILE (absi_res>= ABSI_STATUS.NO_DATA) DO
                CASE absi_res OF
                     ABSI_STATUS.NO_DATA:       //Нет данных 
                        IF (MODBUS_SLAVE_RES_TIMEOUT+last_symbol_time)<hsal_gettime_ms() THEN
                           //puts('ex3');
                            absi_res:= ABSI_STATUS.NOT_INIT; //Чтобы не заводить лишний флаг для прерывания цикла
                            %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
                            %instance_name%_state:= MODBUS_SLAVE_STATES.REINIT;
                            CONTINUE;
                        END_IF
                     ABSI_STATUS.HAS_DATA:       //Есть входные данные
                    //puts('o');
                    //printf('^%02x ',data);
                    _%instance_name%_buffer[buf_size]:=data;
                    buf_size:=buf_size+1;
                    last_symbol_time:=hsal_gettime_ms();
                    res:=GetExpectedMbusAmount(_%instance_name%_buffer,DINT#buf_size,FALSE);
                    IF res>0 THEN 
                        //printf('wait %d has %d $N',res,buf_size);
                        IF buf_size=res THEN //Разбираем пачку, ищем переменную, записываем, формируем ответ.
                            //puts('ok');
                            res:=%instance_name%_ProcMessage(_%instance_name%_buffer, _%instance_name%_send_buffer,buf_size);
                            //printf('res=%d $N',res);
                            IF (res>0) THEN
                                last_packet_time := hsal_gettime_ms(); //Пришёл правильный запрос (т.е. к нам и есть ответ (даже если он Exeption))
                            
                                %instance_name%_state:= MODBUS_SLAVE_STATES.SEND;
                                buf_size:=DWORD#res; //Безопасно, т.к. положительное
                                absi_res:= ABSI_STATUS.NOT_INIT; //Чтобы не заводить лишний флаг для прерывания цикла
                                CONTINUE;
                            ELSE
                               //puts('-');
                                %instance_name%_state:=MODBUS_SLAVE_STATES.LOCKED; 
                            END_IF
                            //очищаем буфер от возможного мусора
                           //puts('CL2');
                            {%SEC_ABSI_CLEAR@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT);
                            absi_res:= ABSI_STATUS.NO_DATA; //Чтобы не заводить лишний флаг для прерывания цикла
                            CONTINUE;
                        END_IF
                    ELSE 
                        IF (res<0)  THEN
                            //не наш - очищаем буфер
                           //puts('CL3');
                            {%SEC_ABSI_CLEAR@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT);
                            buf_size:=0;
                            absi_res:= ABSI_STATUS.NO_DATA; //Чтобы не заводить лишний флаг для прерывания цикла
                        END_IF;
                    END_IF;
                ELSE
                   //puts('ex2');
                    %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
                    %instance_name%_state:=MODBUS_SLAVE_STATES.REINIT;
                    absi_res:= ABSI_STATUS.NO_DATA; //Чтобы не заводить лишний флаг для прерывания цикла
                END_CASE;
                    absi_res:={%SEC_ABSI_GET_BYTE@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT,data);
                    //printf('absi_res2=%d$N',absi_res);
            END_WHILE

            IF (MODBUS_SLAVE_RES_TIMEOUT+last_symbol_time)<hsal_gettime_ms() THEN
               //puts('ex');
                %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
                %instance_name%_state:=MODBUS_SLAVE_STATES.REINIT;
                CONTINUE;
            END_IF

            MODBUS_SLAVE_STATES.SEND:
                //Удалось-не удалось, всё равно сделать ничего не можем
                //puts('|');
                //FOR i:=0 TO buf_size-1 DO
                //    //printf('%02x ',_%instance_name%_send_buffer[i]);
                //END_FOR;
                //puts('');
                //printf('Send %d bytes$N',buf_size);
                IF (%instance_name%_delay+last_symbol_time)>hsal_gettime_ms() THEN
                    //printf('d=%ld lst=%ld t=%ld$N',%instance_name%_delay,last_symbol_time,hsal_gettime_ms());
                    CONTINUE; //и пусть весь мир подождёт!
                END_IF
                //посылаем
                {%SEC_ABSI_SEND_BUFFER@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT,ADR(_%instance_name%_send_buffer[0]), buf_size);
                
                //Готовы к новым свершениям
                %instance_name%_state:=MODBUS_SLAVE_STATES.LOCKED;


            MODBUS_SLAVE_STATES.REINIT:
               //puts('z');
                {%SEC_ABSI_CLEAR@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT);
               //puts('Z');
                {%SEC_ABSI_RELEASE@Lchild[ ]%}(MODBUS_SLAVE_TIMEOUT);
               //puts('zz');
                buf_size:=0;
                
                %instance_name%_state:=MODBUS_SLAVE_STATES.NOT_INIT;

        ELSE
            %instance_name%_STATUS := MODBUS_STATUS.ERROR; 
            %instance_name%_state:=MODBUS_SLAVE_STATES.REINIT;
        END_CASE;
        
        //puts(',');
        
    END_WHILE;

   //puts('end modbus task %instance_name%');
END_FUNCTION

/*
 * @brief Parse incoming message and prepare answer
 */

FUNCTION %instance_name%_ProcMessage : DINT //возвращает размер ответа или -1 если ответа не будет

VAR_INPUT {ref}
    in_buf      : ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
    out_buf     : ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
END_VAR

VAR_INPUT
    in_size     : DWORD; 
END_VAR

VAR
    func        : BYTE;
    address     : WORD;
    qty_value   : DINT;
    byte_count  : BYTE;
    exeption    : MODBUS_ERROR_CODES := MODBUS_ERROR_CODES.ILLEGAL_FUNCTION;
END_VAR
    func:=in_buf[1];
    address:=WORD_SWAP_FROM_BYTES (in_buf[2],in_buf[3]);
    qty_value:=WORD_SWAP_FROM_BYTES (in_buf[4],in_buf[5]);
    byte_count:=in_buf[6];


    out_buf[0]:=in_buf[0]; //adress
    out_buf[1]:=func; //функция

    exeption := MODBUS_ERROR_CODES.SLAVE_DEVICE_FAILURE;
    //printf('address=%x func=%x qty_value=%d$N',address,func,qty_value);
    
    CASE func OF
        MODBUS_FUNCTION_CODES.READ_HOLDING_REGISTERS, MODBUS_FUNCTION_CODES.READ_INPUT_REGISTERS:
        IF (qty_value <= MODBUS_MAX_READ_REGISTERS) THEN // chk qty
            byte_count := BYTE#(qty_value * 2);
            qty_value := %instance_name%_ReadRegsInStorage(address, qty_value, 3,out_buf);
            //printf('readed=%x $N',qty_value);
            IF ( qty_value > 0) THEN
                out_buf[2]:=BYTE#qty_value;
                // revers
                SystemRev16Buffer(ADR(out_buf[0])+3, qty_value/2);
                %instance_name%_ProcMessage:=qty_value+3; 
            ELSE 
                IF(qty_value=-1) THEN
                    exeption := MODBUS_ERROR_CODES.ILLEGAL_DATA_ADDRESS;
                END_IF
                out_buf[1]:=out_buf[1] OR 16#80; //признак ошибки
                out_buf[2]:=BYTE#exeption;
                %instance_name%_ProcMessage:=3;
            END_IF
        ELSE
            out_buf[1]:=out_buf[1] OR 16#80; //признак ошибки
            out_buf[2]:=BYTE#exeption;  
            %instance_name%_ProcMessage:=3; 
        END_IF

        MODBUS_FUNCTION_CODES.WRITE_SINGLE_REGISTER:
            exeption := %instance_name%_WriteRegInStorage(address,  WORD#qty_value);
            IF ( qty_value > 0) THEN
                memcpy(ADR(out_buf[0]),ADR(in_buf[0]),6);
                %instance_name%_ProcMessage:=6; 
            ELSE 
                IF(qty_value=-1) THEN
                    exeption := MODBUS_ERROR_CODES.ILLEGAL_DATA_ADDRESS;
                END_IF
                out_buf[1]:=out_buf[1] OR 16#80; //признак ошибки
                out_buf[2]:=BYTE#exeption;
                %instance_name%_ProcMessage:=3;
            END_IF

        MODBUS_FUNCTION_CODES.WRITE_MULTIPLE_REGISTERS:
            //printf('address=%x func=%x qty_value=%d$N',address,func,qty_value);
            IF (qty_value <= MODBUS_MAX_READ_REGISTERS) THEN // chk qty
               //puts('W1');
                SystemRev16Buffer(ADR(in_buf[0])+7, qty_value);
                exeption := %instance_name%_WriteRegsInStorage(address, qty_value, 7, in_buf);
                 IF ( qty_value > 0) THEN
                    memcpy(ADR(out_buf[0]),ADR(in_buf[0]),6);
                    %instance_name%_ProcMessage:=6; 
                ELSE 
                    IF(qty_value=-1) THEN
                        exeption := MODBUS_ERROR_CODES.ILLEGAL_DATA_ADDRESS;
                    END_IF
                    out_buf[1]:=out_buf[1] OR 16#80; //признак ошибки
                    out_buf[2]:=BYTE#exeption;
                    %instance_name%_ProcMessage:=3;
                END_IF
            ELSE
                out_buf[1]:=out_buf[1] OR 16#80; //признак ошибки
                out_buf[2]:=BYTE#exeption;  
                %instance_name%_ProcMessage:=3; 
            END_IF
    ELSE
        
    END_CASE;


END_FUNCTION


FUNCTION %instance_name%_ReadRegsInStorage : DINT
VAR_INPUT
    addr: DINT; 
    count: DINT;
    offset: BYTE; //Смещение в буфере, c котогого надо писать данные (до этого будет лежать служебная информация)
END_VAR
VAR_IN_OUT
    buffer: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
END_VAR
VAR
    pelem: REF_TO MODBUS_VAR_ELEM;
    readed: BYTE:= 0;
    aligned_var_size: BYTE;
END_VAR
    //ищем переменную
    pelem:=_%instance_name%_Find_VAR(WORD#addr);

    count:=count*2; //В БАЙТАХ
    IF pelem<>NULL THEN //Нашли
        aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
        //printf('count=%d var_size=%d var_type=%d var_addr=%d p_addr=%lx$N',count, pelem^.var_size, pelem^.var_type,pelem^.var_addr, pelem^.p_adr);
        //printf(' p_addr=%lx$N', pelem^.p_adr);
        memset(ADR(buffer[offset]),16#00, MODBUS_MAX_PACKET_SIZE-offset);
        IF (count<aligned_var_size) THEN //Попытка частичного чтения 
            %instance_name%_ReadRegsInStorage:=-2;
            //puts('e1');
            RETURN; 
        END_IF
        IF (offset+aligned_var_size>=MODBUS_MAX_PACKET_SIZE) THEN //Попытка переполнения буфера
            %instance_name%_ReadRegsInStorage:=-2;
            //puts('e2');
            RETURN; 
        END_IF
        //Здравствуй, переменная!
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        CopyWithOrder(ADR(buffer[offset]),pelem^.p_adr, aligned_var_size, %instance_name%_byteorder);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));

        offset:=offset+aligned_var_size;
        count:=count-aligned_var_size;
        readed:=readed+aligned_var_size;
        addr:=addr+(aligned_var_size+1)/2;
    ELSE //Если не нашли начало блока переменных - выдаём ошибку
        %instance_name%_ReadRegsInStorage:=-1;
        RETURN;
    END_IF;
    //Далее возможны ещё переменные - пытаемся их найти и считать
   //printf('count=%d$N',count);
    WHILE count>0 DO
        pelem:=_%instance_name%_Find_VAR(WORD#addr);
        IF pelem<>NULL THEN //Нашли
            aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
            //printf('count=%d var_size=%d var_type=%d var_addr=%d p_addr=%lx$N',count, pelem^.var_size, pelem^.var_type,pelem^.var_addr, pelem^.p_adr);
            IF (count<aligned_var_size) THEN //Попытка частичного чтения 
               //puts('e3');
                %instance_name%_ReadRegsInStorage:=-2;
                RETURN; 
            END_IF
            IF (offset+aligned_var_size>=MODBUS_MAX_PACKET_SIZE) THEN //Попытка переполнения буфера
               //puts('e4');
                %instance_name%_ReadRegsInStorage:=-2;
                RETURN; 
            END_IF
            //Здравствуй, переменная!
            mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
            CopyWithOrder(ADR(buffer[offset]),pelem^.p_adr, aligned_var_size, %instance_name%_byteorder);
            mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));

            offset:=offset+aligned_var_size;
            count:=count-aligned_var_size;
            readed:=readed+aligned_var_size;
            addr:=addr+(aligned_var_size+1)/2;
        ELSE //Не нашли - заполняем 2 байта нулями и сдвигаем адрес и др. поля для поиска (режим работы с дыркой)
           memset(ADR(buffer[offset]),16#00,2);
           offset:=offset+2;
           count:=count-2;
           readed:=readed+2;
           addr:=addr+(2+1)/2;
        END_IF;
    END_WHILE;
    
    %instance_name%_ReadRegsInStorage:=readed;
END_FUNCTION



FUNCTION %instance_name%_WriteRegInStorage : DINT
VAR_INPUT
    addr: WORD; 
    value: WORD;
END_VAR

VAR
    pelem: REF_TO MODBUS_VAR_ELEM;
    aligned_var_size: DWORD;
END_VAR
//ищем переменную

    pelem:=_%instance_name%_Find_VAR(addr);
    IF pelem<>0 THEN //Нашли
        aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
        IF (2<>aligned_var_size) THEN //один регистр - это 2 байта!
            %instance_name%_WriteRegInStorage:=-2;
            RETURN; 
        END_IF
        
        //Здравствуй, переменная!
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        CopyWithOrder(pelem^.p_adr, ADR(value), 2, %instance_name%_byteorder);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        %instance_name%_WriteRegInStorage:=2;

    ELSE //Если не нашли начало блока переменных - выдаём ошибку
        %instance_name%_WriteRegInStorage:=-1;
    END_IF;

END_FUNCTION



FUNCTION %instance_name%_WriteRegsInStorage : DINT
VAR_INPUT
    addr: WORD; 
    count: DINT;
    offset: BYTE; //Смещение в буфере, c котогого лежат данные (до этого будет лежать служебная информация)
END_VAR
VAR_INPUT {ref}
    buffer: ARRAY [0 .. MODBUS_MAX_PACKET_SIZE] OF BYTE; 
END_VAR
VAR
    pelem: REF_TO MODBUS_VAR_ELEM;
    writed: DINT;
    aligned_var_size: BYTE;
END_VAR
 //ищем переменную
    //printf('addr=%d count=%d offset=%d $N',addr,count,offset);
    pelem:=_%instance_name%_Find_VAR(addr);
    count:=count*2; //В БАЙТАХ
    IF pelem<>0 THEN //Нашли
        aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
        //printf('aligned_var_size=%d$N',aligned_var_size);
        IF (count<aligned_var_size) THEN //Попытка частичной записи
            %instance_name%_WriteRegsInStorage:=-2;
           //puts('e3');
            RETURN; 
        END_IF
        IF (offset+aligned_var_size>=MODBUS_MAX_PACKET_SIZE) THEN //Попытка обратного переполнения буфера
            %instance_name%_WriteRegsInStorage:=-2;
           //puts('e4');
            RETURN; 
        END_IF
        //Здравствуй, переменная!
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        //printf('%lx %dbytes=[%d]$N',pelem^.p_adr,aligned_var_size,offset);
        CopyWithOrder(pelem^.p_adr, ADR(buffer[offset]), aligned_var_size, %instance_name%_byteorder);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));

        offset:=offset+aligned_var_size;
        count:=count-aligned_var_size;
        writed:=writed+aligned_var_size;
        addr:=addr+(aligned_var_size+1)/2;
    ELSE //Если не нашли начало блока переменных - выдаём ошибку
        %instance_name%_WriteRegsInStorage:=-1;
        RETURN;
    END_IF;
    //Далее возможны ещё переменные - пытаемся их найти и считать
    WHILE count>0 DO
        pelem:=_%instance_name%_Find_VAR(addr);
        IF pelem<>0 THEN //Нашли
            aligned_var_size:=BYTE#(ALIGN2(pelem^.var_size));
            IF (count<aligned_var_size) THEN //Попытка частичного чтения 
                %instance_name%_WriteRegsInStorage:=-2;
                RETURN; 
            END_IF
            IF (offset+aligned_var_size>=MODBUS_MAX_PACKET_SIZE) THEN //Попытка переполнения буфера
                %instance_name%_WriteRegsInStorage:=-3;
                RETURN; 
            END_IF
            //Здравствуй, переменная!
            mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
            CopyWithOrder(pelem^.p_adr, ADR(buffer[offset]), aligned_var_size, %instance_name%_byteorder);
            mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));

            offset:=offset+aligned_var_size;
            count:=count-aligned_var_size;
            writed:=writed+aligned_var_size;
            addr:=addr+(aligned_var_size+1)/2;
        ELSE //Не нашли - проскакиваем по 2 байта без записи в поиске переменных (режим работы с дыркой)
           offset:=offset+2;
           count:=count-2;
           writed:=writed+2;
           addr:=addr+(2+1)/2;
        END_IF;
    END_WHILE;
    %instance_name%_WriteRegsInStorage:=writed;
END_FUNCTION





FUNCTION %instance_name%_Read : VOID
VAR_INPUT
    index:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM;
END_VAR
    //проверка на диапазон
    IF ((index<MODBUS_SLAVE_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=modbus_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        memcpy(data,pelem^.p_adr,pelem^.var_size);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
    END_IF


END_FUNCTION


FUNCTION %instance_name%_Write: VOID

VAR_INPUT
    index:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM;
END_VAR
//проверка на диапазон
    IF ((index<MODBUS_SLAVE_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=modbus_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
        memcpy(pelem^.p_adr,data,pelem^.var_size);
        mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
    END_IF
   
END_FUNCTION

FUNCTION %instance_name%_Read_bit : VOID
VAR_INPUT
    index   :  WORD;
    bit     : BYTE;
    data    : REF_TO BOOL;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM;
    temp_DWORD  : DWORD; //Максимальный пока размер типа с битмаской
END_VAR
    //проверка на диапазон
    IF ((index<MODBUS_SLAVE_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=modbus_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        IF bit<(pelem^.var_size*8) THEN
            mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
            memcpy(ADR(temp_DWORD),pelem^.p_adr,pelem^.var_size);
            IF (temp_DWORD AND NOT (SHL(DWORD#1,bit)))<>0 THEN data^:=TRUE;
            ELSE data^:=FALSE;
            END_IF
            mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        END_IF
    END_IF
END_FUNCTION


FUNCTION %instance_name%_Write_bit: VOID

VAR_INPUT
    index   :  WORD;
    bit     : BYTE;
    data    : REF_TO BOOL;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM;
    temp_DWORD  : DWORD; //Максимальный пока размер типа с битмаской
END_VAR
//проверка на диапазон
    IF ((index<MODBUS_SLAVE_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=modbus_index_array%I%[index].p_elem;
    IF (pelem^.p_adr<>0) THEN
        IF bit<(pelem^.var_size*8) THEN
            mutex_%instance_name%.lock^(ADR(mutex_%instance_name%));
            memcpy(ADR(temp_DWORD),pelem^.p_adr,pelem^.var_size);
            temp_DWORD := temp_DWORD AND NOT (SHL(DWORD#1,DWORD#(data^)));
            memcpy(pelem^.p_adr,ADR(temp_DWORD),pelem^.var_size);
            mutex_%instance_name%.unlock^(ADR(mutex_%instance_name%));
        END_IF
    END_IF
   
END_FUNCTION




FUNCTION %instance_name%_ReadSubCh: VOID
VAR_INPUT
    index:  WORD;
    subindex:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM;
END_VAR
    IF ((index<MODBUS_SLAVE_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=modbus_index_array%I%[index].p_elem;
    case subindex of
	0: // address
	    //пока одновременного доступа не ожидается, как появится - добавим мютекс
		memcpy(data,ADR(pelem^.var_addr),sizeof(pelem^.p_adr));
	    
	ELSE
           printf('smth went wrong$N');
    end_case
END_FUNCTION

FUNCTION %instance_name%_WriteSubCh: VOID
VAR_INPUT
    index:  WORD;
    subindex:  WORD;
    data: REF_TO VOID;
END_VAR
VAR
    pelem:REF_TO MODBUS_VAR_ELEM;
END_VAR
    IF ((index<MODBUS_SLAVE_CHANNEL_COUNT.MAX) OR((index>({%num_var_ch< >%}MODBUS_SLAVE_CHANNEL_COUNT.MAX-1)))) THEN
        RETURN;
    END_IF
    pelem:=modbus_index_array%I%[index].p_elem;
    // TODO - may be need any lock or check access?
    case subindex of
	0: // address
	   //пока одновременного доступа не ожидается, как появится - добавим мютекс
		memcpy(ADR(pelem^.var_addr),data,sizeof(pelem^.p_adr));
 
	ELSE
           printf('smth went wrong$N');
    end_case
END_FUNCTION