
(*
ВАЖНО! Т.к. это многопоточный компонент, и состояние (state) его изменяются из 2-х задач - требуется оградить эти изменения в 
мютексы через набор функций  _GetState() и SetState()

Описание функционирования:
При запуске для каждого экземпляра запускается _%instance_name%_Setup()
в ней осуществляется общая инициализация структур и  создаётся задача опроса сокета

В задаче по состояниям:
 либо ничего не делается (TCP_SERVER_STATES.NOT_USED)
 либо ожидается входящее соединение (TCP_SERVER_STATES.LISTEN) и если есть - переходим в TCP_SERVER_STATES.ACCEPT

В состоянии ACCEPT 

 либо проверяется переодически живо ли соединение (TCP_SERVER_STATES.ACCEPT)
 либо при наборе событий (ошибка, прекращение использования, общий шатдаун системы) сокет освобождается и закрывается (TCP_SERVER_STATES.CLOSING) с переходом в TCP_SERVER_STATES.NOT_USED

Потребитель компонента вызывая функцию ABSI_USE_%instance_name%() завускает listen() и переводит компонент в состояние TCP_SERVER_STATES.ACCEPT
В функциях Get/Send если не в состоянии TCP_SERVER_STATES.ACCEPT - ничего не делаем, иначе выдаём/записываем данные из буфера сокета и обрабатываем ошибки, 
переводя состояние в TCP_SERVER_STATES.CLOSING
Если компонент не нужен - потребитель вызывает функцию ABSI_RELEASE_%instance_name%()

ABSI_RESET_%instance_name%() принудительно закрывает сокет и заново взводит его на чтение если состояние не TCP_SERVER_STATES.NOT_USED



 *)

VAR_GLOBAL
	_%instance_name%_data:TCP_SERVER_DATA;
	_%instance_name%_enter_if:FAL_ENTER_IF := (
		inst_data:=%I%,	
		GetContext:=ADR(_%instance_name%_GetContext) ,
		InitFal:=ADR(_%instance_name%_InitFal),
		DeInitFal:=ADR(_%instance_name%_DeInitFal),
		CheckFal:=ADR(_%instance_name%_CheckFal),
		GetIface:=ADR(_%instance_name%_GetIface)
	);
	%instance_name%_enter_if:REF_TO FAL_ENTER_IF;//:=ADR(_%instance_name%_enter_if);
	_%instance_name%_if:TCP_SERVER_IF:= (
		Get_status:=ADR(_%instance_name%_Get_status),
        Get_status:=ADR(_%instance_name%_Get_status),
	    Read_channel:=ADR(_%instance_name%_Read_channel),
	    Write_channel:=ADR(_%instance_name%_Write_channel)
	);
END_VAR

VAR_GLOBAL 
    //_%instance_name%_thread     : HSAL_Thread;
    //mutex_%instance_name%       : HSAL_Mutex;
    //SA_mutex_%instance_name%    : HSAL_Mutex;
END_VAR



FUNCTION _%instance_name%_Setup : FAL_STATUS

VAR
    I               : DINT;
END_VAR

    _%instance_name%_Setup:= FAL_STATUS.ERROR_INIT;   

    %instance_name%_enter_if:=ADR(_%instance_name%_enter_if);
    	// Инициализируем структуру для работы с сокетом 
    hsal_socket_constructor(ADR (_%instance_name%_data.sock));
    FOR I:=0 TO %max(3)%-1 DO
         hsal_socket_constructor(ADR(_%instance_name%_data.con_data[I].con_sock));
    END_FOR;
    //hsal_mutex_constructor(ADR(mutex_%instance_name%));
    //mutex_%instance_name%.init^(ADR(mutex_%instance_name%));
    //hsal_mutex_constructor(ADR(SA_mutex_%instance_name%));
    //SA_mutex_%instance_name%.init^(ADR(//SA_mutex_%instance_name%));

    
    _%instance_name%_Setup:= FAL_STATUS.OK;
END_FUNCTION







FUNCTION _%instance_name%_InitFal : FAL_STATUS
VAR_INPUT 
	inst_data: DWORD;
END_VAR
VAR_IN_OUT
	inst: FAL_HANDLE;
END_VAR
VAR 
    ret     :DINT:=-1;
END_VAR
	assert ('Error! _%instance_name%_Setup() must be run at first!',%instance_name%_enter_if=ADR(_%instance_name%_enter_if));
    //Задаём начальные значения из проекта
    _%instance_name%_data.port := %value(1)%;
    _%instance_name%_data.mask :=  %value(2)%;
    _%instance_name%_data.connection_limit :=  %value(3)%;
    _%instance_name%_data.enabled := %value(4)%;


    //Создаём задачу манипуляции с сокетом
    //hsal_thread_constructor(ADR(_%instance_name%_thread));
    //_%instance_name%_thread.attrs.stack_size:=65535;
    //_%instance_name%_thread.attrs.stack_addr := ADR(_%instance_name%_STACK);
    //_%instance_name%_thread.attrs.stack_addr := LALIGN4096 (_%instance_name%_thread.attrs.stack_addr);
	//_%instance_name%_thread.attrs.priority:=_TCP_SERVER_PRIORITY;
	//_%instance_name%_thread.attrs.sched_policy:=sch_policy.HSAL_SCHED_FIFO;
	//ret := _%instance_name%_thread.create^(ADR(_%instance_name%_thread), %instance_name%_enter_if, ADR(%instance_name%_task));
	//IF (ret < 0) THEN
	//	printf('Thread %instance_name% not started$N'); //%task_name%
    //    _%instance_name%_InitFal:= FAL_STATUS.ERROR_INIT;
   //     inst:=NULL;
   // ELSE
        inst:=%instance_name%_enter_if;
        _%instance_name%_InitFal:= FAL_STATUS.OK;
	//END_IF
    //printf ('stack at%lx[%d]$N',_%instance_name%_thread.attrs.stack_addr,_%instance_name%_thread.attrs.stack_size);
END_FUNCTION

FUNCTION _%instance_name%_DeInitFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
   
	_%instance_name%_DeInitFal:= FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_CheckFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%instance_name%_CheckFal:= FAL_STATUS.OK;
END_FUNCTION



FUNCTION _%instance_name%_GetIface : REF_TO VOID
VAR_INPUT {ref}
	iface_name: STRING;
END_VAR	
	IF ( STRING_EQUAL(TCP_SERVER_IF_NAME,iface_name)) THEN
		_%instance_name%_GetIface:=ADR(_%instance_name%_if);
	END_IF
	_%instance_name%_GetIface:=NULL;
END_FUNCTION

FUNCTION _%instance_name%_GetContext : REF_TO VOID
VAR_INPUT
	inst_data: DWORD; //Данные для идентификации экземпляра (для статических членов не используется)
END_VAR
	_%instance_name%_GetContext:=ADR(_%instance_name%_data);
END_FUNCTION

//интерфейс TCP_SERVER_IF
FUNCTION _%instance_name%_Get_status : FAL_STATUS
VAR_INPUT
	num: USIZE;
END_VAR	
	_%instance_name%_Get_status:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_Read_channel : WORD
VAR_INPUT 
	index: WORD;
END_VAR
	CASE 	index OF
		0: _%instance_name%_Read_channel:=WORD#(_%instance_name%_data.status);
		1: _%instance_name%_Read_channel:=_%instance_name%_data.port;
	ELSE
	END_CASE;
	
END_FUNCTION

FUNCTION _%instance_name%_Write_channel : TCP_ERROR_CODE
VAR_INPUT 
	index: WORD;
	val: WORD;
END_VAR
	CASE 	index OF
		0: 	_%instance_name%_Write_channel:=TCP_ERROR_CODE.ERROR; //Запись в выход запрещена
		1: 	_%instance_name%_data.port:=val; //TODO подумать надо ли переконектится автоматом
			_%instance_name%_Write_channel:=TCP_ERROR_CODE.OK;
	ELSE
        _%instance_name%_Write_channel:=TCP_ERROR_CODE.ERROR;
	END_CASE;
END_FUNCTION


FUNCTION _%instance_name%_IS_ENABLE: BOOL
    _%instance_name%_IS_ENABLE := _%instance_name%_data.enabled;
END_FUNCTION

FUNCTION _%instance_name%_ENABLE: VOID
VAR_INPUT
   en: BOOL;
END_VAR
    IF (_%instance_name%_data.enabled <> en) THEN
        _%instance_name%_data.enabled := en;
        IF en=FALSE THEN
            SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.RESETING);
        END_IF
    END_IF

END_FUNCTION


 

FUNCTION _%instance_name%_GET_PORT: WORD
    _%instance_name%_GET_PORT := _%instance_name%_data.port;
END_FUNCTION

FUNCTION _%instance_name%_SET_PORT: VOID
VAR_INPUT
   port: WORD;
END_VAR
    IF (_%instance_name%_data.port <> port) THEN
        _%instance_name%_data.port := port;
        SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.RESETING);
    END_IF
END_FUNCTION



FUNCTION _%instance_name%_GET_CONNECTIONS_LIMIT: WORD
    _%instance_name%_GET_CONNECTIONS_LIMIT := WORD#(_%instance_name%_data.connection_limit);
END_FUNCTION

FUNCTION _%instance_name%_SET_CONNECTIONS_LIMIT: VOID
VAR_INPUT
   connection_limit: WORD;
END_VAR
    IF (connection_limit <=  %max(3)%) THEN
        IF (_%instance_name%_data.connection_limit <> connection_limit) THEN
            _%instance_name%_data.connection_limit := connection_limit;
            SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.RESETING);
        END_IF
    END_IF
END_FUNCTION


FUNCTION _%instance_name%_GET_MASK: DWORD
    _%instance_name%_GET_MASK := _%instance_name%_data.mask;
END_FUNCTION

FUNCTION _%instance_name%_SET_MASK: VOID
VAR_INPUT
   mask: DWORD;
END_VAR
    IF (_%instance_name%_data.mask <> mask) THEN
        _%instance_name%_data.mask := mask;
        SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.RESETING);
    END_IF
END_FUNCTION

 



FUNCTION _%instance_name%_STATUS: ABSI_STATUS
    _%instance_name%_STATUS := _%instance_name%_data.status;
END_FUNCTION




//Функции, извлекающие данные из потока/интерфейса с их сбросом
FUNCTION ABSI_GET_BYTE_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR 
    VAR_IN_OUT
        data: BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:=ABSI_STATUS.NO_DATA;
        pconn_data      : REF_TO TCP_SERVER_CONNECTION;
    END_VAR
    TCP_SERVER_task(ADR(_%instance_name%_data));
    CASE GetState(ADR(_%instance_name%_data)) OF
            TCP_SERVER_STATES.NOT_USED:
                status:=ABSI_STATUS.NOT_INIT;        
            TCP_SERVER_STATES.WORK:
                //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
                pconn_data := _%instance_name%_data.pconn_data;
                //printf('01this^.pconn_data=%p$N',pconn_data);
                //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%));
                IF pconn_data = NULL THEN 
                    //puts('N4'); 
                    RETURN; 
                END_IF
                IF _%instance_name%_data.received > _%instance_name%_data.cur_pos THEN
                    data := _%instance_name%_data.full_buf[_%instance_name%_data.cur_pos];
                    _%instance_name%_data.cur_pos := _%instance_name%_data.cur_pos +1;
                    //printf('get 1 byte %02x$N',data);
                    status:=ABSI_STATUS.HAS_DATA;
                ELSE
                    status:=ABSI_STATUS.NO_DATA;
                END_IF;
    END_CASE
    _%instance_name%_data.status:=status;
    ABSI_GET_BYTE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_GET_BUFFER_%instance_name%: ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_IN_OUT
        data: REF_TO BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
        size: DWORD; //входное значение - максимальный размер  буфера, выходное - сколько пеерместили в него
    END_VAR
    VAR 
        res         : DINT;
        status      : ABSI_STATUS:=ABSI_STATUS.NO_DATA;
        pconn_data  : REF_TO TCP_SERVER_CONNECTION;
        len         : DINT; 
    END_VAR
    TCP_SERVER_task(ADR(_%instance_name%_data));
    CASE GetState(ADR(_%instance_name%_data)) OF
            TCP_SERVER_STATES.NOT_USED:
                status:=ABSI_STATUS.NOT_INIT;
            TCP_SERVER_STATES.WORK:
                //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
                 pconn_data := _%instance_name%_data.pconn_data;
                 //printf('02this^.pconn_data=%p$N',pconn_data);
                //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%));
                IF pconn_data = NULL THEN 
                    //puts('N5'); 
                    RETURN; 
                END_IF
                IF _%instance_name%_data.received > _%instance_name%_data.cur_pos THEN
                    len := MIN(DINT#size,(_%instance_name%_data.received-_%instance_name%_data.cur_pos));
                    memcpy(data,ADR(_%instance_name%_data.full_buf[_%instance_name%_data.cur_pos]),len);
                    size:=DWORD#len;
                    _%instance_name%_data.cur_pos := _%instance_name%_data.cur_pos + len;
                   //printf('get %d bytes$N',len);
                    status:=ABSI_STATUS.HAS_DATA;
                ELSE
                    status:=ABSI_STATUS.NO_DATA;
                END_IF;
    END_CASE

    _%instance_name%_data.status:=status;
    ABSI_GET_BUFFER_%instance_name%:=status;
END_FUNCTION

//Функции копирующие данные без сброса
FUNCTION ABSI_COPY_BYTE_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_IN_OUT
        data: BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:=ABSI_STATUS.NO_DATA;
        pconn_data      : REF_TO TCP_SERVER_CONNECTION;
    END_VAR
    //puts('v');
    TCP_SERVER_task(ADR(_%instance_name%_data));
    //puts('V');
    CASE GetState(ADR(_%instance_name%_data)) OF
        TCP_SERVER_STATES.NOT_USED:
            status:=ABSI_STATUS.NOT_INIT;
        TCP_SERVER_STATES.WORK:
            //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
            pconn_data := _%instance_name%_data.pconn_data;
            //printf('03this^.pconn_data=%p$N',pconn_data);
            //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%));
            IF pconn_data = NULL THEN 
                //puts('N6');
                RETURN; 
            END_IF
           //printf('p=%lx',pconn_data);
           //printf('received=%d cur_pos=%d$N',_%instance_name%_data.received, _%instance_name%_data.cur_pos);
            IF _%instance_name%_data.received > _%instance_name%_data.cur_pos THEN
                data := _%instance_name%_data.full_buf[_%instance_name%_data.cur_pos];
               //printf('copy 1 byte %02x$N',data);
                status:=ABSI_STATUS.HAS_DATA;
            ELSE
                status:=ABSI_STATUS.NO_DATA;
            END_IF;
    END_CASE

    _%instance_name%_data.status:=status;
    ABSI_COPY_BYTE_%instance_name%:=status;
    //puts('vv');
END_FUNCTION

FUNCTION ABSI_COPY_BUFFER_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_IN_OUT
        data                : REF_TO BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
        size                : DWORD; //входное значение - максимальный размер  буфера, выходное - сколько пеерместили в него
    END_VAR
    VAR 
        res                 : DINT;
        status: ABSI_STATUS := ABSI_STATUS.NO_DATA;
        pconn_data          : REF_TO TCP_SERVER_CONNECTION;
        len                 : DINT;
    END_VAR
    TCP_SERVER_task(ADR(_%instance_name%_data));
    CASE GetState(ADR(_%instance_name%_data)) OF
        TCP_SERVER_STATES.NOT_USED:
            status:=ABSI_STATUS.NOT_INIT;        
        TCP_SERVER_STATES.WORK:
            //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
            pconn_data := _%instance_name%_data.pconn_data;
            //printf('04this^.pconn_data=%p$N',pconn_data);
            //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%));
            IF pconn_data = NULL THEN 
                //puts('N7'); 
                RETURN; 
            END_IF

            IF _%instance_name%_data.received > _%instance_name%_data.cur_pos THEN

                len := MIN(DINT#size,(_%instance_name%_data.received-_%instance_name%_data.cur_pos));
                memcpy(data,ADR(_%instance_name%_data.full_buf[_%instance_name%_data.cur_pos]),len);
                size:=DWORD#len;
                //printf('copy %d bytes$N',res);
                status:=ABSI_STATUS.HAS_DATA;
            ELSE
                status:=ABSI_STATUS.NO_DATA;
            END_IF; 
    END_CASE
    _%instance_name%_data.status:=status;
    ABSI_COPY_BUFFER_%instance_name%:=status;
END_FUNCTION

//Функции записи в интерфейс
FUNCTION ABSI_SEND_BYTE_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_INPUT
        data: BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
    END_VAR
    
    _%instance_name%_data.status:=status;
    ABSI_SEND_BYTE_%instance_name%:=status;
    //В TCP такое не реализовано
END_FUNCTION

FUNCTION ABSI_SEND_BUFFER_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
        data: REF_TO BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR_IN_OUT
        size: DWORD; //входное значение -сколько послать, выходное - сколько удалось послать/поместить в очереь передачи
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
        pconn_data      : REF_TO TCP_SERVER_CONNECTION;
    END_VAR
    TCP_SERVER_task(ADR(_%instance_name%_data));
    //printf('SB state=%d$N',GetState(ADR(_%instance_name%_data)));
    CASE GetState(ADR(_%instance_name%_data)) OF
        TCP_SERVER_STATES.WORK:
            //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
            pconn_data := _%instance_name%_data.pconn_data;
            //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%));
            IF pconn_data = NULL THEN 
                //puts('N1');
                RETURN; 
            END_IF
            //puts('U');
            //printf('p=%lx ',pconn_data);
            //printf('send %d bytes$N',size);
            IF (size>MODBUS_MAX_PACKET_SIZE) THEN
                status:=ABSI_STATUS.ERROR_IN_DATA;
                _%instance_name%_data.status:=status;
                ABSI_SEND_BUFFER_%instance_name%:=status;
                RETURN;
            END_IF;
            _%instance_name%_data.full_buf[5] := BYTE#size;
            memcpy(ADR(_%instance_name%_data.full_buf)+6, data, size);
            _%instance_name%_data.need_to_send := DINT#(size + 6);
            SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.SEND); 
            status:= ABSI_STATUS.HAS_DATA;
            TCP_SERVER_task(ADR(_%instance_name%_data));
    END_CASE

    _%instance_name%_data.status:=status;
    ABSI_SEND_BUFFER_%instance_name%:=status;
END_FUNCTION

//Функции контроля
FUNCTION ABSI_USE_%instance_name% : ABSI_STATUS //Захватывает интерфейс - 
//для многопользовательских блокирует его на посл. открытие до вызова CLOSE, остальные функции становятся доступными только захватившему
//для однопользовательских (например сокет/файл) - открывает/закрывает или соединяется/разъединяется
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
	VAR
		ret:DINT;
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
        counter : DINT;
    END_VAR
   //puts('use');
    SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.CREATED);
    TCP_SERVER_task(ADR(_%instance_name%_data));
    status:=ABSI_STATUS.NO_DATA;

    _%instance_name%_data.status:=status;
    ABSI_USE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_RELEASE_%instance_name% : ABSI_STATUS //Освобождает интерфейс - 
//для многопользовательских освобождает ресурс
//для однопользовательских (например сокет/файл) - открывает/закрывает или соединяется/разъединяется
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
        counter : DINT;
    END_VAR
   //puts('rel');
    SetState(ADR(_%instance_name%_data),  TCP_SERVER_STATES.CLOSING);
    TCP_SERVER_task(ADR(_%instance_name%_data));
    WHILE GetState(ADR(_%instance_name%_data))<>TCP_SERVER_STATES.NOT_USED DO
        IF counter > 10 THEN
            RETURN;
        ELSE
            counter := counter + 1;
        END_IF;
       //puts('R');
        TCP_SERVER_task(ADR(_%instance_name%_data));
        hsal_sleep_for_ms(_TCP_SERVER_PERIOD_MS);
    END_WHILE;
    
    _%instance_name%_data.status:=status;
    ABSI_RELEASE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_CLEAR_%instance_name% : ABSI_STATUS //ОЧищает все буфера
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR 
        res: DINT;
        buffer: ARRAY [0..255] OF BYTE;
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
        pconn_data      : REF_TO TCP_SERVER_CONNECTION;
    END_VAR
 
    CASE GetState(ADR(_%instance_name%_data)) OF
        TCP_SERVER_STATES.WORK:
            //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
            pconn_data := _%instance_name%_data.pconn_data;
            //printf('06this^.pconn_data=%p$N',pconn_data);
            //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%));
            IF pconn_data = NULL THEN 
                //puts('N8'); 
                RETURN; 
            END_IF
            
            //SA_mutex_%instance_name%.lock^(ADR(//SA_mutex_%instance_name%));
            res := 1;
            WHILE res>0 DO
                res:=pconn_data^.con_sock.recv^(ADR(pconn_data^.con_sock), ADR(_%instance_name%_data.full_buf), 256, HSAL_Socket_SR_Flags.DONTWAIT);
            END_WHILE
            //SA_mutex_.unlock^(ADR(//SA_mutex_));
            _%instance_name%_data.received := 0;
            _%instance_name%_data.cur_pos := DINT#(sizeof(_%instance_name%_data.full_buf)-1);
            //SA_mutex_%instance_name%.unlock^(ADR(//SA_mutex_%instance_name%)); 
            SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.CHECK_PACKET); 
            
            //TCP_SERVER_task(ADR(_%instance_name%_data));
           //puts('_cl');

            ABSI_CLEAR_%instance_name%:= ABSI_STATUS.NO_DATA;
    END_CASE

    _%instance_name%_data.status:=status;
    ABSI_CLEAR_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_CLEAR_RB_%instance_name% : ABSI_STATUS //ОЧищает буфера приёма
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
    END_VAR

    status:= ABSI_CLEAR_%instance_name% (timeout);

    _%instance_name%_data.status:=status;
    ABSI_CLEAR_RB_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_CLEAR_WB_%instance_name% : ABSI_STATUS //ОЧищает буфера передачи
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        status: ABSI_STATUS:=ABSI_STATUS.NOT_INIT;
    END_VAR

    CASE GetState(ADR(_%instance_name%_data)) OF
        TCP_SERVER_STATES.WORK:
            status:=ABSI_STATUS.NO_DATA;
    END_CASE

    _%instance_name%_data.status:=status;
    ABSI_CLEAR_WB_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_RESET_%instance_name% : ABSI_STATUS //Сбрасывает/переинициализирует интерфейс - реализация на аппаратном/драйверном уровне зависит от типа интерфейса
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        status: ABSI_STATUS:=ABSI_STATUS.NO_DATA;
    END_VAR

    CASE GetState(ADR(_%instance_name%_data)) OF
        TCP_SERVER_STATES.NOT_USED:
            status:=ABSI_STATUS.NOT_INIT;
     ELSE
        SetState(ADR(_%instance_name%_data), TCP_SERVER_STATES.RESETING);
        WHILE GetState(ADR(_%instance_name%_data))<>TCP_SERVER_STATES.CREATED DO
            hsal_sleep_for_ms(_TCP_SERVER_PERIOD_MS);
        END_WHILE;
     END_CASE

    _%instance_name%_data.status:=status;
    ABSI_RESET_%instance_name%:=status;
END_FUNCTION


FUNCTION AXXI_SET_EXTENDED_%instance_name% : ABSI_STATUS //передаёт в интерфейс расширенные настройки
    VAR_INPUT
        preq: REF_TO AXXI_EXTENDED_SERVICES;
    END_VAR
    AXXI_SET_EXTENDED_%instance_name%:= ABSI_STATUS.EXT_SER_NOT_SUPP;
END_FUNCTION


FUNCTION AXXI_GET_EXTENDED_%instance_name% : ABSI_STATUS //считывает из интерфейса расширенные настройки
	VAR_IN_OUT
		req: AXXI_EXTENDED_SERVICES;
	END_VAR
   AXXI_GET_EXTENDED_%instance_name%:= ABSI_STATUS.EXT_SER_NOT_SUPP;
END_FUNCTION