
(*
ВАЖНО! Т.к. это многопоточный компонент, и состояние (state) его изменяются из 2-х задач - требуется оградить эти изменения в 
мютексы через набор функций  _%instance_name%_GetState() и _%instance_name%_SetState()

Описание функционирования:
При запуске для каждого экземпляра запускается _%instance_name%_Setup()
в ней осуществляется общая инициализация структур

Компонент создан для использования группой экземпляров одного типа (UARTх) разными потребителями.
Компонент работает как slave для Modbus и  поддерживает автодетектирование протоколов ASCII/RTU
Компонент может определить ликвидность(законченность) посылки по SlaveID + либо по коду функции (среди известных) либо по совпадению CRC (для неизвестных функций)
Предполагается что все функции интерфейса ABSI будут вызваны в одном потоке (т.е. не может быть ситуации что 2 функции одновременно будут вызваны из одного потока)
У компонента нет своей задачи, он работает при вызове извне его функций
Компонент имеет состояния:

	UART_SLAVE_STATES.NOT_USED		:= 0,
	UART_SLAVE_STATES.CREATED			:= 1,
	UART_SLAVE_STATES.WAIT_PACKET		:= 2, //Ждём первого байта, либо символ ASCII ':' либо SlaveID
	UART_SLAVE_STATES.DETECT_PROTOCOL := 3, //Определяем по 3-м байтам тип протокола и наша ли пачка
	UART_SLAVE_STATES.CHECK_PACKET	:= 4, //Собираем байты до достижения всей посылки или состояния "посылка неликвидна"
	UART_SLAVE_STATES.READY_PACKET	:= 5, //Посылка готова но не отдана
	UART_SLAVE_STATES.WORK  			:= 6, //Посылка отдана, ждём ответ
	UART_SLAVE_STATES.RESETING		:= 7, //Сброс буферов при обнаружении ошибки
	UART_SLAVE_STATES.IN_ERROR 		:= -1



Потребитель компонента вызывая функцию ABSI_USE_%instance_name%() лочит компонент на себя 
Если компонент не нужен - потребитель вызывает функцию ABSI_RELEASE_%instance_name%()
ABSI_RESET_%instance_name%() принудительно закрывает порт и переоткрывает его с текущими настройками



 *)

VAR_GLOBAL
	%instance_name%_data       : REF_TO UART_SLAVE_DATA;
	_%instance_name%_enter_if   : FAL_ENTER_IF := (
		inst_data:=%NN%,	
		GetContext:=ADR(_%instance_name%_GetContext) ,
		InitFal:=ADR(_%instance_name%_InitFal),
		DeInitFal:=ADR(_%instance_name%_DeInitFal),
		CheckFal:=ADR(_%instance_name%_CheckFal),
		GetIface:=ADR(_%instance_name%_GetIface)
	);
	%instance_name%_enter_if:REF_TO FAL_ENTER_IF;//:=ADR(_%instance_name%_enter_if);
	_%instance_name%_if:UART_SLAVE_IF:= (
		Get_status:=ADR(_%instance_name%_Get_status),
	    Read_channel:=ADR(_%instance_name%_Read_channel),
	    Write_channel:=ADR(_%instance_name%_Write_channel)
	);
    %instance_name%_mutex    : HSAL_Mutex;
END_VAR




FUNCTION _%instance_name%_Setup : FAL_STATUS

    _%instance_name%_Setup      := FAL_STATUS.ERROR_INIT;   
    %instance_name%_enter_if    := ADR(_%instance_name%_enter_if);
    %instance_name%_data        :=  ADR(hsal_serial_handle[%UART_PORT_NUMBER%]);
    %instance_name%_data^.state := UART_SLAVE_STATES.CREATED;
    %instance_name%_data^.status :=  ABSI_STATUS.NOT_INIT;

    hsal_mutex_constructor(ADR( %instance_name%_mutex));
     %instance_name%_mutex.init^(ADR( %instance_name%_mutex));
    _%instance_name%_Setup:= FAL_STATUS.OK;
    
    _%instance_name%_Setup      := FAL_STATUS.OK;
END_FUNCTION


FUNCTION _%instance_name%_GetState : TCP_SERVER_STATES
     %instance_name%_mutex.lock^(ADR( %instance_name%_mutex));
    _%instance_name%_GetState:= %instance_name%_data^.state; 
     %instance_name%_mutex.unlock^(ADR( %instance_name%_mutex));
END_FUNCTION

FUNCTION _%instance_name%_SetState : TCP_SERVER_STATES

VAR_INPUT
    state               : TCP_SERVER_STATES;
END_VAR

     %instance_name%_mutex.lock^(ADR( %instance_name%_mutex));
    _%instance_name%_SetState:= %instance_name%_data^.state; 
    %instance_name%_data^.state := state;
     %instance_name%_mutex.unlock^(ADR( %instance_name%_mutex));
END_FUNCTION


FUNCTION _%instance_name%_InitFal : FAL_STATUS
VAR_INPUT 
	inst_data: DWORD;
END_VAR
VAR_IN_OUT
	inst    : FAL_HANDLE;
END_VAR
VAR 
    ret     : DINT:=0;
    pf : REF_TO VOID;
END_VAR
	assert ('Error! _%instance_name%_Setup() must be run at first!',%instance_name%_enter_if=ADR(_%instance_name%_enter_if));
    //готовим мютекс
    hsal_mutex_constructor(ADR(%instance_name%_mutex));
    %instance_name%_mutex.init^(ADR(%instance_name%_mutex));

    //Задаём начальные значения из проекта
    %instance_name%_data^.Bodrate    := Pass_par_value_DINT(%instance_name%_data^.Bodrate,%value(1)%,300,921600);
    %instance_name%_data^.Parity     := Pass_par_value_DINT(%instance_name%_data^.Parity, %value(2)%,0,2);
    %instance_name%_data^.Stopbit    := Pass_par_value_DINT(%instance_name%_data^.Stopbit,%value(3)%,1,3);
    %instance_name%_data^.Bitsize    := Pass_par_value_DINT(%instance_name%_data^.Bitsize,%value(4)%,5,8);
    %instance_name%_data^.enabled    := TRUE;


   
    inst:= %instance_name%_enter_if;


    printf('get UART%UART_PORT_NUMBER% ');
    %instance_name%_data^.pport:= hsal_serial_get(hsal_serial_ports_e.PORT_%UART_PORT_NUMBER%); 
    //printf('.pport=%p$N',%instance_name%_data^.pport);
    IF %instance_name%_data^.pport<>0 THEN
        puts('ok');
    ELSE
        _%instance_name%_InitFal := FAL_STATUS.ERROR_INIT;
        puts('failed');
        RETURN;
    END_IF

    IF %instance_name%_data^.pport^.is_open^(%instance_name%_data^.pport) = FALSE THEN //Первый - открываем (без настроек, они в USE!)
        printf('open UART%UART_PORT_NUMBER%');
        ret := %instance_name%_data^.pport^.open^(%instance_name%_data^.pport, hsal_serial_ports_e.PORT_%UART_PORT_NUMBER%);
        IF ret <> 0 THEN //Упс
            printf(' failed with %d code$N',ret);
             _%instance_name%_InitFal:=FAL_STATUS.ERROR_INIT;
             %instance_name%_data^.state := UART_SLAVE_STATES.IN_ERROR;
             RETURN;
        ELSE 
            puts('OK'); 
        END_IF
   END_IF;
     
    _%instance_name%_InitFal:=FAL_STATUS.OK;
    %instance_name%_data^.state := UART_SLAVE_STATES.CREATED;
END_FUNCTION

FUNCTION _%instance_name%_DeInitFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
   
	_%instance_name%_DeInitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_CheckFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%instance_name%_CheckFal:=FAL_STATUS.OK;
END_FUNCTION



FUNCTION _%instance_name%_GetIface : REF_TO VOID
VAR_INPUT {ref}
	iface_name: STRING;
END_VAR	
	IF ( STRING_EQUAL(UART_SLAVE_IF_NAME,iface_name)) THEN
		_%instance_name%_GetIface:=ADR(_%instance_name%_if);
	END_IF
	_%instance_name%_GetIface:=NULL;
END_FUNCTION

FUNCTION _%instance_name%_GetContext : REF_TO VOID
VAR_INPUT
	inst_data: DWORD; //Данные для идентификации экземпляра (для статических членов не используется)
END_VAR
	_%instance_name%_GetContext:=ADR(%instance_name%_data);
END_FUNCTION

//интерфейс UART_SLAVE_IF
FUNCTION _%instance_name%_Get_status : FAL_STATUS
VAR_INPUT
	num: USIZE;
END_VAR	
	_%instance_name%_Get_status:= FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%instance_name%_Read_channel : DINT
VAR_INPUT 
	index: WORD;
END_VAR
	CASE 	index OF
		0: _%instance_name%_Read_channel:=%instance_name%_data^.status;
		1: _%instance_name%_Read_channel:=%instance_name%_data^.Bodrate;
        2: _%instance_name%_Read_channel:=%instance_name%_data^.Parity;
        3: _%instance_name%_Read_channel:=%instance_name%_data^.Stopbit;
        4: _%instance_name%_Read_channel:=%instance_name%_data^.Bitsize;
	ELSE
        _%instance_name%_Read_channel:=-1; //По идее этого быть не должно TODO сделать обработку ошибок
	END_CASE;
	
END_FUNCTION

FUNCTION _%instance_name%_Write_channel : ERROR_CODE
VAR_INPUT 
	index: WORD;
	val: DINT;
END_VAR
    _%instance_name%_Write_channel:=ERROR_CODE.NO_ERROR;
    //TODO продумать проверку min/max
	CASE 	index OF
		0: 	_%instance_name%_Write_channel:=ERROR_CODE.ERR_INVALID_PARAMETER; //Запись в выход запрещена
		1: 	%instance_name%_data^.Bodrate:=Pass_par_value_DINT(%instance_name%_data^.Bodrate,val,UART_BODRATES.BODRATE_300,UART_BODRATES.BODRATE_921600); //TODO подумать надо ли сразу менять настройки или дождаться переподключения
        2: 	%instance_name%_data^.Parity :=Pass_par_value_DINT(%instance_name%_data^.Parity ,val,UART_PARITIES.PARITY_NONE,UART_PARITIES.PARITY_EVEN);
        3: 	%instance_name%_data^.Stopbit:=Pass_par_value_DINT(%instance_name%_data^.Stopbit,val,UART_STOPBITS.STOPBIT_ONE,UART_STOPBITS.STOPBIT_TWO);
        4: 	%instance_name%_data^.Bitsize:=Pass_par_value_DINT(%instance_name%_data^.Bitsize,val,UART_BITSIZES.BITSIZE_5,UART_BITSIZES.BITSIZE_9); 
	ELSE
        _%instance_name%_Write_channel:=ERROR_CODE.ERR_INVALID_PARAMETER;
	END_CASE;
END_FUNCTION



FUNCTION _%instance_name%_IS_ENABLE: BOOL
    _%instance_name%_IS_ENABLE := %instance_name%_data^.enabled;
END_FUNCTION

FUNCTION _%instance_name%_ENABLE: VOID
VAR_INPUT
   en: BOOL;
END_VAR
    %instance_name%_data^.enabled := en;

END_FUNCTION


 

FUNCTION _%instance_name%_GET_BODRATE: UART_BODRATES
    _%instance_name%_GET_BODRATE := _%instance_name%_Read_channel(1);

END_FUNCTION

FUNCTION _%instance_name%_SET_BODRATE: ERROR_CODE
VAR_INPUT
   BODRATE: UART_BODRATES;
END_VAR
    _%instance_name%_SET_BODRATE := _%instance_name%_Write_channel(1,DINT#BODRATE);
END_FUNCTION

 
FUNCTION _%instance_name%_GET_PARITY: UART_PARITIES
    _%instance_name%_GET_PARITY := _%instance_name%_Read_channel(2);
END_FUNCTION

FUNCTION _%instance_name%_SET_PARITY: ERROR_CODE
VAR_INPUT
   PARITY: UART_PARITIES;
END_VAR
    _%instance_name%_SET_PARITY := _%instance_name%_Write_channel(2,DINT#PARITY);

END_FUNCTION


FUNCTION _%instance_name%_GET_STOPBITS: UART_STOPBITS
    _%instance_name%_GET_STOPBITS := _%instance_name%_Read_channel(3);
END_FUNCTION

FUNCTION _%instance_name%_SET_STOPBITS: ERROR_CODE
VAR_INPUT
   STOPBIT : UART_STOPBITS;
END_VAR
    _%instance_name%_SET_STOPBITS := _%instance_name%_Write_channel(3,DINT#STOPBIT);

END_FUNCTION

FUNCTION _%instance_name%_GET_BITSIZE: UART_BITSIZES
    _%instance_name%_GET_BITSIZE := _%instance_name%_Read_channel(4);
END_FUNCTION

FUNCTION _%instance_name%_SET_BITSIZE: ERROR_CODE
VAR_INPUT
   BITSIZE: UART_BITSIZES;
END_VAR
    _%instance_name%_SET_BITSIZE := _%instance_name%_Write_channel(4,DINT#BITSIZE);

END_FUNCTION



FUNCTION _%instance_name%_STATUS: ABSI_STATUS
    _%instance_name%_STATUS := %instance_name%_data^.status;
END_FUNCTION


	
 


//Функции, извлекающие данные из потока/интерфейса с их сбросом
FUNCTION ABSI_GET_BYTE_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR 
    VAR_IN_OUT
        data: BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:= ABSI_STATUS.NO_DATA;
    END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_GET_BYTE_%instance_name%:=status;

		RETURN;
    END_IF

    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_GET_BYTE_%instance_name%:=status;
		RETURN;
    END_IF
    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_GET_BYTE_%instance_name%:=status;
        RETURN;
    END_IF
    //printf('get st=%d$N',%instance_name%_data^.state);
   // IF %instance_name%_data^.state > UART_SLAVE_STATES.NOT_USED AND %instance_name%_data^.state <= UART_SLAVE_STATES.READY_PACKET THEN
    status:=UART_SLAVE_STATE_MASHINE(%instance_name%_data); 
    IF status= ABSI_STATUS.HAS_DATA THEN
        IF (%instance_name%_data^.buf_pos<%instance_name%_data^.count) THEN
            data:=%instance_name%_data^.buf[%instance_name%_data^.buf_pos];
            %instance_name%_data^.buf_pos:=%instance_name%_data^.buf_pos+1;
        ELSE //Ошибка реализации/вызова
            //puts('no 0');
            status:= ABSI_STATUS.NO_DATA;  
            %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;  
        END_IF
        //printf('pos=%d size=%d$N',%instance_name%_data^.buf_pos,%instance_name%_data^.count);
        IF (%instance_name%_data^.buf_pos>=%instance_name%_data^.count) THEN 
            %instance_name%_data^.state:=UART_SLAVE_STATES.WORK;
        END_IF
    END_IF
    //ELSE
    //    puts('G4'); 
    //    hsal_sleep_for_ms(100);
    //    status:= ABSI_STATUS.NO_DATA;  
    //    %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;        
    //END_IF

    %instance_name%_data^.status:=status;
    ABSI_GET_BYTE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_GET_BUFFER_%instance_name%: ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_IN_OUT
        data: REF_TO BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
        size: DWORD; //входное значение - максимальный размер  буфера, выходное - сколько пеерместили в него
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:= ABSI_STATUS.NO_DATA;
    END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_GET_BUFFER_%instance_name%:=status;

		RETURN;
    END_IF

    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_GET_BUFFER_%instance_name%:=status;
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_GET_BUFFER_%instance_name%:=status;
        RETURN;
    END_IF

    //IF %instance_name%_data^.state > UART_SLAVE_STATES.NOT_USED AND %instance_name%_data^.state <= UART_SLAVE_STATES.READY_PACKET THEN
            status:=UART_SLAVE_STATE_MASHINE(%instance_name%_data); 
            IF status= ABSI_STATUS.HAS_DATA THEN
                IF (%instance_name%_data^.buf_pos<%instance_name%_data^.count) THEN
                    res := MIN (%instance_name%_data^.count-%instance_name%_data^.buf_pos,size);
                    memcpy (data,ADR(%instance_name%_data^.buf[%instance_name%_data^.buf_pos]),res);
                    %instance_name%_data^.buf_pos:=%instance_name%_data^.buf_pos+res;
                    size := res;
                ELSE //Ошибка реализации/вызова
                    puts('no 1');
                    status:= ABSI_STATUS.NO_DATA;  
                    %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;  
                END_IF
                //printf('pos=%d size=%d$N',%instance_name%_data^.buf_pos,%instance_name%_data^.count);
                IF (%instance_name%_data^.buf_pos>=%instance_name%_data^.count) THEN 
                    %instance_name%_data^.state:=UART_SLAVE_STATES.WORK;
                END_IF
            END_IF
    //ELSE
    //    puts('G6'); 
    //    hsal_sleep_for_ms(100);
    //    status:= ABSI_STATUS.NO_DATA;  
    //    %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;        
    //END_IF

    %instance_name%_data^.status:=status;
    ABSI_GET_BUFFER_%instance_name%:=status;
END_FUNCTION

//Функции копирующие данные без сброса
FUNCTION ABSI_COPY_BYTE_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_IN_OUT
        data: BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:= ABSI_STATUS.NO_DATA;
    END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_COPY_BYTE_%instance_name%:=status;

		RETURN;
    END_IF
    //printf('copy lock=%d$N',%instance_name%_data^.lock_inst);
    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_COPY_BYTE_%instance_name%:=status;
        puts('U1');
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_COPY_BYTE_%instance_name%:=status;
        puts('U2');
        RETURN;
    END_IF
    //printf('state on copy=%d$N', %instance_name%_data^.state);
    //IF %instance_name%_data^.state > UART_SLAVE_STATES.NOT_USED AND %instance_name%_data^.state <= UART_SLAVE_STATES.READY_PACKET THEN
        status:=UART_SLAVE_STATE_MASHINE(%instance_name%_data); 
        IF status= ABSI_STATUS.HAS_DATA THEN
            IF (%instance_name%_data^.buf_pos<%instance_name%_data^.count) THEN
                data:=%instance_name%_data^.buf[%instance_name%_data^.buf_pos];
                //puts('U+');
            ELSE //Ошибка реализации/вызова
                puts('no 2');
                status:= ABSI_STATUS.NO_DATA;  
                %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;  
            END_IF
        END_IF
    //ELSE
    //    puts('C4'); 
    //    status:= ABSI_STATUS.NO_DATA;  
    //    %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;        
    //END_IF
    %instance_name%_data^.status:=status;
    ABSI_COPY_BYTE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_COPY_BUFFER_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_IN_OUT
        data: REF_TO BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
        size: DWORD; //входное значение - максимальный размер  буфера, выходное - сколько пеерместили в него
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:= ABSI_STATUS.NO_DATA;
    END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_COPY_BUFFER_%instance_name%:=status;

		RETURN;
    END_IF
  
    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_COPY_BUFFER_%instance_name%:=status;
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_COPY_BUFFER_%instance_name%:=status;
        RETURN;
    END_IF

    //IF %instance_name%_data^.state > UART_SLAVE_STATES.NOT_USED AND %instance_name%_data^.state <= UART_SLAVE_STATES.READY_PACKET THEN
        status:=UART_SLAVE_STATE_MASHINE(%instance_name%_data); 

        IF status= ABSI_STATUS.HAS_DATA THEN
            IF (%instance_name%_data^.buf_pos<%instance_name%_data^.count) THEN
                res := MIN (%instance_name%_data^.count-%instance_name%_data^.buf_pos,size);
                memcpy (data, ADR(%instance_name%_data^.buf[%instance_name%_data^.buf_pos]),res);
                
                size := res;
            ELSE //Ошибка реализации/вызова
                puts('no 3');
                status:= ABSI_STATUS.NO_DATA;  
                %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;  
            END_IF
        END_IF
    //ELSE
    //    puts('G5');
    //    hsal_sleep_for_ms(100); 
    //    status:= ABSI_STATUS.NO_DATA;  
    //    %instance_name%_data^.state:=UART_SLAVE_STATES.RESETING;        
    //END_IF

    
    %instance_name%_data^.status:=status;
    ABSI_COPY_BUFFER_%instance_name%:=status;
END_FUNCTION

//Функции записи в интерфейс
FUNCTION ABSI_SEND_BYTE_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR_INPUT
        data: BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR 
        res: DINT;
        status: ABSI_STATUS:= ABSI_STATUS.NOT_SUPPORT;
    END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_SEND_BYTE_%instance_name%:=status;

		RETURN;
    END_IF
    %instance_name%_data^.state :=UART_SLAVE_STATES.WAIT_PACKET; 
    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        status :=  ABSI_STATUS.NOT_INIT;

        %instance_name%_data^.status:=status;
        ABSI_SEND_BYTE_%instance_name%:=status;
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_SEND_BYTE_%instance_name%:=status;
        RETURN;
    END_IF
    %instance_name%_data^.status:=status;
    ABSI_SEND_BYTE_%instance_name%:=status;
    //В UART для Modbus такое не реализовано
END_FUNCTION

FUNCTION ABSI_SEND_BUFFER_%instance_name% : ABSI_STATUS
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
        data: REF_TO BYTE; (* наличие данных отслеживается по возвращаемому статусу *)
    END_VAR
    VAR_IN_OUT
        size: DWORD; //входное значение -сколько послать, выходное - сколько удалось послать/поместить в очереь передачи
    END_VAR
    VAR 
        res     : DINT;
        status  : ABSI_STATUS:= ABSI_STATUS.NOT_INIT;
        ustemp  : WORD;
        crc     : BYTE;
        pbuf   : REF_TO BYTE;
        ascii_count : DWORD;
        i       : DINT;
    END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_SEND_BUFFER_%instance_name%:=status;

		RETURN;
    END_IF
    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_SEND_BUFFER_%instance_name%:=status;
        puts('S1');
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_SEND_BUFFER_%instance_name%:=status;
        puts('S2');
        RETURN;
    END_IF
    IF ((data=0)OR(size=0)OR(size>248)) THEN 
        status:= ABSI_STATUS.ERROR_IN_DATA;
        %instance_name%_data^.status:=status;
        ABSI_SEND_BUFFER_%instance_name%:=status;
        puts('S3');
        RETURN;
    END_IF
    //printf('state on send=%d$N', %instance_name%_data^.state);
    CASE %instance_name%_data^.state OF
            UART_SLAVE_STATES.WORK:
            //puts('send');
            //Если ASCII - то преобразуем, иначе копируем в буфер как есть
            memset(ADR(%instance_name%_data^.buf[0]),16#FF,256);
            IF %instance_name%_data^.protocol = UART_PROTOCOLS.MODBUS_ASCII THEN
                crc := LRC(data,size);
                //Злобный хакерский трюк:
                //printf(' crc=%02x ', crc);
                (data+size)^:=crc;
                size := size + 1;
                //далее на ходу перекодируем в ASCII 
                pbuf := ADR(%instance_name%_data^.buf[0]);
                pbuf^ := 16#3A; //':';
                ascii_count := 1;

                pbuf := ADR(%instance_name%_data^.buf[0]) + ascii_count;
                
                ascii_count:= ascii_count + ConvertToASCIIModBus(pbuf,data,size); //С /r/n
                pbuf := ADR(%instance_name%_data^.buf[0]) + ascii_count;
                
                pbuf^ := 16#0D;
                (pbuf+1)^ := 16#0A;
                %instance_name%_data^.count := ascii_count+2;
                size:=ascii_count;
            ELSE
                memcpy(%instance_name%_data^.buf,data,size);
                //Добавим CRC
                ustemp:=ModBusCalc(%instance_name%_data^.buf,size);
                %instance_name%_data^.buf[size] := SHR(ustemp,8) AND 16#00FF;
                %instance_name%_data^.buf[size+1] :=ustemp AND 16#00FF;
                size :=size +2; //- размер CRC
                %instance_name%_data^.count := size;
            END_IF 
            //отсылаем
            //printf('send[%d]$N', %instance_name%_data^.count);
            //FOR i:=0 TO %instance_name%_data^.count-1 DO
            //    printf('%02x ',%instance_name%_data^.buf[i]);
            //END_FOR;
            //printf('$N');
            
            res := %instance_name%_data^.pport^.write^(%instance_name%_data^.pport,%instance_name%_data^.buf,%instance_name%_data^.count,0);
    ELSE
        puts('S4');        
    END_CASE

    
    //переходим в режим поиска нового пакета
    //ABSI_CLEAR_%instance_name%(0);
    %instance_name%_data^.state :=UART_SLAVE_STATES.WAIT_PACKET; 

    %instance_name%_data^.status:=status;
    ABSI_SEND_BUFFER_%instance_name%:=status;
END_FUNCTION

//Функции контроля
FUNCTION ABSI_USE_%instance_name% : ABSI_STATUS //Захватывает интерфейс - 
//для многопользовательских блокирует его на посл. открытие до вызова CLOSE, остальные функции становятся доступными только захватившему
//для однопользовательских (например сокет/файл) - открывает/закрывает или соединяется/разъединяется
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
	VAR
		ret     : DINT;
        status  : ABSI_STATUS:=  ABSI_STATUS.NOT_INIT;
        config  : hsal_serial_settings;
        ex_config: hsal_serial_ex_settings;
	END_VAR
    if (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_USE_%instance_name%:=status;

		RETURN;
    END_IF

    IF (%instance_name%_data^.pport = 0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_USE_%instance_name%:=status;
        puts('UL1');
		RETURN;
    END_IF

    IF (%instance_name%_data^.pport^.is_open^(%instance_name%_data^.pport) = FALSE) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_USE_%instance_name%:=status;
        puts('UL1.5');
		RETURN;
    END_IF
    //puts('@1');
    %instance_name%_mutex.lock^(ADR(%instance_name%_mutex));
    IF (%instance_name%_data^.lock_inst<>(-1)) THEN //Проверяем свободен ли?
        IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
            status:= ABSI_STATUS.BUSY;
            %instance_name%_data^.status:=status;
            ABSI_USE_%instance_name%:=status;
            %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));
            puts('UL2');
            RETURN;
        END_IF
    END_IF    

    //Настраиваем
    ret := %instance_name%_Configure(%instance_name%_data^.pport);

    //Пробуем захватить (теоретически он может быть захвачен другим процессом/потоком за пределами компонента - например отладкой)
   
    ret := %instance_name%_data^.pport^.acquire^(%instance_name%_data^.pport);
    IF ret < 0 THEN
        printf('acquire error=%d$n',ret);
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_USE_%instance_name%:=status;
        %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));
        puts('UL3');
        RETURN;
    END_IF;
    //puts('ASQ OK');

    IF ret < 0 THEN
        status:= ABSI_STATUS.NOT_WORK;
        %instance_name%_data^.status:=status;
        ABSI_USE_%instance_name%:=status;
        %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));
        puts('UL4');
        RETURN;
    END_IF;

    %instance_name%_data^.lock_inst:=%NN%; //Лочим порт на этом экземпляре компонента
    //printf('lock=%d$N',%instance_name%_data^.lock_inst);
    %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));

    %instance_name%_data^.state:=UART_SLAVE_STATES.CREATED;
    status:= ABSI_STATUS.NO_DATA;

    %instance_name%_data^.status:=status;
    ABSI_USE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_RELEASE_%instance_name% : ABSI_STATUS //Освобождает интерфейс - 
//для многопользовательских освобождает ресурс
//для однопользовательских (например сокет/файл) - открывает/закрывает или соединяется/разъединяется
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        ret     : DINT;
        status: ABSI_STATUS:=  ABSI_STATUS.NOT_INIT;
    END_VAR
    //puts('R');
    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_RELEASE_%instance_name%:=status;
		RETURN;
    END_IF
    
    %instance_name%_mutex.lock^(ADR(%instance_name%_mutex));
    IF (%instance_name%_data^.lock_inst<>(-1)) THEN //Проверяем свободен ли?
        IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
            status:= ABSI_STATUS.BUSY;
            %instance_name%_data^.status:=status;
            ABSI_RELEASE_%instance_name%:=status;
            %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));
            RETURN;
        END_IF
    END_IF 
    
    ret := %instance_name%_data^.pport^.release^(%instance_name%_data^.pport);
    IF ret < 0 THEN
        printf('release error=%d$n',ret);
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_RELEASE_%instance_name%:=status;
        %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));
        puts('UL8');
        RETURN;
    END_IF;   

    %instance_name%_data^.state:= UART_SLAVE_STATES.NOT_USED;
    
    %instance_name%_data^.lock_inst:=-1; //Разлочим порт
    %instance_name%_mutex.unlock^(ADR(%instance_name%_mutex));

    %instance_name%_data^.status:=status;
    ABSI_RELEASE_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_CLEAR_%instance_name% : ABSI_STATUS //ОЧищает все буфера
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR 
        ret: DINT;
        buffer: ARRAY [0..255] OF BYTE;
        status: ABSI_STATUS:=  ABSI_STATUS.NOT_INIT;
    END_VAR
    IF (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_CLEAR_%instance_name%:=status;

		RETURN;
    END_IF

    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_CLEAR_%instance_name%:=status;
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
        ABSI_CLEAR_%instance_name%:=status;
        RETURN;
    END_IF
    %instance_name%_data^.state :=UART_SLAVE_STATES.WAIT_PACKET; 

    ret := %instance_name%_data^.pport^.purge^(%instance_name%_data^.pport);
    IF ret=0 THEN
        ABSI_CLEAR_%instance_name%:= ABSI_STATUS.NO_DATA;
    ELSE
        ABSI_CLEAR_%instance_name%:= ABSI_STATUS.ERROR_IN_DATA; 
    END_IF;

    %instance_name%_data^.status:=status;
    ABSI_CLEAR_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_CLEAR_RB_%instance_name% : ABSI_STATUS //ОЧищает буфера приёма
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        status: ABSI_STATUS:=  ABSI_STATUS.NOT_INIT;
    END_VAR
    IF (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_CLEAR_RB_%instance_name%:=status;

		RETURN;
    END_IF
    status:= ABSI_CLEAR_%instance_name% (timeout);

    %instance_name%_data^.status:=status;
    ABSI_CLEAR_RB_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_CLEAR_WB_%instance_name% : ABSI_STATUS //ОЧищает буфера передачи
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        status: ABSI_STATUS:= ABSI_STATUS.NOT_INIT;
    END_VAR
    IF (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_CLEAR_WB_%instance_name%:=status;

		RETURN;
    END_IF

    status:= ABSI_CLEAR_%instance_name% (timeout);

    %instance_name%_data^.status:=status;
    ABSI_CLEAR_WB_%instance_name%:=status;
END_FUNCTION

FUNCTION ABSI_RESET_%instance_name% : ABSI_STATUS //Сбрасывает/переинициализирует интерфейс - реализация на аппаратном/драйверном уровне зависит от типа интерфейса
    VAR_INPUT
        timeout: DWORD; (* Таймаут ожидания в мс, 0 - неблокирующая, 16#FFFFFFFF - бесконечно *)
    END_VAR
    VAR
        ret: DINT;
        status: ABSI_STATUS:= ABSI_STATUS.NOT_WORK;
    END_VAR
    IF (%instance_name%_data^.enabled=FALSE) THEN 
        ABSI_RESET_%instance_name%:=status;

		RETURN;
    END_IF

    IF (%instance_name%_data^.pport=0) THEN //Что-то не так
        %instance_name%_data^.status:=status;
        ABSI_RESET_%instance_name%:=status;
		RETURN;
    END_IF

    IF (%instance_name%_data^.lock_inst<>%NN%) THEN 
        status:= ABSI_STATUS.BUSY;
        %instance_name%_data^.status:=status;
         ABSI_RESET_%instance_name%:=status;
        RETURN;
    END_IF
    //puts('Reset');
    %instance_name%_data^.state :=UART_SLAVE_STATES.WAIT_PACKET; 
    %instance_name%_data^.pport^.purge^(%instance_name%_data^.pport);
    %instance_name%_data^.pport^.close^(%instance_name%_data^.pport);
    %instance_name%_data^.pport^.reset^(%instance_name%_data^.pport);
    //Открываем
    ret := %instance_name%_data^.pport^.open^(%instance_name%_data^.pport, hsal_serial_ports_e.PORT_%UART_PORT_NUMBER%);
    IF ret <> 0 THEN //Упс
            %instance_name%_data^.state := UART_SLAVE_STATES.IN_ERROR;
            ABSI_RESET_%instance_name%:=status;
            puts('E40');
            RETURN;
    END_IF
    
    //Настраиваем
    ret := %instance_name%_Configure(%instance_name%_data^.pport);
    IF ret <> 0 THEN //Упс2
            %instance_name%_data^.state := UART_SLAVE_STATES.IN_ERROR;
            ABSI_RESET_%instance_name%:=status;
            puts('E41');
            RETURN;
    END_IF
    status:= ABSI_STATUS.NO_DATA;
    %instance_name%_data^.status:=status;
    ABSI_RESET_%instance_name%:=status;
END_FUNCTION

FUNCTION AXXI_SET_EXTENDED_%instance_name% : ABSI_STATUS //передаёт в интерфейс расширенные настройки
    VAR_INPUT
        preq: REF_TO AXXI_EXTENDED_SERVICES;
    END_VAR
    VAR
        ex  : REF_TO ABSI_EXTENDED_SERVICES;
        ex_t  : REF_TO ABSI_EXTENDED_SERVICES_TIMEOUT;
    END_VAR

    AXXI_SET_EXTENDED_%instance_name%:= ABSI_STATUS.HAS_DATA;
    CASE preq^.service OF
        ABSI_SERVICES.SLAVE_ADR: 
            ex:= CAST (preq, REF_TO ABSI_EXTENDED_SERVICES);
            %instance_name%_data^.slaveadr :=  Pass_par_value_DINT(%instance_name%_data^.slaveadr, ex^.address, 0, 255);
    ELSE
        AXXI_SET_EXTENDED_%instance_name%:= ABSI_STATUS.EXT_SER_NOT_SUPP;
    END_CASE;

END_FUNCTION


FUNCTION AXXI_GET_EXTENDED_%instance_name% : ABSI_STATUS //считывает из интерфейса расширенные настройки
	VAR_IN_OUT
		req : AXXI_EXTENDED_SERVICES;
	END_VAR
    VAR
        ex  : REF_TO ABSI_EXTENDED_SERVICES;
        ex_t  : REF_TO ABSI_EXTENDED_SERVICES_TIMEOUT;
    END_VAR

    AXXI_GET_EXTENDED_%instance_name%:= ABSI_STATUS.HAS_DATA;
    CASE req.service OF
        ABSI_SERVICES.SLAVE_ADR: 
            ex:= ADR(req);
            ex^.address:=%instance_name%_data^.slaveadr;
    ELSE
        AXXI_GET_EXTENDED_%instance_name%:= ABSI_STATUS.EXT_SER_NOT_SUPP;
    END_CASE;

END_FUNCTION


FUNCTION %instance_name%_Configure : DINT
VAR_INPUT 
	serial  	:REF_TO HSAL_Serial;
END_VAR
VAR
    config      : hsal_serial_settings;
    ex_config   : hsal_serial_ex_settings;
    pdata        : REF_TO DWORD;
    pbdata       : REF_TO BYTE;
    i           : DINT;
END_VAR
    //Настраиваем
    memset(ADR(config), 16#00, sizeof(config));
    //printf('sizeof(config)=%d$N',sizeof(config));
    config.port := hsal_serial_ports_e.PORT_%UART_PORT_NUMBER%;
    config.stopbits := %instance_name%_data^.Stopbit;
    config.parity := %instance_name%_data^.Parity;
    config.baudrate := %instance_name%_data^.Bodrate;
    /*pdata := ADR(config);
    FOR i:=1 TO sizeof(config)/sizeof(DWORD) DO
        printf('%08lx ',pdata^);
        pdata := pdata + 1;
    END_FOR;
    printf('$N');*/
    
    memset(ADR(ex_config), 16#00, sizeof(ex_config));
    //printf('sizeof(ex_config)=%d$N',sizeof(ex_config));
    ex_config.byte_size := %instance_name%_data^.Bitsize;
    ex_config.binary_mode := TRUE;

    /*pbdata := ADR(ex_config);
    FOR i:=1 TO sizeof(ex_config) DO
        printf('%02lx ',pbdata^);
        pbdata := pbdata + 1;
    END_FOR;
    printf('$N');*/

    %instance_name%_Configure := serial^.configure^(serial, ADR(config),ADR(ex_config));
    //printf('confres=%d ',%instance_name%_Configure);
END_FUNCTION
