
VAR_GLOBAL
	{%declare_task_data@O@Ltask%}
	{%declare_prg_data@Ltask%}
	//Т.к. операция атомарная - нужды в мютексах  нет
	//переменная для статуса задачи
	%task_name%_PLC_PRG_status :_PRG_status :=_PRG_status.NOT_TOUCHED;
	//переменная для управления задачей
	%task_name%_PLC_PRG_control :_PRG_control :=_PRG_control.STOP;
	%task_name%_PLC_PRG_thread :HSAL_Thread;
END_VAR

{%define_task_function@O@Ltask%}

{%declare_task_function@O@Ltask%}

{%define_prg_function@Ltask%}

{%declare_prg_function@Ltask%}



VAR_GLOBAL CONSTANT
    
END_VAR

FUNCTION  %task_name%_START_PRG_INIT : VOID
//VAR_INPUT 
//	args: REF_TO VOID; 
//END_VAR
	puts('Start %task_name%');
	{%init_task_ptr@Ltask%}
	{%init_prg_ptr@Ltask%}
	{%init_prg@Ltask%}
END_FUNCTION


FUNCTION  %task_name%_RESTART_PRG_INIT : VOID
//VAR_INPUT 
//	args: REF_TO VOID; 
//END_VAR
	puts('Restart %task_name%');
	{%init_task_ptr@O@Ltask%}
	{%init_prg_ptr@O@Ltask%}
END_FUNCTION


FUNCTION  %task_name%_STOP_PRG_DEINIT : VOID
//VAR_INPUT 
//	args: REF_TO VOID; 
//END_VAR
    puts('Deinit %task_name%');
	{%deinit_prg@O@Ltask%}
	{%deinit_prg_ptr@O@Ltask%}
	{%deinit_task_ptr@O@Ltask%}
END_FUNCTION

FUNCTION  %task_name%_RUN_PRG_Wrapper : VOID
VAR_INPUT 
	args: REF_TO VOID; 
END_VAR
	WHILE (NOT INIT_OK) DO
		 hsal_sleep_for_ms(10);
	END_WHILE;
	%task_name%_RUN_PRG();
END_FUNCTION


VAR_GLOBAL
	%task_name%_PERIOD 		: DWORD := %value(0)%; (*mks*)
	%task_name%_PRIORITY 	: WORD := %value(1)%;
	%task_name%_COUNT 		: DWORD := %value(2)%;
	%task_name%_LAST_JOB_PERIOD: DWORD; //В мкс, время исполнения всех задач таска
	%task_name%_JITTER: DINT;		//В мкс, задержка/опережение исполнения таска
	%task_name%_JITTER_MAX	: DINT:=0;		//В мкс, задержка/опережение исполнения таска выброс максимальный по модулю
	%task_name%_JOB_PERIOD_MAX: DWORD :=0; //В мкс, максимальное время исполнения всех задач таска
	%task_name%_temp_control :_PRG_control := _PRG_control.STOP;
	%task_name%__last_control :_PRG_control := _PRG_control.STOP;
END_VAR

FUNCTION %task_name%_RUN_PRG : BYTE
VAR

	%task_name%_delay :LWORD;
	%task_name%_enter_job_time:LWORD;//В мкс
	%task_name%_exit_job_time:LWORD;//В мкс
	%task_name%_temp_time:LWORD;
	%task_name%_temp:DINT;
	%task_name%_prg_status:BOOL:=TRUE ; //FALSE=программа закончилась
	%task_name%_ideal_start_time: LWORD;
	control : STACK_CONTROL := (name:='%task_name%_task');
END_VAR

	IF (%task_name%_PERIOD>0) THEN
		printf('Init task %task_name% with %d ms, %d prio and count %d$N',%task_name%_PERIOD,%task_name%_PRIORITY,%task_name%_COUNT);
		{%set_initial_count@Lprogramm%}
		//инициализация цикловых переменных
		%task_name%_enter_job_time:=hsal_gettime_us();
		
		WHILE (%task_name%_prg_status=TRUE) DO
			CONTROL_STACK(ADR(control));
			//printf('Task %task_name% sleep to %ld$N',%task_name%_enter_job_time+(%task_name%_delay));
			%task_name%_temp_time:=hsal_gettime_us();
			%task_name%_ideal_start_time:=%task_name%_enter_job_time+%task_name%_PERIOD;
			%task_name%_delay:= %task_name%_ideal_start_time-%task_name%_temp_time;
			//printf('Sl=%ld St=%ld P=%ld I=%ld$N',%task_name%_delay,%task_name%_temp_time,%task_name%_PERIOD,%task_name%_ideal_start_time);
			/*Если не опоздали и это не первый запуск */
			IF (%task_name%_delay<=(%task_name%_PERIOD)) AND (%task_name%_delay>0) THEN 
				hsal_sleep_for_us((%task_name%_delay));
			END_IF

			//Начало работы
			VAR_ACCESS_INCR();
			%task_name%_enter_job_time:=hsal_gettime_us();
			//Вычисляем джиттер
			%task_name%_JITTER:=DINT#(%task_name%_enter_job_time-%task_name%_ideal_start_time);
			//printf('Ct=%ld Jt=%ld$N',%task_name%_enter_job_time,%task_name%_JITTER);
			
			//IF (%task_name%__last_control<>%task_name%_temp_control) THEN
			//	printf ('%task_name% l=%d n=%d$N',%task_name%__last_control,%task_name%_temp_control);
			//END_IF
			IF (%task_name%_temp_control=_PRG_control.STOP) THEN 
				;
			ELSE
				{%task_SyncInput@O%}
				FORCE_VAR_CYCLIC();
				//puts('.');
				{%call_prg@Lprogramm%} //Все программy в таске. Внутри шаблона программы есть код для запуска и подсчёта циклов
				FORCE_VAR_CYCLIC();
				{%task_SyncOutput@O%}
			END_IF
			%task_name%__last_control := %task_name%_temp_control;
			//Конец работы
			%task_name%_exit_job_time:=hsal_gettime_us();
			//Вычисляем статистику
			%task_name%_LAST_JOB_PERIOD:=DWORD#(%task_name%_exit_job_time-%task_name%_enter_job_time);

			%task_name%_temp:=ABS__DINT(%task_name%_JITTER);
			IF (%task_name%_temp>%task_name%_JITTER_MAX) THEN 
				%task_name%_JITTER_MAX:=%task_name%_temp;
				//printf('Max jitter %task_name% takes %d mks$N',%task_name%_JITTER_MAX);
			END_IF

			%task_name%_temp:=DINT#%task_name%_LAST_JOB_PERIOD;
			IF (%task_name%_temp>%task_name%_JOB_PERIOD_MAX) THEN 
				%task_name%_JOB_PERIOD_MAX:=DWORD#%task_name%_temp;
				//printf('Max duration %task_name% = %d mks$N',%task_name%_JOB_PERIOD_MAX);
			END_IF
			VAR_ACCESS_DECR_AND_SIGNAL();
			//printf('Task %task_name% takes %d[%d] mks $N',%task_name%_LAST_JOB_PERIOD,%task_name%_JITTER);
		END_WHILE
		printf('Task %task_name% ended$N');
		%task_name%_PLC_PRG_status:=_PRG_status.CLOSED; //Программа того, закончилась...
		WHILE(TRUE) DO
			hsal_sleep_for_ms(1000);
		END_WHILE
    ELSE 
		printf('%task_name% task has wrong %d ms$N',%task_name%_PERIOD);
		%task_name%_PLC_PRG_status:=_PRG_status.GENERAL_ERROR; //Ошибка настройки периода
	END_IF
END_FUNCTION


