VAR_GLOBAL
	%name%_data:PLC210_1X_DATA(*:=(
		in_component:= _hsal_di_pointer,
		out_component:= _hsal_do_pointer
	)*);
	_%name%_enter_if:FAL_ENTER_IF:= (
		inst_data:=%I%,	
		GetContext:=ADR(_%name%_GetContext) ,
		InitFal:=ADR(_%name%_InitFal),
		DeInitFal:=ADR(_%name%_DeInitFal),
		CheckFal:=ADR(_%name%_CheckFal),
		GetIface:=ADR(_%name%_GetIface)
	);
	%name%_enter_if:REF_TO FAL_ENTER_IF;//:=ADR(_%name%_enter_if;
	_%name%_if:PLC210_1X_IF:= (
		Get_status:=ADR(_%name%_Get_status),
		Get_status:=ADR(_%name%_Get_status),
		Get_Input:=ADR(_%name%_Get_Input),
		Set_Output:=ADR(_%name%_Set_Output)
	);
END_VAR



FUNCTION _%name%_Setup : FAL_STATUS

	%name%_enter_if:=ADR(_%name%_enter_if);
	%name%_data.in_component:= _hsal_di_pointer;
	%name%_data.out_component:= _hsal_do_pointer;
	_%name%_Setup:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%name%_InitFal : FAL_STATUS
VAR_INPUT 
	inst_data: DWORD;
END_VAR
VAR_IN_OUT
	inst: FAL_HANDLE;
END_VAR
	assert ('Error! _%name%_Setup() must be run at first!',%name%_enter_if=ADR(_%name%_enter_if));
    inst:=%name%_enter_if;
	//Задаём значения входных элементов при старте
	_%name%_Set_Output(5,%value(5)%);
    _%name%_InitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%name%_DeInitFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR
	_%name%_DeInitFal:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%name%_CheckFal : FAL_STATUS
VAR_INPUT
	iface:REF_TO FAL_HANDLE;
END_VAR	
	_%name%_CheckFal:=FAL_STATUS.OK;
END_FUNCTION



FUNCTION _%name%_GetIface : REF_TO VOID
VAR_INPUT {ref}
	iface_name: STRING;
END_VAR	
	_%name%_GetIface:=NULL;
	if ( STRING_EQUAL(PLC210_1X_IF_NAME,iface_name)) THEN
		_%name%_GetIface:=ADR(_%name%_if);
	END_IF
	
END_FUNCTION



FUNCTION _%name%_GetContext : REF_TO VOID
VAR_INPUT
	inst_data: DWORD; //Данные для идентификации экземпляра (для статических членов не используется)
END_VAR
	_%name%_GetContext:=ADR(%name%_data);
END_FUNCTION



//реализация интерфейса к IO
FUNCTION _%name%_Get_status : FAL_STATUS
VAR_INPUT
	num: USIZE; 
END_VAR	
	_%name%_Get_status:=FAL_STATUS.OK;
END_FUNCTION

FUNCTION _%name%_Get_Input : BOOL
VAR_INPUT 
	num: BYTE; //Index входа
END_VAR
VAR 
	io_index:DWORD;
END_VAR
	if (num> SIZEOF(PLC210_1X_INTERNAL_IO) / SIZEOF(PLC210_1X_INTERNAL_IO[0])) THEN
		_%name%_Get_Input:=FALSE;
		RETURN;
	END_IF
	io_index:=PLC210_1X_INTERNAL_IO[num].num;
	if (PLC210_1X_INTERNAL_IO[num].dir=TRUE) THEN //Читаем из соответствующего IO
		 _%name%_Get_Input:=%name%_data.in_component^.get^(io_index)<>0;
	ELSE
		 _%name%_Get_Input:=CAST(16#01 AND %name%_data.out_component^.get^(io_index),BOOL);	
	END_IF
END_FUNCTION

FUNCTION _%name%_Set_Output : FAL_STATUS
VAR_INPUT 
	num: BYTE; //index выхода
	val:BOOL;
END_VAR
VAR 
	io_index:DWORD;
END_VAR
	IF (num> SIZEOF(PLC210_1X_INTERNAL_IO) / SIZEOF(PLC210_1X_INTERNAL_IO[0])) THEN
		_%name%_Set_Output:=FAL_STATUS.ERROR_INIT;
		RETURN;
	END_IF
	io_index:=PLC210_1X_INTERNAL_IO[num].num;
	if (PLC210_1X_INTERNAL_IO[num].dir=FALSE) THEN //Записываем только выходные данные
		 %name%_data.out_component^.set^(io_index,val<>0);
	END_IF
	_%name%_Set_Output:=FAL_STATUS.OK;
END_FUNCTION


